<?php
class Insert_offplanController extends Controller
{

    // access rules for this controller
    public function accessRules()
    {
        return array(
            // allow all users on all actions
            array('allow'),
        );
    }
    public function downloadImage($url, $dir)
    {
        $hashName = 'apiimg_' . md5($url); // consistent name for same URL
        $extension = pathinfo(parse_url($url, PHP_URL_PATH), PATHINFO_EXTENSION);
        $fileName = $hashName . ($extension ? '.' . $extension : '');

        $savePath = Yii::getPathOfAlias('root.uploads.' . $dir) . DIRECTORY_SEPARATOR . $fileName;

        if (file_exists($savePath)) {
            // File already downloaded
            return $fileName;
        }

        $imageData = @file_get_contents($url);

        if ($imageData !== false) {
            if (!is_dir(dirname($savePath))) {
                mkdir(dirname($savePath), 0755, true);
            }

            file_put_contents($savePath, $imageData);
            return $fileName;
        }

        return false; // or handle error
    }
    public   function normalizeLocation($input)
    {
        return trim(preg_replace('/\s*\(.*?\)/', '', $input));
    }
    public function normalizeDeveloper($input)
    {
        $input = strtolower(trim($input));

        // Map common variations to official names
        $developerMap = [
            'emaar' => 'EMAAR Properties',
            'emar'  => 'EMAAR Properties',
            'damac'  => 'DAMAC Properties',
            'danube'  => 'Danube Properties',
            'nakheel'  => 'NAKHEEL Properties',
            'aldar'  => 'Aldar Properties',
            'azizi'  => 'Azizi Developments',
            // Add more if needed
        ];

        return isset($developerMap[$input]) ? $developerMap[$input] : ucwords($input);
    }
    public   function getYearFromDate($datetime)
    {
        // Assumes format like "YYYY-MM-DDTHH:MM:SS"
        $timestamp = strtotime($datetime);
        return $timestamp ? date('Y', $timestamp) : null;
    }
    public   function getDateFromDate($datetime)
    {
        // Assumes format like "YYYY-MM-DDTHH:MM:SS"
        $timestamp = strtotime($datetime);
        return $timestamp ? date('Y-m-d', $timestamp) : null;
    }
    private $autoId = 1;
    private $pay_plan = '';

    public function formatPaymentPlan($rawData, $planName = 'Plan A')
    {
        $id = $this->autoId++;
        $this->pay_plan =''; 
        $result = [
            $id => [
                'title' => $planName,
                'title_ar' => '',
                'percentage' => [],
                'description' => [],
                'description_Ar' => [],
            ],
        ];

        if (isset($rawData[0]['Payments']) && is_array($rawData[0]['Payments'])) {
            foreach ($rawData[0]['Payments'] as $paymentGroup) {
                if (isset($paymentGroup[0])) {
                    $payment = $paymentGroup[0];

                    $percent = isset($payment['Percent_of_payment']) ? trim($payment['Percent_of_payment']) : '';
                    $desc    = isset($payment['Payment_time']) ? trim($payment['Payment_time']) : '';

                    if ($percent === '' || $desc === '') {
                        continue;
                    }

                    $result[$id]['percentage'][] = (float)$percent;
                    $this->pay_plan .=  (float)$percent. '/' ;
                    $result[$id]['description'][] = $desc;
                    $result[$id]['description_Ar'][] = '';
                }
            }
        }

        return $result;
    }
    public function actionApi_insert()
    {

        header("Access-Control-Allow-Origin: *"); // or restrict to your domain
        header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
        header("Access-Control-Allow-Methods: POST, OPTIONS");

        if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
            // Exit early on preflight request
            Yii::app()->end();
        }
        Yii::app()->request->enableCsrfValidation = false;
        $agent = ListingUsers::model()->findByPk('1019');
        if (Yii::app()->request->isPostRequest) {
            $rawData = Yii::app()->request->getParam('data');
            $decodedData = json_decode($rawData, true);
            $record = '0';
            $title = 'Processing';
            if (is_array($decodedData)) {
                foreach ($decodedData as $projectId => $projectData) {
                    /*
                    if ($projectId != '2519') {
                        continue;
                    }
                        */
                    $amenities  = [];
                    if (!empty($projectData['facilities'])) {
                        $amenities   =   $this->getAmenties($projectData['facilities']);
                    };
                    $plan_data = ''; 
                    if (!empty($projectData['payment_plans'])) {
                       $plan_data =  $this->formatPaymentPlan($projectData['payment_plans'], 'Payment Plan');
                       
                    } 
                    //facilities
                    //cover_image_url
                    $title = 'Processing ' . $projectId;
                    $images  = [];
                    foreach ($projectData['architecture'] as $img) {
                        $images[]  =   $this->downloadImage($img['url'], 'images');
                    }
                    if(!empty($plan_data)){
                        $data['payment_plan']  =   serialize($plan_data);
                        $data['pay_plan']  =    rtrim($this->pay_plan,"/");
                    }
                    $units_types = [] ;
                    if (!empty($projectData['unit_blocks'])) {
                        $units_types = $this->fetchunit_blocks($projectData['unit_blocks']); 

                    }
                    $data['api_id']  =   $projectId;
                    $data['ad_title'] =   $projectData['name'];
                    $data['location_latitude'] =   $this->convertLatitudeLongitude($projectData['coordinates'],'lat');
                    $data['location_longitude'] =   $this->convertLatitudeLongitude($projectData['coordinates'], 'lng');
                    $data['c_img'] =   $this->downloadImage($projectData['master_plan']['0']['url'], 'ads'); 
                    $data['ad_description'] =   $projectData['overview'];
                    $data['price'] =   $projectData['min_price_aed'];
                    $data['price'] =   $projectData['min_price_aed'];
                    $data['completion_date'] =   $this->getDateFromDate($projectData['completion_datetime']);
                    $data['c1'] =  $this->findMaster($this->getYearFromDate($projectData['completion_datetime']), '5');
                    $data['agent_name'] =   $agent->fullName;
                    $data['mobile_number'] =   $agent->phone;
                    $data['agent_logo'] =   null; // $agent->image;
                    $data['d_logo'] =   $this->downloadImage($projectData['developer_data']['logo_image']['0']['url'], 'ads');; // $agent->image;
                    $data['developer_id'] =  $this->findDeveloper($this->normalizeDeveloper(strtolower($projectData['developer'])), $projectData['developer_data']);

                    $data['bg_img'] = $this->downloadImage(json_decode($projectData['cover_image_url'])->url, 'ads');
                    // print_R($data['bg_img']);exit;  
                    $data['country'] = $this->findCountry($projectData['country']);
                    list($community_id,$state_id) = $this->findCommunity($projectData['area'], $data['country']);
                    $data['state'] = $state_id;
                    $data['community_id'] = $community_id;
                     
                    $data['project_status'] = $projectData['status'];
                    $data['sale_status'] = $projectData['sale_status'];
                    $data['country_fetched'] = $projectData['country'];
                   
                  
                    // /United Arab Emirates
                    $this->insert_data($data, $images, $amenities, $units_types);
                    //Yii::log("Received Project ID: $projectId", CLogger::LEVEL_INFO);
                    //Yii::log(print_r($projectData, true), CLogger::LEVEL_INFO);
                    $record++;
                }

                echo CJSON::encode(['status' => 'success', 'message' => 'Data received and processed.']);
                Yii::app()->end();
            } else {
                echo CJSON::encode(['status' => 'error', 'message' => 'Invalid JSON data.']);
                Yii::app()->end();
            }
        } else {
            echo CJSON::encode(['status' => 'error', 'message' => 'Invalid request type.']);
            Yii::app()->end();
        }
    }
    public function insert_data($data, $gallery_images, $amenities, $units_types)
    {
        
        $model = PlaceAnAd::model()->findByAttributes(['api_id' => (int)$data['api_id']]);
        if (empty($model)) {
            $model = new PlaceAnAd();
            $model->status     =    'A';
        } 
        $model->attributes = $data;
        $model->section_id =    '3';
        $model->api_id     =    (int)$data['api_id'];
        
        $model->user_id    =    '1019';
        //$model->country    =    '65946';
        $model->state    =   (empty($model->state) and $model->country== '65946') ?  '55367' : $model->state ;
        if(empty($model->slug) ||  $model->isNewRecord ){
            $model->slug  = $this->generateSlug($model->primaryKey, $model->slug, $model->ad_title);
        }
        if ($model->save(false)) {

            AdImage::model()->deleteAll(array("condition" => "ad_id=:ad_id", "params" => array(":ad_id" => (int)$model->id)));
            foreach ($gallery_images as $k) {
                $room_image = new AdImage();
                $room_image->isNewRecord = true;
                $room_image->id = "";
                $room_image->ad_id = $model->id;
                $room_image->image_name =  $k;
                $room_image->save();
            }


         

            AdPropertyTypes::model()->deleteAll(array("condition" => "ad_id=:ad_id", "params" => array(":ad_id" => (int)$model->id)));
            if(!empty($units_types)){ 
                foreach ($units_types as $k) { 
                    $AdPropertyTypes  = new AdPropertyTypes(); 
                    $AdPropertyTypes->isNewRecord = true;
                    $AdPropertyTypes->id = '';
                    $AdPropertyTypes->ad_id  =  $model->id;
                    $AdPropertyTypes->attributes = $k ;
                    if(!$AdPropertyTypes->save()){
                        
                    } 

                }
            }

            AdAmenities::model()->deleteAll(array("condition" => "ad_id=:ad_id", "params" => array(":ad_id" => (int)$model->id)));
            if(!empty($amenities)){
              
                foreach ($amenities as $k) {
                  
                    $am = new AdAmenities();
                    $am->isNewRecord = true;
                    $am->ad_id = $model->id;
                    $am->amenities_id =  $k;
                    $am->save(); 
                }
            }
        }
    }
    public function  actionTest_community(){
        $community = ' Al Shamkha, Abu Dhabi';
        $cName = TRIM($this->normalizeLocation($community));
        $community_parsed = strtolower($cName);
        $criteria = new CDbCriteria;
        $criteria->join = ' inner join {{district}} district on district.district_id = t.district_id ';
        $criteria->join .= ' inner join {{city}} city on city.city_id = district.city_id ';
        $criteria->condition .= '1 and city.state_id = 55367 '; // dubai 
        $criteria->condition .= " AND TRIM(SUBSTRING_INDEX(LOWER(t.community_name), '(', 1)) = :community_name ";
        $criteria->params[':community_name'] = $community_parsed;
        $found = Community::model()->find($criteria);
        print_R($found);exit; 
        
    }
    function parseLocationString($location)
    {
        $parts = array_map('trim', explode(',', $location));
        $count = count($parts);

        if ($count === 3) {
            return [$parts[0], $parts[1], $parts[2]]; // subcommunity, community, state
        } elseif ($count === 2) {
            return [null, $parts[0], $parts[1]]; // community, state
        } elseif ($count === 1) {
            return [null, $parts[0], null]; // community only
        } else {
            return [null, null, null]; // fallback
        }
    }
    //Amaya Properties
   
    public function findCommunity($community1,$country=null)
    {
        $subcommunity_id = null; 
        $community_id = null;
        $state_id = null ;  
        
        list($subcommunity, $community, $state) = $this->parseLocationString($community1);
        if(!empty($state) and !empty($country)){
            
            $criteria = new CDbCriteria;
            $criteria->condition  = "1 AND TRIM(LOWER(t.state_name)) = :state_name and t.country_id = :country_id ";
            $criteria->params[':state_name']    = strtolower(trim($state)) ;  
            $criteria->params[':country_id']    = (int) $country ;  
            $stateModel =  States::model()->find($criteria);
            if(!empty($stateModel)){
                $state_id = $stateModel->primaryKey;
            }
            
        }
         
        $cName = TRIM($this->normalizeLocation($community)); 
        $community_parsed = strtolower($cName);
        $criteria = new CDbCriteria;
        $criteria->join = ' inner join {{district}} district on district.district_id = t.district_id ';
        $criteria->join .= ' inner join {{city}} city on city.city_id = district.city_id ';
        $criteria->condition  = '1';
        if(empty($state_id)){
            $criteria->condition .= '  and city.state_id = 55367 '; // dubai 
        }
        $criteria->condition .= " AND TRIM(SUBSTRING_INDEX(LOWER(t.community_name), '(', 1)) = :community_name ";
        $criteria->params[':community_name'] = $community_parsed;
        $found = Community::model()->find($criteria);
        if (!empty($found)) {
            $community_id =  $found->primaryKey;
        } else {
            $Community = new Community();
            if (empty($state_id)) {
                $Community->district_id = '195528'; //Dubai Communities
            }
            $Community->community_name = $cName;
            $Community->save(false);
            $community_id =  $Community->primaryKey;
        }
        return [$community_id, $state_id];
    }
    public function findDeveloper($developer_name, $detail_array)
    {

        $criteria = new CDbCriteria;
        $criteria->condition  = '1 and LOWER(TRIM(t.developer_name)) = :developer_name ';
        $criteria->params[':developer_name'] = strtolower(trim($developer_name));
        $found = Developers::model()->find($criteria);
        if (!empty($found)) {
            return $found->primaryKey;
        } else {
            $Community = new Developers();
            $Community->developer_name = trim($detail_array['name']); //Dubai Communities
            //      print_r( $detail_array['logo_image']);//['0']['logo_image']; exit; 
            $Community->logo         = $this->downloadImage($detail_array['logo_image']['0']['url'], 'ads');;
            $Community->status         =  'A';
            $Community->description         =   $detail_array['description'];

            $Community->save();
            return $Community->primaryKey;
        }
    }
    public function findMaster($master, $category_id)
    {
        if (!empty($master)) {
            $criteria = new CDbCriteria;
            $criteria->condition  = '1 and LOWER(t.master_name) = :master_name and t.category_id = :category_id ';
            $criteria->params[':master_name'] = strtolower($master);
            $criteria->params[':category_id'] = $category_id;
            $found = Master::model()->find($criteria);
            if (!empty($found)) {
                return $found->primaryKey;
            }
        }
    }
    public function getAmenties($amenities_array)
    {
        $ar = [];
        foreach ($amenities_array as $k) {
            $ar[]   = trim($k['name']);
        }
        $amenties_id = [];
        if ($ar) {
            foreach ($ar as $amenity_name) {
                $criteria = new CDbCriteria;
                $criteria->condition  = '1 and LOWER(t.amenities_name) = :amenities_name ';
                $criteria->params[':amenities_name'] = strtolower($amenity_name);
                $found = Amenities::model()->find($criteria);
                if (!empty($found)) {
                    $amenties_id[] =  $found->primaryKey;
                } else {
                    $Community = new Amenities();
                    $Community->amenities_name = $amenity_name;
                    $Community->f_type         =  '1';
                    
                    $Community->save();
                    $amenties_id[] =  $Community->primaryKey;
                }
            }
            return $amenties_id;
        }
    }
    public function normalizeKeyword($word)
    {
        // Very basic singularizer: remove trailing 's' if plural
        return rtrim(strtolower(trim($word)), 's');
    }
    public function m2ToSqft($m2, $precision = 2)
    {
        return round($m2 * 10.7639, $precision);
    }
    public function fetchunit_blocks($blocks){
 
        $fetch_build = [];
        if ($blocks) {
            foreach ($blocks as $block) {
            
                $category_id = ''; 
                $criteria = new CDbCriteria;
                $criteria->condition  = "1 and LOWER(t.category_name) = :category_name and t.isTrash='0' and t.status='A'";
                $criteria->params[':category_name'] = strtolower($this->normalizeKeyword($block['normalized_type']));
                $found = Category::model()->find($criteria);
               
                if (!empty($found)) {
                    $category_id =  $found->primaryKey;
                }   
                $fetch_build[] = [
                    'type_id' => $category_id,
                    'title' => $block['name'],
                    'size' => $this->m2ToSqft($block['units_area_from_m2']),
                    'price' => $this->m2ToSqft($block['units_price_from_aed']),
                    'image' => $this->downloadImage(json_decode($block['typical_unit_image_url'])[0]->url, 'ads'),
                ];
            } 
            return $fetch_build;
        }
    }
    public function generateSlug($id,$slug, $ad_title)
    {
        Yii::import('common.vendors.Urlify.*');
        $string = !empty($slug) ? $slug : $ad_title;
        $slug = URLify::filter($string);
        $article_id = (int)$id;

        $criteria = new CDbCriteria();
        $criteria->addCondition('id != :id AND slug = :slug');
        $criteria->params = array(':id' => $article_id, ':slug' => $slug);
        $exists = PlaceAnAd::model()->find($criteria);

        $i = 0;
        while (!empty($exists)) {
            ++$i;
            $slug = preg_replace('/^(.*)(\d+)$/six', '$1', $slug);
            $slug = URLify::filter($slug . ' ' . $i);
            $criteria = new CDbCriteria();
            $criteria->addCondition('id != :id AND slug = :slug');
            $criteria->params = array(':id' => $article_id, ':slug' => $slug);
            $exists = PlaceAnAd::model()->find($criteria);
        }

        return $slug;
    }
    public function actionFetched_ids()
    {
        header("Access-Control-Allow-Origin: *");
        header("Access-Control-Allow-Methods: GET, OPTIONS");
        header("Access-Control-Allow-Headers: Content-Type, X-Requested-With");

        if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
            Yii::app()->end();
        }

        // Get IDs from GET query string like ?ids=2709,2486,2519
        $idsParam = isset($_GET['ids']) ? $_GET['ids'] : '';
        $ids = array_filter(array_map('intval', explode(',', $idsParam)));
         

        if (empty($ids)) {
            header('Content-Type: application/json', true, 400);
            echo CJSON::encode(['error' => 'No valid IDs received']);
            Yii::app()->end();
        }

        // Fetch existing project IDs from DB
        $fetchedIds = Yii::app()->db
            ->createCommand()
            ->select('api_id')
            ->from('mw_place_an_ad') // Adjust table name if needed
            ->where(['in', 'api_id', $ids])
            ->queryColumn();

        header('Content-Type: application/json');
        echo CJSON::encode($fetchedIds);
        Yii::app()->end();
    }
    public function findCountry($country)
    {
        $aliasMap = [
            'United Arab Emirates' => 'UAE',
            'USA' => 'United States',
            'UK' => 'United Kingdom',
            // Add more aliases as needed
        ];

        $search = $country;
        $country = $aliasMap[$search] ?? $search;


        $country_parsed = strtolower($country);
        $criteria = new CDbCriteria;
         $criteria->condition  = "   TRIM(SUBSTRING_INDEX(LOWER(t.country_name), '(', 1)) = :country_name ";
        $criteria->params[':country_name'] = $country_parsed;
        $found = Countries::model()->find($criteria);
        
        if (!empty($found)) {
            return $found->primaryKey;
        } 
    }
    public function convertLatitudeLongitude($coordinates, $type = 'lat')
    {
        $parts = explode(',', $coordinates);
        if (count($parts) !== 2) {
            return null; // Invalid format
        }

        $latitude = floatval(trim($parts[0]));
        $longitude = floatval(trim($parts[1]));

        return $type === 'lat' ? $latitude : $longitude;
    }
    public function actionMarkers()
    {
        // Get raw POST data

        header("Access-Control-Allow-Origin: *"); // or restrict to your domain
        header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
        header("Access-Control-Allow-Methods: POST, OPTIONS");

        if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
            // Exit early on preflight request
            Yii::app()->end();
        }
        Yii::app()->request->enableCsrfValidation = false;

        $rawBody = file_get_contents('php://input');
        $data = json_decode($rawBody, true);

        if (json_last_error() !== JSON_ERROR_NONE || !isset($data['markers'])) {
            header('Content-Type: application/json');
            echo CJSON::encode(['status' => 'error', 'message' => 'Invalid JSON or missing markers']);
            Yii::app()->end();
        }

        $markers = $data['markers'];

        foreach ($markers as $marker) {
            $model =  PlaceAnAd::model()->findByAttributes(['api_id'  => (int) $marker['id'] ] ); // replace with your actual model class
            if(!empty($model)){
                $status = ($marker['sale_status']== 'Out of stock') ? 'I' : $model->status ;  
                $model->updateByPk($model->primaryKey, ['project_status'=> $marker['status'], 'status' => $status, 'price' => $marker['min_price'],  'sale_status'=> $marker['sale_status']]);
 
            }
        }

        header('Content-Type: application/json');
        echo CJSON::encode(['status' => 'success', 'message' => 'Markers inserted']);
        Yii::app()->end();
    }
}
