<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * This file is part of the MailWizz EMA application.
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */

/**
 * This hook gives a chance to prepend content or to replace the default view content with a custom content.
 * Please note that from inside the action callback you can access all the controller view
 * variables via {@CAttributeCollection $collection->controller->data}
 * In case the content is replaced, make sure to set {@CAttributeCollection $collection->renderContent} to false 
 * in order to stop rendering the default content.
 * @since 1.3.3.1
 */
$hooks->doAction('before_view_file_content', $viewCollection = new CAttributeCollection(array(
    'controller'    => $this,
    'renderContent' => true,
)));

// and render if allowed
if ($viewCollection->renderContent) {
    /**
     * This hook gives a chance to prepend content before the active form or to replace the default active form entirely.
     * Please note that from inside the action callback you can access all the controller view variables 
     * via {@CAttributeCollection $collection->controller->data}
     * In case the form is replaced, make sure to set {@CAttributeCollection $collection->renderForm} to false 
     * in order to stop rendering the default content.
     * @since 1.3.3.1
     */
    $hooks->doAction('before_active_form', $collection = new CAttributeCollection(array(
        'controller'    => $this,
        'renderForm'    => true,
    )));
    
    // and render if allowed
    if ($collection->renderForm) {
        $form = $this->beginWidget('CActiveForm',array('focus'=>array($model,Yii::app()->controller->focus))); 
        ?>
        <div class="box box-primary">
            <div class="box-header">
                <div class="pull-left">
                    <h3 class="box-title"><span class="glyphicon glyphicon-star"></span> <?php echo $pageHeading;?></h3>
                </div>
                <div class="pull-right">
                    <?php if (!$model->isNewRecord) { ?>
                    <?php echo CHtml::link(Yii::t('app', 'Create new'), array(Yii::app()->controller->id.'/create'), array('class' => 'btn btn-primary btn-xs', 'title' => Yii::t('app', 'Create new')));?>
                    <?php } ?>
                    <?php echo CHtml::link(Yii::t('app', 'Cancel'), array(Yii::app()->controller->id.'/index'), array('class' => 'btn btn-primary btn-xs', 'title' => Yii::t('app', 'Cancel')));?>
                </div>
                <div class="clearfix"><!-- --></div>
            </div>
            <div class="box-body">
                <?php 
                /**
                 * This hook gives a chance to prepend content before the active form fields.
                 * Please note that from inside the action callback you can access all the controller view variables 
                 * via {@CAttributeCollection $collection->controller->data}
                 * @since 1.3.3.1
                 */
                $hooks->doAction('before_active_form_fields', new CAttributeCollection(array(
                    'controller'    => $this,
                    'form'          => $form    
                )));
                ?>
              
               
                <div class="clearfix"><!-- --></div>
                <div class="form-group col-lg-6">
                    <?php echo $form->labelEx($model, 'package_name');?>
                    <?php echo $form->textField($model, 'package_name',$model->getHtmlOptions('package_name')); ?>
                    <?php echo $form->error($model, 'package_name');?>
                </div>   
                <div class="clearfix"><!-- --></div>
                <div class="form-group col-lg-6">
                    <?php echo $form->labelEx($model, 'price_per_month');?>
                    <?php echo $form->textField($model, 'price_per_month',$model->getHtmlOptions('price_per_month')); ?>
                    <?php echo $form->error($model, 'price_per_month');?>
                </div>   
                <div class="clearfix"><!-- --></div>
                <div class="form-group col-lg-6">
                    <?php echo $form->labelEx($model, 'validity_in_days');?>
                    <?php echo $form->textField($model, 'validity_in_days',$model->getHtmlOptions('validity_in_days')); ?>
                    <?php echo $form->error($model, 'validity_in_days');?>
                </div>   
               
                <div class="clearfix"><!-- --></div>
                <div class="form-group col-lg-6">
                    <?php echo $form->labelEx($model, 'max_listing_per_day');?>
                    <?php echo $form->textField($model, 'max_listing_per_day',$model->getHtmlOptions('max_listing_per_day')); ?>
                    <?php echo $form->error($model, 'max_listing_per_day');?>
                </div>   
                <div class="clearfix"><!-- --></div>
               <div class="form-group col-lg-6">
                    <?php echo $form->labelEx($model, 'visitors_can_directly');?>
                     <?php $mer =  array_merge($model->getHtmlOptions('visitors_can_directly'),array('empty'=>"Select")); ?>
                    <?php echo $form->dropDownList($model, 'visitors_can_directly',array("Y"=>"YES","N"=>"NO")   , $mer ); ?>
                    <?php echo $form->error($model, 'visitors_can_directly');?>
                </div> 
                <div class="clearfix"><!-- --></div>        
                <div class="clearfix"><!-- --></div>
               <div class="form-group col-lg-6">
                    <?php echo $form->labelEx($model, 'create_profile_picture');?>
                     <?php $mer =  array_merge($model->getHtmlOptions('create_profile_picture'),array('empty'=>"Select")); ?>
                    <?php echo $form->dropDownList($model, 'create_profile_picture',array("Y"=>"YES","N"=>"NO")   , $mer ); ?>
                    <?php echo $form->error($model, 'create_profile_picture');?>
                </div> 
                <div class="clearfix"><!-- --></div>
               <div class="form-group col-lg-6">
                    <?php echo $form->labelEx($model, 'statistics');?>
                     <?php $mer =  array_merge($model->getHtmlOptions('statistics'),array('empty'=>"Select")); ?>
                    <?php echo $form->dropDownList($model, 'statistics',array("Y"=>"YES","N"=>"NO")   , $mer ); ?>
                    <?php echo $form->error($model, 'statistics');?>
                </div> 
                <div class="clearfix"><!-- --></div>
               <div class="form-group col-lg-6">
                    <?php echo $form->labelEx($model, 'logo');?>
                     <?php $mer =  array_merge($model->getHtmlOptions('logo'),array('empty'=>"Select")); ?>
                    <?php echo $form->dropDownList($model, 'logo',array("Y"=>"YES","N"=>"NO")   , $mer ); ?>
                    <?php echo $form->error($model, 'logo');?>
                </div> 
                <div class="clearfix"><!-- --></div>
               <div class="form-group col-lg-6">
                    <?php echo $form->labelEx($model, 'featured');?>
                     <?php $mer =  array_merge($model->getHtmlOptions('featured'),array('empty'=>"Select")); ?>
                    <?php echo $form->dropDownList($model, 'featured',array("Y"=>"YES","N"=>"NO")   , $mer ); ?>
                    <?php echo $form->error($model, 'featured');?>
                </div> 
                <div class="clearfix"><!-- --></div>        
                
                <div class="clearfix"><!-- --></div>     
                <?php 
                /**
                 * This hook gives a chance to append content after the active form fields.
                 * Please note that from inside the action callback you can access all the controller view variables 
                 * via {@CAttributeCollection $collection->controller->data}
                 * @since 1.3.3.1
                 */
                $hooks->doAction('after_active_form_fields', new CAttributeCollection(array(
                    'controller'    => $this,
                    'form'          => $form    
                )));
                ?> 
                <div class="clearfix"><!-- --></div>
            </div>
            <div class="box-footer">
                <div class="pull-right">
                    <button type="submit" class="btn btn-primary btn-submit" data-loading-text="<?php echo Yii::t('app', 'Please wait, processing...');?>"><?php echo Yii::t('app', 'Save changes');?></button>
                </div>
                <div class="clearfix"><!-- --></div>
            </div>
        </div>
        <?php 
        $this->endWidget(); 
    }
    /**
     * This hook gives a chance to append content after the active form.
     * Please note that from inside the action callback you can access all the controller view variables 
     * via {@CAttributeCollection $collection->controller->data}
     * @since 1.3.3.1
     */
    $hooks->doAction('after_active_form', new CAttributeCollection(array(
        'controller'      => $this,
        'renderedForm'    => $collection->renderForm,
    )));
}
/**
 * This hook gives a chance to append content after the view file default content.
 * Please note that from inside the action callback you can access all the controller view
 * variables via {@CAttributeCollection $collection->controller->data}
 * @since 1.3.3.1
 */
$hooks->doAction('after_view_file_content', new CAttributeCollection(array(
    'controller'        => $this,
    'renderedContent'   => $viewCollection->renderContent,
)));
