<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * This file is part of the MailWizz EMA application.
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */
 
?>
<div class="box box-primary">
    <div class="box-header">
        <h3 class="box-title"><?php echo Yii::t('settings', 'Common settings')?></h3>
    </div>
    <div class="box-body">
        <?php 
        /**
         * This hook gives a chance to prepend content before the active form fields.
         * Please note that from inside the action callback you can access all the controller view variables 
         * via {@CAttributeCollection $collection->controller->data}
         * @since 1.3.3.1
         */
        $hooks->doAction('before_active_form_fields', new CAttributeCollection(array(
            'controller'    => $this,
            'form'          => $form    
        )));
        ?>
        <div class="clearfix"><!-- --></div>
        <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'site_name');?>
            <?php echo $form->textField($commonModel, 'site_name', $commonModel->getHtmlOptions('site_name')); ?>
            <?php echo $form->error($commonModel, 'site_name');?>
        </div>
        <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'copywrite_name');?>
            <?php echo $form->textField($commonModel, 'copywrite_name', $commonModel->getHtmlOptions('copywrite_name')); ?>
            <?php echo $form->error($commonModel, 'copywrite_name');?>
        </div>
        <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'site_tagline');?>
            <?php echo $form->textField($commonModel, 'site_tagline', $commonModel->getHtmlOptions('site_tagline')); ?>
            <?php echo $form->error($commonModel, 'site_tagline');?>
        </div>    
        <?php /*
        <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'site_description');?>
            <?php echo $form->textField($commonModel, 'site_description', $commonModel->getHtmlOptions('site_description')); ?>
            <?php echo $form->error($commonModel, 'site_description');?>
        </div>
        <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'site_keywords');?>
            <?php echo $form->textField($commonModel, 'site_keywords', $commonModel->getHtmlOptions('site_keywords')); ?>
            <?php echo $form->error($commonModel, 'site_keywords');?>
        </div>  
        * */
        ?>
         <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'defalut_currency');?>
            <?php echo $form->textField($commonModel, 'defalut_currency', $commonModel->getHtmlOptions('defalut_currency')); ?>
            <?php echo $form->error($commonModel, 'defalut_currency');?>
        </div>   
         <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'support_phone');?>
            <?php echo $form->textField($commonModel, 'support_phone', $commonModel->getHtmlOptions('support_phone')); ?>
            <?php echo $form->error($commonModel, 'support_phone');?>
        </div>   
         <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'support_email');?>
            <?php echo $form->textField($commonModel, 'support_email', $commonModel->getHtmlOptions('support_email')); ?>
            <?php echo $form->error($commonModel, 'support_email');?>
        </div>   
         <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'admin_email');?>
            <?php echo $form->textField($commonModel, 'admin_email', $commonModel->getHtmlOptions('admin_email')); ?>
            <?php echo $form->error($commonModel, 'admin_email');?>
        </div>   
         <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'contact_phone');?>
            <?php echo $form->textField($commonModel, 'contact_phone', $commonModel->getHtmlOptions('contact_phone')); ?>
            <?php echo $form->error($commonModel, 'contact_phone');?>
        </div>   
        
         <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'contact_email');?>
            <?php echo $form->textField($commonModel, 'contact_email', $commonModel->getHtmlOptions('contact_email')); ?>
            <?php echo $form->error($commonModel, 'contact_email');?>
        </div>   
        
         <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'contact_fax');?>
            <?php echo $form->textField($commonModel, 'contact_fax', $commonModel->getHtmlOptions('contact_fax')); ?>
            <?php echo $form->error($commonModel, 'contact_fax');?>
        </div>   
        
         <div class="form-group col-lg-12">
            <?php echo $form->labelEx($commonModel, 'contact_address');?>
            <?php echo $form->textArea($commonModel, 'contact_address', $commonModel->getHtmlOptions('contact_address')); ?>
            <?php echo $form->error($commonModel, 'contact_address');?>
        </div>   
        
          
        
         <div class="clearfix"><!-- --></div>
       
        <hr />
        <h4><?php echo Yii::t('settings', 'Residetial / Commerical Categories')?></h4>
        <hr />
     
		   <div class="form-group col-lg-6">
										<?php echo $form->labelEx($commonModel, 'commercial_categories');?>
										<div class="container34">
										  <?php
 
											 
											echo CHtml::checkBoxList('commercial_categories',$commonModel->commercial_categories ,CHtml::listData(Category::model()->listData(),'category_id','category_name'));                                              
											?>
										</div>
										<?php echo $form->error($commonModel, 'commercial_categories');?>
									</div>     
        
		   <div class="form-group col-lg-6">
										<?php echo $form->labelEx($commonModel, 'residential_categories');?>
										<div class="container34">
										  <?php
 
											 
											echo CHtml::checkBoxList('residential_categories',$commonModel->residential_categories ,CHtml::listData(Category::model()->listData(),'category_id','category_name'));                                              
											?>
										</div>
										<?php echo $form->error($commonModel, 'residential_categories');?>
									</div>     
        <div class="clearfix"><!-- --></div>
        <hr />
        <h4><?php echo Yii::t('settings', 'Social Pages')?></h4>
        <hr />
        <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'facebook_url');?>
            <?php echo $form->textField($commonModel, 'facebook_url', $commonModel->getHtmlOptions('facebook_url')); ?>
            <?php echo $form->error($commonModel, 'facebook_url');?>
        </div>    
        <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'twitter_url');?>
            <?php echo $form->textField($commonModel, 'twitter_url', $commonModel->getHtmlOptions('twitter_url')); ?>
            <?php echo $form->error($commonModel, 'twitter_url');?>
        </div>    
        <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'pinterest_url');?>
            <?php echo $form->textField($commonModel, 'pinterest_url', $commonModel->getHtmlOptions('pinterest_url')); ?>
            <?php echo $form->error($commonModel, 'pinterest_url');?>
        </div>    
        <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'google_plus_url');?>
            <?php echo $form->textField($commonModel, 'google_plus_url', $commonModel->getHtmlOptions('google_plus_url')); ?>
            <?php echo $form->error($commonModel, 'google_plus_url');?>
        </div>    
        <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'linked_in');?>
            <?php echo $form->textField($commonModel, 'linked_in', $commonModel->getHtmlOptions('linked_in')); ?>
            <?php echo $form->error($commonModel, 'linked_in');?>
        </div>    
          
       <div class="clearfix"><!-- --></div>
       <?php
       /*
        <hr />
        <h4><?php echo Yii::t('settings', 'SMTP Settings')?></h4>
        <hr />
        <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'smtp_host');?>
            <?php echo $form->textField($commonModel, 'smtp_host', $commonModel->getHtmlOptions('smtp_host')); ?>
            <?php echo $form->error($commonModel, 'smtp_host');?>
        </div>    
        <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'smtp_port');?>
            <?php echo $form->textField($commonModel, 'smtp_port', $commonModel->getHtmlOptions('smtp_port')); ?>
            <?php echo $form->error($commonModel, 'smtp_port');?>
        </div>    
        <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'smtp_username');?>
            <?php echo $form->textField($commonModel, 'smtp_username', $commonModel->getHtmlOptions('smtp_username')); ?>
            <?php echo $form->error($commonModel, 'smtp_username');?>
        </div>    
        <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'smtp_password');?>
            <?php echo $form->textField($commonModel, 'smtp_password', $commonModel->getHtmlOptions('smtp_password')); ?>
            <?php echo $form->error($commonModel, 'smtp_password');?>
        </div>    
        * */
        ?>
        <hr />
        <h4><?php echo Yii::t('settings', 'SEO Friendly')?></h4>
        <hr />
        <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'home_meta_title');?>
            <?php echo $form->textField($commonModel, 'home_meta_title', $commonModel->getHtmlOptions('home_meta_title')); ?>
            <?php echo $form->error($commonModel, 'home_meta_title');?>
        </div>    
        <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'home_meta_keywords');?>
            <?php echo $form->textField($commonModel, 'home_meta_keywords', $commonModel->getHtmlOptions('home_meta_keywords')); ?>
            <?php echo $form->error($commonModel, 'home_meta_keywords');?>
        </div>    
        <div class="form-group col-lg-12">
            <?php echo $form->labelEx($commonModel, 'home_meta_description');?>
            <?php echo $form->textArea($commonModel, 'home_meta_description', $commonModel->getHtmlOptions('home_meta_description')); ?>
            <?php echo $form->error($commonModel, 'home_meta_description');?>
        </div>    
        
        <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'facebook_app_id');?>
            <?php echo $form->textField($commonModel, 'facebook_app_id', $commonModel->getHtmlOptions('facebook_app_id')); ?>
            <?php echo $form->error($commonModel, 'facebook_app_id');?>
        </div>    
       
        <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'facebook_seceret_key');?>
            <?php echo $form->textField($commonModel, 'facebook_seceret_key', $commonModel->getHtmlOptions('facebook_seceret_key')); ?>
            <?php echo $form->error($commonModel, 'facebook_seceret_key');?>
        </div>    
        <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'facebook_response_url');?>
            <?php echo $form->textField($commonModel, 'facebook_response_url', $commonModel->getHtmlOptions('facebook_response_url')); ?>
            <?php echo $form->error($commonModel, 'facebook_response_url');?>
        </div> 
         <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'google_map_api_key');?>
            <?php echo $form->textField($commonModel, 'google_map_api_key', $commonModel->getHtmlOptions('google_map_api_key')); ?>
            <?php echo $form->error($commonModel, 'google_map_api_key');?>
        </div>       
          <div class="form-group col-lg-12">
            <?php echo $form->labelEx($commonModel, 'google_analytics_code');?>
            <?php echo $form->textArea($commonModel, 'google_analytics_code', $commonModel->getHtmlOptions('google_analytics_code')); ?>
            <?php echo $form->error($commonModel, 'google_analytics_code');?>
        </div> 
        
        <?php
        /*
        <div class="col-lg-6">
            <div class="form-group<?php if ($commonModel->clean_urls == 1){?> col-lg-8<?php }?>">
                <?php echo $form->labelEx($commonModel, 'clean_urls');?>
                <?php echo $form->dropDownList($commonModel, 'clean_urls', array(0 => Yii::t('app', 'No, do not use clean urls'), 1 => Yii::t('app', 'Yes, use clean urls')), $commonModel->getHtmlOptions('clean_urls')); ?>
                <?php echo $form->error($commonModel, 'clean_urls');?>
            </div>    
            <div class="form-group col-lg-2" style="<?php if ($commonModel->clean_urls != 1){?>display:none<?php }?>">
                <label><?php echo Yii::t('app', 'Action');?></label>
                <a data-toggle="modal" data-remote="<?php echo $this->createUrl('settings/htaccess_modal');?>" href="#writeHtaccessModal" class="btn btn-default"><?php echo Yii::t('settings', 'Generate htaccess')?></a>
            </div>
        </div>
        <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'default_mailer');?>
            <?php echo $form->dropDownList($commonModel, 'default_mailer', $commonModel->getSystemMailers(), $commonModel->getHtmlOptions('default_mailer')); ?>
            <?php echo $form->error($commonModel, 'default_mailer');?>
        </div>
        <div class="clearfix"><!-- --></div>
        <div class="form-group col-lg-3">
            <?php echo $form->labelEx($commonModel, 'api_status');?>
            <?php echo $form->dropDownList($commonModel, 'api_status', $commonModel->getSiteStatusOptions(), $commonModel->getHtmlOptions('api_status')); ?>
            <?php echo $form->error($commonModel, 'api_status');?>
        </div>
        <div class="form-group col-lg-3">
            <?php echo $form->labelEx($commonModel, 'site_status');?>
            <?php echo $form->dropDownList($commonModel, 'site_status', $commonModel->getSiteStatusOptions(), $commonModel->getHtmlOptions('site_status')); ?>
            <?php echo $form->error($commonModel, 'site_status');?>
        </div>
        <div class="form-group col-lg-3">
            <?php echo $form->labelEx($commonModel, 'check_version_update');?>
            <?php echo $form->dropDownList($commonModel, 'check_version_update', $commonModel->getYesNoOptions(), $commonModel->getHtmlOptions('check_version_update')); ?>
            <?php echo $form->error($commonModel, 'check_version_update');?>
        </div>
        <div class="form-group col-lg-3">
            <?php echo $form->labelEx($commonModel, 'site_offline_message');?>
            <?php echo $form->textField($commonModel, 'site_offline_message', $commonModel->getHtmlOptions('site_offline_message')); ?>
            <?php echo $form->error($commonModel, 'site_offline_message');?>
        </div>
        <div class="clearfix"><!-- --></div>
        <hr />
        <h4><?php echo Yii::t('settings', 'Company info')?></h4>
        <hr />
        <div class="form-group col-lg-12">
            <?php echo $form->labelEx($commonModel, 'company_info');?>
            <?php echo $form->textArea($commonModel, 'company_info', $commonModel->getHtmlOptions('company_info', array('rows' => 5))); ?>
            <?php echo $form->error($commonModel, 'company_info');?>
        </div>
        *  * */
        ?>
        
        <div class="clearfix"><!-- --></div>
       
        <hr />
        <h4><?php echo Yii::t('settings', 'Miscellaneous settings')?></h4>
        <hr />
        <div class="clearfix"><!-- --></div>
            <div class="form-group col-lg-3">
            <?php echo $form->labelEx($commonModel, 'hide_projects_from_top_menu');?>
            <?php echo $form->dropDownList($commonModel, 'hide_projects_from_top_menu', $commonModel->getYesNoOptions(), $commonModel->getHtmlOptions('hide_projects_from_top_menu')); ?>
            <?php echo $form->error($commonModel, 'hide_projects_from_top_menu');?>
        </div>
        <?php 
        /*
          <div class="form-group col-lg-6">
                    <?php echo $form->labelEx($commonModel, 'fav_ico');?><b style="color: #5E1A3F"> To be Replaced to (140*140)</b>
                    <?php echo $form->fileField($commonModel, 'fav_ico',$commonModel->getHtmlOptions('commonModel')); ?>
                    <?php echo $form->error($commonModel, 'fav_ico');?>
                </div>  
                <img src="<?php echo Yii::app()->params['uploadDir'];?>/<?php echo $commonModel->fav_ico;?>" id="blah" style="width:50px;height:50px;border:2px solid #eee;<?php if($commonModel->fav_ico==""){echo "display:none;"; };?>" alt="Preview">
           8/
           */ ?>
        <div class="clearfix"><!-- --></div>
        <?php 
        /*
          <div class="form-group col-lg-6">
                    <?php echo $form->labelEx($commonModel, 'logo');?><b style="color: #5E1A3F"> To be Replaced to (134*56)</b>
                    <?php echo $form->fileField($commonModel, 'logo',$commonModel->getHtmlOptions('logo')); ?>
                    <?php echo $form->error($commonModel, 'logo');?>
                </div>  
                <img src="<?php echo Yii::app()->params['uploadDir'];?>/logo/<?php echo $commonModel->logo;?>" id="logo" style="width:134px;height:56px;border:2px solid #eee;<?php if($commonModel->logo==""){echo "display:none;"; };?>" alt="Preview">
           8/
           */ ?> 
        <div class="clearfix"><!-- --></div>
       
        <hr />
        <h4><?php echo Yii::t('settings', 'Pagination / Time info')?></h4>
        <hr />
        <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'backend_page_size');?>
            <?php echo $form->dropDownList($commonModel, 'backend_page_size', $commonModel->paginationOptions->getOptionsList(), $commonModel->getHtmlOptions('backend_page_size')); ?>
            <?php echo $form->error($commonModel, 'backend_page_size');?>
        </div>
        <div class="form-group col-lg-6">
            <?php echo $form->labelEx($commonModel, 'customer_page_size');?>
            <?php echo $form->dropDownList($commonModel, 'customer_page_size', $commonModel->paginationOptions->getOptionsList(), $commonModel->getHtmlOptions('customer_page_size')); ?>
            <?php echo $form->error($commonModel, 'customer_page_size');?>
        </div>  
        <div class="clearfix"><!-- --></div>
   
        <div class="clearfix"><!-- --></div>
        <?php 
        /**
         * This hook gives a chance to append content after the active form fields.
         * Please note that from inside the action callback you can access all the controller view variables 
         * via {@CAttributeCollection $collection->controller->data}
         * @since 1.3.3.1
         */
        $hooks->doAction('after_active_form_fields', new CAttributeCollection(array(
            'controller'    => $this,
            'form'          => $form    
        )));
        ?>
        <div class="clearfix"><!-- --></div>
    </div>
</div>
<script type="text/javascript">
	function readURL(input) {

    if (input.files && input.files[0]) {
        var reader = new FileReader();

        reader.onload = function (e) {
            $('#blah').attr('src', e.target.result);
            
        }

        reader.readAsDataURL(input.files[0]);
    }
}
	function readURL2(input) {

    if (input.files && input.files[0]) {
        var reader = new FileReader();

        reader.onload = function (e) {
            $('#logo').attr('src', e.target.result);
            
        }

        reader.readAsDataURL(input.files[0]);
    }
}

$("#OptionCommon_fav_ico").change(function(){
    readURL(this);
    $('#blah').show();
});
$("#OptionCommon_logo").change(function(){
    readURL2(this);
    $('#logo').show();
});
   
</script>
<link rel="stylesheet" href="<?php echo  AssetsUrl::css('table.css');?>" />
