<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * This file is part of the MailWizz EMA application.
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */

/**
 * This hook gives a chance to prepend content or to replace the default view content with a custom content.
 * Please note that from inside the action callback you can access all the controller view
 * variables via {@CAttributeCollection $collection->controller->data}
 * In case the content is replaced, make sure to set {@CAttributeCollection $collection->renderContent} to false 
 * in order to stop rendering the default content.
 * @since 1.3.3.1
 */
$hooks->doAction('before_view_file_content', $viewCollection = new CAttributeCollection(array(
    'controller'    => $this,
    'renderContent' => true,
)));

// and render if allowed
if ($viewCollection->renderContent) {
    /**
     * This hook gives a chance to prepend content before the active form or to replace the default active form entirely.
     * Please note that from inside the action callback you can access all the controller view variables 
     * via {@CAttributeCollection $collection->controller->data}
     * In case the form is replaced, make sure to set {@CAttributeCollection $collection->renderForm} to false 
     * in order to stop rendering the default content.
     * @since 1.3.3.1
     */
    $hooks->doAction('before_active_form', $collection = new CAttributeCollection(array(
        'controller'    => $this,
        'renderForm'    => true,
    )));
    
    // and render if allowed
    if ($collection->renderForm) {
        $form = $this->beginWidget('CActiveForm',array('focus'=>array($model,Yii::app()->controller->focus), 'htmlOptions' => array('enctype' => 'multipart/form-data'))); 
        ?>
        <div class="box box-primary">
            <div class="box-header">
                <div class="pull-left">
                    <h3 class="box-title"><span class="glyphicon glyphicon-star"></span> <?php echo $pageHeading;?></h3>
                </div>
                <div class="pull-right">
                    <?php if (!$model->isNewRecord) { ?>
                    <?php echo CHtml::link(Yii::t('app', 'Create new'), array(Yii::app()->controller->id.'/create'), array('class' => 'btn btn-primary btn-xs', 'title' => Yii::t('app', 'Create new')));?>
                    <?php } ?>
                    <?php echo CHtml::link(Yii::t('app', 'Cancel'), array(Yii::app()->controller->id.'/index'), array('class' => 'btn btn-primary btn-xs', 'title' => Yii::t('app', 'Cancel')));?>
                </div>
                <div class="clearfix"><!-- --></div>
            </div>
            <div class="box-body">
                <?php 
                /**
                 * This hook gives a chance to prepend content before the active form fields.
                 * Please note that from inside the action callback you can access all the controller view variables 
                 * via {@CAttributeCollection $collection->controller->data}
                 * @since 1.3.3.1
                 */
                $hooks->doAction('before_active_form_fields', new CAttributeCollection(array(
                    'controller'    => $this,
                    'form'          => $form    
                )));
                ?>
               
                <div class="clearfix"><!-- --></div>
                <div class="form-group ">
                    <?php  echo $form->labelEx($model, 'name');?>
                    <?php echo $form->textField($model, 'name',$model->getHtmlOptions('name')); ?>
                    <?php  echo $form->error($model, 'name');?>
                </div>  
                
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <?php  echo $form->labelEx($model, 'short_desc');?>
                    <?php echo $form->textArea($model, 'short_desc', $model->getHtmlOptions('short_desc', array('rows' => 5))); ?>
                    <?php  echo $form->error($model, 'short_desc');?>
                </div>
                
                <?php 
                $list = json_decode($model->list, true);
                
                if(!empty($list['dev'])){ $model->dev = $list['dev'];  }
                ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group col-lg-6">
                    <?php // echo $form->labelEx($model, 'dev');?>Developer
                    <?php echo $form->dropDownList($model, 'dev', $model->dev_arr(),$model->getHtmlOptions('dev')); ?>
                    <?php echo $form->error($model, 'dev');?>
                </div> 
                
                
                
                <?php if(!empty($model->f_img)){ ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <img src="<?php echo Yii::app()->apps->getBaseUrl('uploads/projectlist/'.@$model->f_img); ?>" style="width:140px;">
                </div>
                <?php } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group" >
                    <?php echo $form->hiddenField($model,'f_imgb',array('value'=>$model->f_img)); ?> 
                <?php   echo $form->labelEx($model, 'f_img'); ?> (965 x 500)
                <?php    echo CHtml::fileField('f_img'); ?>
				<?php  echo $form->error($model, 'f_img'); ?>
                </div>
                
                
                <?php 
                $list = json_decode($model->list, true);
                
                if(!empty($list['sprice'])){ $model->sprice = $list['sprice'];  }
                ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group ">
                    <?php  echo $form->labelEx($model, 'sprice'); ?>
                    <?php echo $form->textField($model, 'sprice', $model->getHtmlOptions('sprice')); ?>
                    <?php  echo $form->error($model, 'sprice'); ?>
                </div>  
                
                <?php if(!empty($list['list_title1'])){ $model->list_title1 = $list['list_title1'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group ">
                    <?php  echo $form->labelEx($model, 'list_title1');?>
                    <?php echo $form->textField($model, 'list_title1', $model->getHtmlOptions('list_title1')); ?>
                    <?php  echo $form->error($model, 'list_title1');?>
                </div>  
                
                <?php if(!empty($list['list_icon1'])){ $model->list_icon1 = $list['list_icon1'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <?php  echo $form->labelEx($model, 'list_icon1');?>
                    <?php echo $form->textField($model, 'list_icon1', $model->getHtmlOptions('list_icon1')); ?>
                    <?php  echo $form->error($model, 'list_icon1');?>
                </div>
                
                <?php if(!empty($list['list_desc1'])){ $model->list_desc1 = $list['list_desc1'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <?php  echo $form->labelEx($model, 'list_desc1');?> 
                    <?php echo $form->textArea($model, 'list_desc1', $model->getHtmlOptions('list_desc1', array('rows' => 5))); ?>
                    <?php  echo $form->error($model, 'list_desc1');?>
                </div>
                <?php /**/ ?>
                
                <?php if(!empty($list['list_title2'])){ $model->list_title2 = $list['list_title2'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group ">
                    <?php echo $form->labelEx($model, 'list_title2');?>
                    <?php echo $form->textField($model, 'list_title2',$model->getHtmlOptions('list_title2')); ?>
                    <?php echo $form->error($model, 'list_title2');?>
                </div>  
                
                <?php if(!empty($list['list_icon2'])){ $model->list_icon2 = $list['list_icon2'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <?php echo $form->labelEx($model, 'list_icon2');?> 
                    <?php echo $form->textField($model, 'list_icon2', $model->getHtmlOptions('list_icon2')); ?>
                    <?php echo $form->error($model, 'list_icon2');?>
                </div>
                
                <?php if(!empty($list['list_desc2'])){ $model->list_desc2 = $list['list_desc2'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <?php echo $form->labelEx($model, 'list_desc2');?> 
                    <?php echo $form->textArea($model, 'list_desc2', $model->getHtmlOptions('list_desc2', array('rows' => 5))); ?>
                    <?php echo $form->error($model, 'list_desc2');?>
                </div>
                
                <?php if(!empty($list['list_title3'])){ $model->list_title3 = $list['list_title3'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group ">
                    <?php echo $form->labelEx($model, 'list_title3');?> 
                    <?php echo $form->textField($model, 'list_title3',$model->getHtmlOptions('list_title3')); ?>
                    <?php echo $form->error($model, 'list_title3');?>
                </div>  
                
                <?php if(!empty($list['list_icon3'])){ $model->list_icon3 = $list['list_icon3'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <?php echo $form->labelEx($model, 'list_icon3');?> 
                    <?php echo $form->textField($model, 'list_icon3', $model->getHtmlOptions('list_icon3')); ?>
                    <?php echo $form->error($model, 'list_icon3');?>
                </div>
                
                <?php if(!empty($list['list_desc3'])){ $model->list_desc3 = $list['list_desc3'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <?php echo $form->labelEx($model, 'list_desc3');?> 
                    <?php echo $form->textArea($model, 'list_desc3', $model->getHtmlOptions('list_desc3', array('rows' => 5))); ?>
                    <?php echo $form->error($model, 'list_desc3');?>
                </div>
                
                <?php if(!empty($list['list_title4'])){ $model->list_title4 = $list['list_title4'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group ">
                    <?php echo $form->labelEx($model, 'list_title4');?> 
                    <?php echo $form->textField($model, 'list_title4',$model->getHtmlOptions('list_title4')); ?>
                    <?php echo $form->error($model, 'list_title4');?>
                </div>  
                
                <?php if(!empty($list['list_icon4'])){ $model->list_icon4 = $list['list_icon4'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <?php echo $form->labelEx($model, 'list_icon4');?> 
                    <?php echo $form->textField($model, 'list_icon4', $model->getHtmlOptions('list_icon4')); ?>
                    <?php echo $form->error($model, 'list_icon4');?>
                </div>
                
                <?php if(!empty($list['list_desc4'])){ $model->list_desc4 = $list['list_desc4'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <?php echo $form->labelEx($model, 'list_desc4');?>  
                    <?php echo $form->textArea($model, 'list_desc4', $model->getHtmlOptions('list_desc4', array('rows' => 5))); ?>
                    <?php echo $form->error($model, 'list_desc4');?>
                </div>
                
                <?php if(!empty($list['list_title5'])){ $model->list_title5 = $list['list_title5'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group ">
                    <?php echo $form->labelEx($model, 'list_title5');?> 
                    <?php echo $form->textField($model, 'list_title5',$model->getHtmlOptions('list_title5')); ?>
                    <?php echo $form->error($model, 'list_title5');?>
                </div>  
                
                <?php if(!empty($list['list_icon5'])){ $model->list_icon5 = $list['list_icon5'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <?php echo $form->labelEx($model, 'list_icon5'); ?> 
                    <?php echo $form->textField($model, 'list_icon5', $model->getHtmlOptions('list_icon5')); ?>
                    <?php echo $form->error($model, 'list_icon5'); ?>
                </div>
                
                <?php if(!empty($list['list_desc5'])){ $model->list_desc5 = $list['list_desc5'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <?php echo $form->labelEx($model, 'list_desc5');?> 
                    <?php echo $form->textArea($model, 'list_desc5', $model->getHtmlOptions('list_desc5', array('rows' => 5))); ?>
                    <?php echo $form->error($model, 'list_desc5');?>
                </div>
                
                
                <?php if(!empty($list['list_title6'])){ $model->list_title6 = $list['list_title6'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group ">
                    <?php echo $form->labelEx($model, 'list_title6');?> 
                    <?php echo $form->textField($model, 'list_title6',$model->getHtmlOptions('list_title6')); ?>
                    <?php echo $form->error($model, 'list_title6');?>
                </div>  
                
                <?php if(!empty($list['list_icon6'])){ $model->list_icon6 = $list['list_icon6'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <?php echo $form->labelEx($model, 'list_icon6'); ?> 
                    <?php echo $form->textField($model, 'list_icon6', $model->getHtmlOptions('list_icon6')); ?>
                    <?php echo $form->error($model, 'list_icon6'); ?>
                </div>
                
                <?php if(!empty($list['list_desc6'])){ $model->list_desc6 = $list['list_desc6'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <?php echo $form->labelEx($model, 'list_desc6');?> 
                    <?php echo $form->textArea($model, 'list_desc6', $model->getHtmlOptions('list_desc6', array('rows' => 5))); ?>
                    <?php echo $form->error($model, 'list_desc6');?>
                </div>
                
                
                <?php if(!empty($list['list_title7'])){ $model->list_title7 = $list['list_title7'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group ">
                    <?php echo $form->labelEx($model, 'list_title7');?> 
                    <?php echo $form->textField($model, 'list_title7',$model->getHtmlOptions('list_title7')); ?>
                    <?php echo $form->error($model, 'list_title7');?>
                </div>  
                
                <?php if(!empty($list['list_icon7'])){ $model->list_icon7 = $list['list_icon7'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <?php echo $form->labelEx($model, 'list_icon7'); ?> 
                    <?php echo $form->textField($model, 'list_icon7', $model->getHtmlOptions('list_icon7')); ?>
                    <?php echo $form->error($model, 'list_icon7'); ?>
                </div>
                
                <?php if(!empty($list['list_desc7'])){ $model->list_desc7 = $list['list_desc7'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <?php echo $form->labelEx($model, 'list_desc7');?> 
                    <?php echo $form->textArea($model, 'list_desc7', $model->getHtmlOptions('list_desc7', array('rows' => 5))); ?>
                    <?php echo $form->error($model, 'list_desc7');?>
                </div>
                
                
                <?php if(!empty($list['list_title8'])){ $model->list_title8 = $list['list_title8'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group ">
                    <?php echo $form->labelEx($model, 'list_title8');?> 
                    <?php echo $form->textField($model, 'list_title8',$model->getHtmlOptions('list_title8')); ?>
                    <?php echo $form->error($model, 'list_title8');?>
                </div>  
                
                <?php if(!empty($list['list_icon8'])){ $model->list_icon8 = $list['list_icon8'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <?php echo $form->labelEx($model, 'list_icon8'); ?> 
                    <?php echo $form->textField($model, 'list_icon8', $model->getHtmlOptions('list_icon8')); ?>
                    <?php echo $form->error($model, 'list_icon8'); ?>
                </div>
                
                <?php if(!empty($list['list_desc8'])){ $model->list_desc8 = $list['list_desc8'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <?php echo $form->labelEx($model, 'list_desc8');?> 
                    <?php echo $form->textArea($model, 'list_desc8', $model->getHtmlOptions('list_desc8', array('rows' => 5))); ?>
                    <?php echo $form->error($model, 'list_desc8');?>
                </div>
                
                <?php /**/ ?>
                
                
                
                <?php $prop = json_decode($model->property, true); if(!empty($prop['prop_title1'])){ $model->prop_title1 = $prop['prop_title1'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group ">
                    <?php echo $form->labelEx($model, 'prop_title1');?>
                    <?php echo $form->textField($model, 'prop_title1',$model->getHtmlOptions('prop_title1')); ?>
                    <?php echo $form->error($model, 'prop_title1');?>
                </div>  
                
                <?php if(!empty($prop['prop_img1'])){  $model->prop_img1 = $prop['prop_img1'];   ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <img src="<?php echo Yii::app()->apps->getBaseUrl('uploads/projectlist/'.@$model->prop_img1); ?>" style="width:140px;">
                </div>
                <?php } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                <?php echo $form->hiddenField($model,'prop_img1b',array('value'=>$model->prop_img1)); ?>    
                <?php   echo $form->labelEx($model, 'prop_img1'); ?> (445 x 240)
                <?php  echo CHtml::fileField('prop_img1'); ?>
				    <?php  echo $form->error($model, 'prop_img1'); ?>
                </div>
                
                <?php if(!empty($prop['prop_desc1'])){ $model->prop_desc1 = $prop['prop_desc1'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <?php echo $form->labelEx($model, 'prop_desc1');?> 
                    <?php echo $form->textArea($model, 'prop_desc1', $model->getHtmlOptions('prop_desc1', array('rows' => 5))); ?>
                    <?php echo $form->error($model, 'prop_desc1');?>
                </div>
                <?php /**/ ?>
                
                <?php if(!empty($prop['prop_title2'])){ $model->prop_title2 = $prop['prop_title2'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group ">
                    <?php echo $form->labelEx($model, 'prop_title2');?> 
                    <?php echo $form->textField($model, 'prop_title2',$model->getHtmlOptions('prop_title2')); ?>
                    <?php echo $form->error($model, 'prop_title2');?>
                </div>  
                
                <?php if(!empty($prop['prop_img2'])){ $model->prop_img2 = $prop['prop_img2'];  
                ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <img src="<?php echo Yii::app()->apps->getBaseUrl('uploads/projectlist/'.@$model->prop_img2); ?>" style="width:140px;">
                </div>
                <?php } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                <?php echo $form->hiddenField($model,'prop_img2b',array('value'=>$model->prop_img2)); ?>
                <?php  echo $form->labelEx($model, 'prop_img2'); ?> (445 x 240)
                <?php  echo CHtml::fileField('prop_img2'); ?>
				<?php  echo $form->error($model, 'prop_img2'); ?>
                </div>
                
                <?php if(!empty($prop['prop_desc2'])){ $model->prop_desc2 = $prop['prop_desc2'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <?php echo $form->labelEx($model, 'prop_desc2');?> 
                    <?php echo $form->textArea($model, 'prop_desc2', $model->getHtmlOptions('prop_desc2', array('rows' => 5))); ?>
                    <?php echo $form->error($model, 'prop_desc2');?>
                </div>
                
                <?php if(!empty($prop['prop_title4'])){ $model->prop_title4 = $prop['prop_title4'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group ">
                    <?php echo $form->labelEx($model, 'prop_title4');?> 
                    <?php echo $form->textField($model, 'prop_title3',$model->getHtmlOptions('prop_title3')); ?>
                    <?php echo $form->error($model, 'prop_title3');?>
                </div>  
                
                <?php if(!empty($prop['prop_img3'])){ $model->prop_img3 = $prop['prop_img3'];  
                ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <img src="<?php echo Yii::app()->apps->getBaseUrl('uploads/projectlist/'.@$model->prop_img3); ?>" style="width:140px;">
                </div>
                <?php } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                <?php echo $form->hiddenField($model,'prop_img3b',array('value'=>$model->prop_img3)); ?>
                <?php  echo $form->labelEx($model, 'prop_img3'); ?> (445 x 240)
                <?php    echo CHtml::fileField('prop_img3'); ?>
				    <?php echo $form->error($model, 'prop_img3'); ?>
                </div>
                
                <?php if(!empty($prop['prop_desc3'])){ $model->prop_desc3 = $prop['prop_desc3'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <?php echo $form->labelEx($model, 'prop_desc3');?> 
                    <?php echo $form->textArea($model, 'prop_desc3', $model->getHtmlOptions('prop_desc3', array('rows' => 5))); ?>
                    <?php echo $form->error($model, 'prop_desc3');?>
                </div>
                
                <?php if(!empty($prop['prop_title4'])){ $model->prop_title4 = $prop['prop_title4'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group ">
                    <?php echo $form->labelEx($model, 'prop_title4');?> 
                    <?php echo $form->textField($model, 'prop_title4',$model->getHtmlOptions('prop_title4')); ?>
                    <?php echo $form->error($model, 'prop_title4');?>
                </div>  
                
                <?php if(!empty($prop['prop_img4'])){ $model->prop_img4 = $prop['prop_img4'];  
                ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <img src="<?php echo Yii::app()->apps->getBaseUrl('uploads/projectlist/'.@$model->prop_img4); ?>" style="width:140px;">
                </div>
                <?php } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                <?php echo $form->hiddenField($model,'prop_img4b',array('value'=>$model->prop_img4)); ?>
                <?php  echo $form->labelEx($model, 'prop_img4'); ?> (445 x 240)
                <?php    echo CHtml::fileField('prop_img4'); ?>
				    <?php echo $form->error($model, 'prop_img4'); ?>
                </div>
                
                <?php if(!empty($prop['prop_desc4'])){ $model->prop_desc4 = $prop['prop_desc4'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <?php echo $form->labelEx($model, 'prop_desc4');?> 
                    <?php echo $form->textArea($model, 'prop_desc4', $model->getHtmlOptions('prop_desc4', array('rows' => 5))); ?>
                    <?php echo $form->error($model, 'prop_desc4');?>
                </div>
                
                <?php if(!empty($prop['prop_title5'])){ $model->prop_title5 = $prop['prop_title5'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group ">
                    <?php echo $form->labelEx($model, 'prop_title5');?> 
                    <?php echo $form->textField($model, 'prop_title5',$model->getHtmlOptions('prop_title5')); ?>
                    <?php echo $form->error($model, 'prop_title5');?>
                </div>  
                
                <?php if(!empty($prop['prop_img5'])){ $model->prop_img5 = $prop['prop_img5'];  ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <img src="<?php echo Yii::app()->apps->getBaseUrl('uploads/projectlist/'.@$model->prop_img5); ?>" style="width:140px;">
                </div>
                <?php } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                <?php echo $form->hiddenField($model,'prop_img5b',array('value'=>$model->prop_img5)); ?>
                <?php echo $form->labelEx($model, 'prop_img5'); ?> (445 x 240)
                <?php echo CHtml::fileField('prop_img5'); ?>
				    <?php echo $form->error($model, 'prop_img5'); ?>
                </div>
                
                <?php if(!empty($prop['prop_desc5'])){ $model->prop_desc5 = $prop['prop_desc5'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <?php echo $form->labelEx($model, 'prop_desc5');?> 
                    <?php echo $form->textArea($model, 'prop_desc5', $model->getHtmlOptions('prop_desc5', array('rows' => 5))); ?>
                    <?php echo $form->error($model, 'prop_desc5');?>
                </div>
                
                
                <?php if(!empty($prop['prop_title6'])){ $model->prop_title6 = $prop['prop_title6'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group ">
                    <?php echo $form->labelEx($model, 'prop_title6');?> 
                    <?php echo $form->textField($model, 'prop_title6',$model->getHtmlOptions('prop_title6')); ?>
                    <?php echo $form->error($model, 'prop_title6');?>
                </div>  
                
                <?php if(!empty($prop['prop_img6'])){ $model->prop_img6 = $prop['prop_img6'];  ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <img src="<?php echo Yii::app()->apps->getBaseUrl('uploads/projectlist/'.@$model->prop_img6); ?>" style="width:140px;">
                </div>
                <?php } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                <?php echo $form->hiddenField($model,'prop_img6b',array('value'=>$model->prop_img6)); ?>
                <?php echo $form->labelEx($model, 'prop_img6'); ?> (445 x 240)
                <?php echo CHtml::fileField('prop_img6'); ?>
				    <?php echo $form->error($model, 'prop_img6'); ?>
                </div>
                
                <?php if(!empty($prop['prop_desc6'])){ $model->prop_desc6 = $prop['prop_desc6'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <?php echo $form->labelEx($model, 'prop_desc6');?> 
                    <?php echo $form->textArea($model, 'prop_desc6', $model->getHtmlOptions('prop_desc6', array('rows' => 5))); ?>
                    <?php echo $form->error($model, 'prop_desc6');?>
                </div>
                
                
                <?php if(!empty($prop['prop_title7'])){ $model->prop_title7 = $prop['prop_title7'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group ">
                    <?php echo $form->labelEx($model, 'prop_title7');?> 
                    <?php echo $form->textField($model, 'prop_title7',$model->getHtmlOptions('prop_title7')); ?>
                    <?php echo $form->error($model, 'prop_title7');?>
                </div>  
                
                <?php if(!empty($prop['prop_img7'])){ $model->prop_img7 = $prop['prop_img7'];  ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <img src="<?php echo Yii::app()->apps->getBaseUrl('uploads/projectlist/'.@$model->prop_img7); ?>" style="width:140px;">
                </div>
                <?php } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                <?php echo $form->hiddenField($model,'prop_img7b',array('value'=>$model->prop_img7)); ?>
                <?php echo $form->labelEx($model, 'prop_img7'); ?> (445 x 240)
                <?php echo CHtml::fileField('prop_img7'); ?>
				    <?php echo $form->error($model, 'prop_img7'); ?>
                </div>
                
                <?php if(!empty($prop['prop_desc7'])){ $model->prop_desc7 = $prop['prop_desc7'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <?php echo $form->labelEx($model, 'prop_desc7');?> 
                    <?php echo $form->textArea($model, 'prop_desc7', $model->getHtmlOptions('prop_desc7', array('rows' => 5))); ?>
                    <?php echo $form->error($model, 'prop_desc7');?>
                </div>
                
                
                <?php if(!empty($prop['prop_title8'])){ $model->prop_title8 = $prop['prop_title8'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group ">
                    <?php echo $form->labelEx($model, 'prop_title8');?> 
                    <?php echo $form->textField($model, 'prop_title8',$model->getHtmlOptions('prop_title8')); ?>
                    <?php echo $form->error($model, 'prop_title8');?>
                </div>  
                
                <?php if(!empty($prop['prop_img8'])){ $model->prop_img8 = $prop['prop_img8'];  ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <img src="<?php echo Yii::app()->apps->getBaseUrl('uploads/projectlist/'.@$model->prop_img8); ?>" style="width:140px;">
                </div>
                <?php } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                <?php echo $form->hiddenField($model,'prop_img8b',array('value'=>$model->prop_img8)); ?>
                <?php echo $form->labelEx($model, 'prop_img8'); ?> (445 x 240)
                <?php echo CHtml::fileField('prop_img8'); ?>
				    <?php echo $form->error($model, 'prop_img8'); ?>
                </div>
                
                <?php if(!empty($prop['prop_desc8'])){ $model->prop_desc8 = $prop['prop_desc8'];  } ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <?php echo $form->labelEx($model, 'prop_desc8');?> 
                    <?php echo $form->textArea($model, 'prop_desc8', $model->getHtmlOptions('prop_desc8', array('rows' => 5))); ?>
                    <?php echo $form->error($model, 'prop_desc8');?>
                </div>
                <?php /**/ ?>
                
                <?php
                /**
                 * This hook gives a chance to append content after the active form fields.
                 * Please note that from inside the action callback you can access all the controller view variables 
                 * via {@CAttributeCollection $collection->controller->data}
                 * @since 1.3.3.1
                 */
                $hooks->doAction('after_active_form_fields', new CAttributeCollection(array(
                    'controller'    => $this,
                    'form'          => $form    
                )));
                ?> 
                <div class="clearfix"><!-- --></div>
            </div>
            <div class="box-footer">
                <div class="pull-right">
                    <button type="submit" class="btn btn-primary btn-submit" data-loading-text="<?php echo Yii::t('app', 'Please wait, processing...');?>"><?php echo Yii::t('app', 'Save changes');?></button>
                </div>
                <div class="clearfix"><!-- --></div>
            </div>
        </div>
        <?php 
        $this->endWidget(); 
    }
    /**
     * This hook gives a chance to append content after the active form.
     * Please note that from inside the action callback you can access all the controller view variables 
     * via {@CAttributeCollection $collection->controller->data}
     * @since 1.3.3.1
     */
    $hooks->doAction('after_active_form', new CAttributeCollection(array(
        'controller'      => $this,
        'renderedForm'    => $collection->renderForm,
    )));
}
/**
 * This hook gives a chance to append content after the view file default content.
 * Please note that from inside the action callback you can access all the controller view
 * variables via {@CAttributeCollection $collection->controller->data}
 * @since 1.3.3.1
 */
$hooks->doAction('after_view_file_content', new CAttributeCollection(array(
    'controller'        => $this,
    'renderedContent'   => $viewCollection->renderContent,
)));
