<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * This file is part of the MailWizz EMA application.
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */

/**
 * This hook gives a chance to prepend content or to replace the default view content with a custom content.
 * Please note that from inside the action callback you can access all the controller view
 * variables via {@CAttributeCollection $collection->controller->data}
 * In case the content is replaced, make sure to set {@CAttributeCollection $collection->renderContent} to false 
 * in order to stop rendering the default content.
 * @since 1.3.3.1
 */
$hooks->doAction('before_view_file_content', $viewCollection = new CAttributeCollection(array(
    'controller'    => $this,
    'renderContent' => true,
)));

// and render if allowed
if ($viewCollection->renderContent) {
    $form = $this->beginWidget('CActiveForm');
?>
    <div class="box box-primary">
        <div class="box-header">
            <div class="pull-left">
                <h3 class="box-title">
                    <span class="glyphicon glyphicon-book"></span> <?php echo Yii::t('articles', 'Our Servies'); ?>
                </h3>
            </div>
            <div class="pull-right">
                <?php echo CHtml::link(Yii::t('app', 'Create new'), array($this->id . '/create'), array('class' => 'btn btn-primary btn-xs', 'title' => Yii::t('app', 'Create new'))); ?>
                <?php echo CHtml::link(Yii::t('app', 'Refresh'), array($this->id . '/index'), array('class' => 'btn btn-primary btn-xs', 'title' => Yii::t('app', 'Refresh'))); ?>
            </div>
            <div class="clearfix"><!-- --></div>
        </div>
        <div class="box-body">
            <div class="table-responsive">
                <?php
                /**
                 * This hook gives a chance to prepend content or to replace the default grid view content with a custom content.
                 * Please note that from inside the action callback you can access all the controller view
                 * variables via {@CAttributeCollection $collection->controller->data}
                 * In case the content is replaced, make sure to set {@CAttributeCollection $collection->renderGrid} to false 
                 * in order to stop rendering the default content.
                 * @since 1.3.3.1
                 */
                $hooks->doAction('before_grid_view', $collection = new CAttributeCollection(array(
                    'controller'   => $this,
                    'renderGrid'   => true,
                )));

                // and render if allowed
                if ($collection->renderGrid) {
                    $this->widget('zii.widgets.grid.CGridView', $hooks->applyFilters('grid_view_properties', array(
                        'ajaxUrl'           => $this->createUrl($this->route),
                        'id'                => $article->modelName . '-grid',
                        'dataProvider'      => $article->search(),
                        'filter'            => $article,
                        'filterPosition'    => 'body',
                        'filterCssClass'    => 'grid-filter-cell',
                        'itemsCssClass'     => 'table table-bordered table-hover table-striped',
                        'selectableRows'    => 0,
                        'enableSorting'     => false,
                        'cssFile'           => false,
                        'pagerCssClass'     => 'pagination pull-right',
                        'pager'             => array(
                            'class'         => 'CLinkPager',
                            'cssFile'       => false,
                            'header'        => false,
                            'htmlOptions'   => array('class' => 'pagination')
                        ),
                        'columns' => $hooks->applyFilters('grid_view_columns', array(
                            array(
                                'name'  => 'title',
                                'value' => '$data->title',
                            ),
                            array(
                                'name'      => 'status',
                                'value'     => '$data->statusText',
                                'filter'    => $article->getStatusesArray(),
                            ),
                            array(
                                'name'      => 'date_added',
                                'value'     => '$data->dateAdded',
                                'filter'    => false,
                            ),
                            array(
                                'name'      => 'last_updated',
                                'value'     => '$data->lastUpdated',
                                'filter'    => false,
                            ),
                            array(
                                'name' => 'priority',
                                'type' => 'raw',
                                'filter' => false,
                                'value' => 'CHtml::textField("priority[$data->article_id]",$data->priority,array("style"=>"width:50px;text-align:center","class"=>"form-controll"))',
                                'htmlOptions' => array("style" => "width:50px;text-align:center", "class" => "form-controll"),
                            ),
                            array(
                                'class'     => 'CButtonColumn',
                                'header'    => Yii::t('app', 'Options'),
                                'footer'    => $article->paginationOptions->getGridFooterPagination(),
                                'buttons'   => array(
                                    'view' => array(
                                        'label'     => ' &nbsp; <span class="glyphicon glyphicon-eye-open"></span> &nbsp;',
                                        'url'       => '$data->permalink',
                                        'imageUrl'  => null,
                                        'options'   => array('title' => Yii::t('app', 'View'), 'class' => '', 'target' => '_blank'),
                                    ),
                                    'update' => array(
                                        'label'     => ' &nbsp; <span class="glyphicon glyphicon-pencil"></span> &nbsp;',
                                        'url'       => 'Yii::app()->createUrl("about_us_service/update", array("id" => $data->article_id,"cid"=>"' . $id . '"))',

                                        'imageUrl'  => null,
                                        'options'   => array('title' => Yii::t('app', 'Update'), 'class' => ''),
                                    ),

                                    'delete' => array(
                                        'label'     => ' &nbsp; <span class="glyphicon glyphicon-remove-circle"></span> &nbsp; ',
                                        'url'       => 'Yii::app()->createUrl("about_us_service/delete", array("id" => $data->article_id))',
                                        'imageUrl'  => null,
                                        'options'   => array('title' => Yii::t('app', 'Delete'), 'class' => 'delete'),
                                    ),
                                ),
                                'htmlOptions' => array(
                                    'style' => 'width:110px;',
                                ),
                                'template' => ' {update} {delete}'
                            ),
                        ), $this),
                    ), $this));
                }
                /**
                 * This hook gives a chance to append content after the grid view content.
                 * Please note that from inside the action callback you can access all the controller view
                 * variables via {@CAttributeCollection $collection->controller->data}
                 * @since 1.3.3.1
                 */
                $hooks->doAction('after_grid_view', new CAttributeCollection(array(
                    'controller'   => $this,
                    'renderedGrid' => $collection->renderGrid,
                )));
                ?>
                <div class="clearfix"><!-- --></div>
            </div>
        </div>
        <div class="box-footer">
            <div class="pull-right">
                <button type="submit" class="btn btn-primary btn-submit" data-loading-text="<?php echo Yii::t('app', 'Please wait, processing...'); ?>"><?php echo Yii::t('app', 'Update Priority'); ?></button>
            </div>
            <div class="clearfix"><!-- --></div>
        </div>

    </div>
<?php
    $this->endWidget();
}
/**
 * This hook gives a chance to append content after the view file default content.
 * Please note that from inside the action callback you can access all the controller view
 * variables via {@CAttributeCollection $collection->controller->data}
 * @since 1.3.3.1
 */
$hooks->doAction('after_view_file_content', new CAttributeCollection(array(
    'controller'        => $this,
    'renderedContent'   => $viewCollection->renderContent,
)));
