<?php defined('MW_PATH') || exit('No direct script access allowed');
$languageCodes = OptionCommon::getLanguages();
/**
 * This file is part of the MailWizz EMA application.
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */

/**
 * This hook gives a chance to prepend content or to replace the default view content with a custom content.
 * Please note that from inside the action callback you can access all the controller view
 * variables via {@CAttributeCollection $collection->controller->data}
 * In case the content is replaced, make sure to set {@CAttributeCollection $collection->renderContent} to false 
 * in order to stop rendering the default content.
 * @since 1.3.3.1
 */
$hooks->doAction('before_view_file_content', $viewCollection = new CAttributeCollection(array(
    'controller'    => $this,
    'renderContent' => true,
)));

// and render if allowed
if ($viewCollection->renderContent) {
    /**
     * This hook gives a chance to prepend content before the active form or to replace the default active form entirely.
     * Please note that from inside the action callback you can access all the controller view variables 
     * via {@CAttributeCollection $collection->controller->data}
     * In case the form is replaced, make sure to set {@CAttributeCollection $collection->renderForm} to false 
     * in order to stop rendering the default content.
     * @since 1.3.3.1
     */
    $hooks->doAction('before_active_form', $collection = new CAttributeCollection(array(
        'controller'    => $this,
        'renderForm'    => true,
    )));

    // and render if allowed
    if ($collection->renderForm) {
        $form = $this->beginWidget('CActiveForm');
?>
        <div class="box box-primary">
            <div class="box-header">
                <div class="pull-left">
                    <h3 class="box-title"><span class="glyphicon glyphicon-book"></span> <?php echo $pageHeading; ?>
                    <?php
                    if(isset($_GET['lan'])){
                                         ?> <span style="color:red">- Updating <b><?php echo $languageCodes[$_GET['lan']]; echo '</b></span>'; 
                    }
                    ?>
                    
                    
                    </h3>
                </div>
                <div class="pull-right">
                    <?php if (!$article->isNewRecord) { ?>

                        <?php echo CHtml::link(Yii::t('app', 'Create new'), array('location_landing/create/cid/' . $article->category_id), array('class' => 'btn btn-primary btn-xs', 'title' => Yii::t('app', 'Create new'))); ?>

                    <?php } ?>
                    <?php echo CHtml::link(Yii::t('app', 'Cancel'), array('location_landing/index/id/' . $article->category_id), array('class' => 'btn btn-primary btn-xs', 'title' => Yii::t('app', 'Cancel'))); ?>
                    <?php if (!$article->isNewRecord) { ?>
                        <?php
                       
                        ?>
                        <style>
                            .dropdown-item {
                                color: #333;
                                padding: 10px 20px;
                                font-weight: 500;
                                display: block;
                                transition: background-color 0.2s ease-in-out;
                            }

                            .open>.dropdown-menu {
                                 
                                right: 0;
                                left: unset;
                            }

                            /* Hover effect */
                            .dropdown-item:hover,
                            .dropdown-item:focus {
                                background-color: #f0f0f0;
                                color: #000;
                            }

                            /* Optional: active or selected style */
                            .dropdown-item.active {
                                background-color: #007bff;
                                color: #fff;
                            }
                        </style>
                        <div class="dropdown" style="    display: inline-block;    margin-left: 15px;">
                            <button class="btn btn-secondary dropdown-toggle" type="button" id="languageDropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                Select Language
                            </button>
                            <div class="dropdown-menu" aria-labelledby="languageDropdown">
                                <?php foreach ($languageCodes as $code => $name): 
                                    $pppid = !empty($parent_article) ? $parent_article->primaryKey : $article->article_id;
                                    ?>
                                    <a class="dropdown-item" href="<?php echo Yii::app()->createUrl('articles/update_language',['parent_id'=> $pppid ,'lan'=>$code]); ?>"><?php echo htmlspecialchars($name); ?></a>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>
                <div class="clearfix"><!-- --></div>
            </div>
            <div class="box-body">
                <?php
                /**
                 * This hook gives a chance to prepend content before the active form fields.
                 * Please note that from inside the action callback you can access all the controller view variables 
                 * via {@CAttributeCollection $collection->controller->data}
                 * @since 1.3.3.1
                 */
                $hooks->doAction('before_active_form_fields', new CAttributeCollection(array(
                    'controller'    => $this,
                    'form'          => $form
                )));
                ?>
                <div class="clearfix"><!-- --></div>
                <div class="form-group">
                    <?php echo $form->labelEx($article, 'title'); ?>
                    <?php echo $form->textField($article, 'title', $article->getHtmlOptions('title', array('data-article-id' => (int)$article->article_id, 'data-slug-url' => $this->createUrl('articles/slug')))); ?>
                    <?php echo $form->error($article, 'title'); ?>
                </div>
                <div class="form-group">
                    <?php echo $form->labelEx($article, 'sub_title'); ?>
                    <?php echo $form->textField($article, 'sub_title', $article->getHtmlOptions('sub_title')); ?>
                    <?php echo $form->error($article, 'sub_title'); ?>
                </div>
                <div class="form-group">
                    <?php echo $form->labelEx($article, 'page_title'); ?>
                    <?php echo $form->textField($article, 'page_title', $article->getHtmlOptions('page_title')); ?>
                    <?php echo $form->error($article, 'page_title'); ?>
                </div>


                <div class="form-group">
                    <?php echo $form->labelEx($article, 'meta_keywords'); ?>
                    <?php echo $form->textField($article, 'meta_keywords', $article->getHtmlOptions('meta_keywords')); ?>
                    <?php echo $form->error($article, 'meta_keywords'); ?>
                </div>
                <div class="form-group">
                    <?php echo $form->labelEx($article, 'meta_description'); ?>
                    <?php echo $form->textArea($article, 'meta_description', $article->getHtmlOptions('meta_description', array('rows' => 4))); ?>
                    <?php echo $form->error($article, 'meta_description'); ?>
                </div>
                <div class=" ">

                    <div class="form-group col-lg-3">
                        <style>
                            #div_view_whatsapp_c_image img {
                                width: 100px !important;
                            }
                        </style>
                        <?php
                        $fileField = 'banner';
                        $types = '.png,.jpg,.pdf,.jpeg,.webp';
                        $maxFiles = '1';
                        $maxFilesize = '5';
                        $model = $user;
                        $this->renderPartial('backend.views.articles._file_field_browse3', compact('form', 'fileField', 'maxFilesize', 'types', 'maxFiles', 'model'));
                        ?>

                    </div>
                    <div class="form-group col-lg-3">
                        <style>
                            #div_view_whatsapp_c_image img {
                                width: 100px !important;
                            }
                        </style>
                        <?php
                        $fileField = 'image2';
                        $types = '.png,.jpg,.jpeg,.webp';
                        $maxFiles = '1';
                        $maxFilesize = '2';
                        $model = $user;
                        $this->renderPartial('backend.views.articles._file_field_browse3', compact('form', 'fileField', 'maxFilesize', 'types', 'maxFiles', 'model'));
                        ?>

                    </div>
                    <div class="form-group col-lg-3">
                        <style>
                            #div_view_whatsapp_c_image img {
                                width: 100px !important;
                            }
                        </style>
                        <?php
                        $fileField = 'image3';
                        $types = '.png,.jpg,.jpeg,.webp';
                        $maxFiles = '1';
                        $maxFilesize = '2';
                        $model = $user;
                        $this->renderPartial('backend.views.articles._file_field_browse3', compact('form', 'fileField', 'maxFilesize', 'types', 'maxFiles', 'model'));
                        ?>

                    </div>
                    <div class="form-group col-lg-3">
                        <style>
                            #div_view_whatsapp_c_image img {
                                width: 100px !important;
                            }
                        </style>
                        <?php
                        $fileField = 'image4';
                        $types = '.png,.jpg,.jpeg,.webp';
                        $maxFiles = '1';
                        $maxFilesize = '2';
                        $model = $user;
                        $this->renderPartial('backend.views.articles._file_field_browse3', compact('form', 'fileField', 'maxFilesize', 'types', 'maxFiles', 'model'));
                        ?>

                    </div>

                </div>
                <style>
                    #abc_banner .btn {
                        width: 100% !important;
                        height: auto !important;
                    }

                    #abc_banner.browse_type .dropzone .dz-message .upload-btn-wrapper {
                        padding: 0px;
                        box-shadow: unset;
                        max-width: 200px;
                    }

                    #abc_image .dz-preview {
                        display: none !important;
                    }

                    #file_image .upload-btn-wrapper .drop_fil {
                        margin-top: 15px !important;
                    }
                </style>
                <div class="clearfix"></div>
                <div class="form-group">
                    <?php echo $form->labelEx($article, 'content'); ?>
                    <?php echo $form->textArea($article, 'content', $article->getHtmlOptions('content', array('rows' => 15))); ?>
                    <?php echo $form->error($article, 'content'); ?>
                </div>
                <div class="form-group">

                    <?php echo $form->labelEx($article, 'youtube_url'); ?>
                    <?php echo $form->textField($article, 'youtube_url', $article->getHtmlOptions('youtube_url')); ?>
                    <?php echo $form->error($article, 'youtube_url'); ?>
                </div>
                <?php /* 
                 <div class="form-group">
                <?php
                if(!Yii::app()->request->isPostRequest and !$article->isNewRecord){
					
					$article->roles = CHtml::listData(ArticleRole::model()->findAllByAttributes(array('article_id'=>$article->article_id)),'master_id','master_id');
 
				}
				?>
                     <?php echo $form->labelEx($article, 'roles');?>
                    <?php echo $form->dropDownList($article, 'roles',CHtml::listData(Master::model()->listData($category_id=4),'master_id','master_name'), $article->getHtmlOptions('roles',array('multiple'=>'multiple','empty'=>'Select'))); ?>
                    <?php echo $form->error($article, 'roles');?>
                    <script>
                    $(function(){ $('#Article_roles').select2();  })
                    </script>
                </div>
                */
                ?>
                <div class="form-group  col-lg-3">
                    <?php echo $form->labelEx($article, 'phone'); ?>
                    <?php echo $form->textField($article, 'phone', $article->getHtmlOptions('phone')); ?>
                    <?php echo $form->error($article, 'phone'); ?>
                </div>
                <div class="form-group  col-lg-3">
                    <?php echo $form->labelEx($article, 'mobile'); ?>
                    <?php echo $form->textField($article, 'mobile', $article->getHtmlOptions('meta_description')); ?>
                    <?php echo $form->error($article, 'mobile'); ?>
                </div>
                <div class="form-group  col-lg-3">
                    <?php echo $form->labelEx($article, 'Reading time'); ?>
                    <?php echo $form->textField($article, 'reading_time', $article->getHtmlOptions('reading_time')); ?>
                    <?php echo $form->error($article, 'reading_time'); ?>
                </div>
                <div class="form-group col-lg-8">
                    <?php echo $form->labelEx($articleToCategory, 'category_id'); ?>
                    <div class="article-categories-scrollbox">
                        <ul class="list-group">
                            <?php echo CHtml::checkBoxList($articleToCategory->modelName, $article->getSelectedCategoriesArray(), $article->getAvailableCategoriesArray(), $articleToCategory->getHtmlOptions('category_id', array(
                                'class'        => '',
                                'template'     => '<li class="list-group-item">{beginLabel}{input} <span>{labelTitle}</span> {endLabel}</li>',
                                'container'    => '',
                                'separator'    => '',
                                'labelOptions' => array('style' => 'margin-right: 10px;')
                            ))); ?>
                        </ul>
                    </div>
                    <?php echo $form->error($articleToCategory, 'category_id'); ?>
                </div>
                <div class="col-lg-4">
                    <div class="form-group slug-wrapper" <?php if (empty($article->slug)) {
                                                                echo ' style="display:none"';
                                                            } ?>>
                        <?php echo $form->labelEx($article, 'slug'); ?>
                        <?php echo $form->textField($article, 'slug', $article->getHtmlOptions('slug')); ?>
                        <?php echo $form->error($article, 'slug'); ?>
                    </div>
                    <div class="form-group">
                        <?php echo $form->labelEx($article, 'status'); ?>
                        <?php echo $form->dropDownList($article, 'status', $article->getStatusesArray(), $article->getHtmlOptions('status')); ?>
                        <?php echo $form->error($article, 'status'); ?>
                    </div>
                </div>
                <div class="clearfix"><!-- --></div>
                <?php
                /**
                 * This hook gives a chance to append content after the active form fields.
                 * Please note that from inside the action callback you can access all the controller view variables 
                 * via {@CAttributeCollection $collection->controller->data}
                 * @since 1.3.3.1
                 */
                $hooks->doAction('after_active_form_fields', new CAttributeCollection(array(
                    'controller'    => $this,
                    'form'          => $form
                )));
                ?>
                <div class="clearfix"><!-- --></div>
            </div>
            <div class="box-footer">
                <div class="pull-right">
                    <button type="submit" class="btn btn-primary btn-submit" data-loading-text="<?php echo Yii::t('app', 'Please wait, processing...'); ?>"><?php echo Yii::t('app', 'Save changes'); ?></button>
                </div>
                <div class="clearfix"><!-- --></div>
            </div>
        </div>
<?php
        $this->endWidget();
    }
    /**
     * This hook gives a chance to append content after the active form.
     * Please note that from inside the action callback you can access all the controller view variables 
     * via {@CAttributeCollection $collection->controller->data}
     * @since 1.3.3.1
     */
    $hooks->doAction('after_active_form', new CAttributeCollection(array(
        'controller'      => $this,
        'renderedForm'    => $collection->renderForm,
    )));
}
/**
 * This hook gives a chance to append content after the view file default content.
 * Please note that from inside the action callback you can access all the controller view
 * variables via {@CAttributeCollection $collection->controller->data}
 * @since 1.3.3.1
 */
$hooks->doAction('after_view_file_content', new CAttributeCollection(array(
    'controller'        => $this,
    'renderedContent'   => $viewCollection->renderContent,
)));
