<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * This file is part of the MailWizz EMA application.
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */

/**
 * This hook gives a chance to prepend content or to replace the default view content with a custom content.
 * Please note that from inside the action callback you can access all the controller view
 * variables via {@CAttributeCollection $collection->controller->data}
 * In case the content is replaced, make sure to set {@CAttributeCollection $collection->renderContent} to false 
 * in order to stop rendering the default content.
 * @since 1.3.3.1
 */
$hooks->doAction('before_view_file_content', $viewCollection = new CAttributeCollection(array(
    'controller'    => $this,
    'renderContent' => true,
)));

// and render if allowed
if ($viewCollection->renderContent) {
    /**
     * This hook gives a chance to prepend content before the active form or to replace the default active form entirely.
     * Please note that from inside the action callback you can access all the controller view variables 
     * via {@CAttributeCollection $collection->controller->data}
     * In case the form is replaced, make sure to set {@CAttributeCollection $collection->renderForm} to false 
     * in order to stop rendering the default content.
     * @since 1.3.3.1
     */
    $hooks->doAction('before_active_form', $collection = new CAttributeCollection(array(
        'controller'    => $this,
        'renderForm'    => true,
    )));
    
    // and render if allowed
    if ($collection->renderForm) {
         $form=$this->beginWidget('CActiveForm', array(
        'id'=>'miscellaneous-pages-form',
        'enableAjaxValidation'=>false,
'htmlOptions'=>array('enctype'=>'multipart/form-data'),
)); ?>
        <div class="box box-primary">
            <div class="box-header">
                <div class="pull-left">
                    <h3 class="box-title"><span class="glyphicon glyphicon-book"></span> <?php echo $pageHeading;?></h3>
                </div>
                <div class="pull-right">
                    <?php if (!$category->isNewRecord) { ?>
                    <?php echo CHtml::link(Yii::t('app', 'Create new'), array('areaguides/create'), array('class' => 'btn btn-primary btn-xs', 'title' => Yii::t('app', 'Create new')));?>
                    <?php } ?>
                    <?php echo CHtml::link(Yii::t('app', 'Cancel'), array('areaguides/index'), array('class' => 'btn btn-primary btn-xs', 'title' => Yii::t('app', 'Cancel')));?>
                </div>
                <div class="clearfix"><!-- --></div>
            </div>
            <div class="box-body">
                <?php 
                /**
                 * This hook gives a chance to prepend content before the active form fields.
                 * Please note that from inside the action callback you can access all the controller view variables 
                 * via {@CAttributeCollection $collection->controller->data}
                 * @since 1.3.3.1
                 */
                $hooks->doAction('before_active_form_fields', new CAttributeCollection(array(
                    'controller'    => $this,
                    'form'          => $form    
                )));
                ?>
                <div class="clearfix"><!-- --></div>
                 <script>
                     function getCategory(k){
                          $('#<?php echo $category->modelName;?>_category_id').html('<option value="">Loading..</option>');
                         $.get('<?php echo Yii::app()->createUrl($this->id.'/categories');?>',{'id':$(k).val()},function(data){
                             
                             $('#<?php echo $category->modelName;?>_category_id').html(data);
                             
                         })
                     }
                     function getSubCommunity(k){
                          $('#<?php echo $category->modelName;?>_subcomunity_id').html('<option value="">Loading..</option>');
                         $.get('<?php echo Yii::app()->createUrl($this->id.'/subcomunities');?>',{'id':$(k).val()},function(data){
                             
                             $('#<?php echo $category->modelName;?>_subcomunity_id').html(data);
                             
                         })
                     }
                 </script>
                    <div class="row">
                      
                <div class="form-group col-sm-3 hide">
                    <?php echo $form->labelEx($category, 'l_type');?>
                    <?php echo $form->dropdownlist($category, 'l_type',  Category::model()->listingTypeArray(), $category->getHtmlOptions('l_type', array( 'empty'=>'Please Select','onchange'=>'getCategory(this)'))); ?>
                    <?php echo $form->error($category, 'l_type');?>
                </div>
                <div class="form-group col-sm-3 hide">
                    <?php echo $form->labelEx($category, 'category_id');?>
                    <?php echo $form->dropdownlist($category, 'category_id',  CHtml::listData(Category::model()->category_by_type($category->l_type),'category_id','category_name'), $category->getHtmlOptions('category_id', array( 'empty'=>'Please Select'))); ?>
                    <?php echo $form->error($category, 'category_id');?>
                </div>
                <div class="form-group col-sm-3">
                    <?php echo $form->labelEx($category, 'community_id');?>
                    <?php echo $form->dropdownlist($category, 'community_id',  CHtml::listData(Community::model()->findAllUAE(),'community_id','community_name'), $category->getHtmlOptions('community_id', array( 'empty'=>'Please Select','onchange'=>'getSubCommunity(this)'))); ?>
                    <?php echo $form->error($category, 'community_id');?>
                </div>
                <div class="form-group col-sm-3">
                    <?php echo $form->labelEx($category, 'subcomunity_id');?>
                    <?php echo $form->dropdownlist($category, 'subcomunity_id',  CHtml::listData(SubCommunity::model()->subCommunities($category->community_id),'sub_community_id','sub_community_name'), $category->getHtmlOptions('subcomunity_id', array( 'empty'=>'Please Select'))); ?>
                    <?php echo $form->error($category, 'subcomunity_id');?>
                </div>
                  <div class="form-group col-sm-3">
                    <?php echo $form->labelEx($category, 'title');?> 
                    <?php echo $form->textField($category, 'title',  $category->getHtmlOptions('title')); ?>
                    <?php echo $form->error($category, 'title');?>
                </div>
              <div class="form-group col-sm-3">
                    <?php echo $form->labelEx($category, 'banner');?> 
                    <?php echo $form->fileField($category, 'banner',  $category->getHtmlOptions('banner')); ?>
                    <?php echo $form->error($category, 'banner');?>
                </div>
                <div class="form-group col-sm-3">
                    <?php echo $form->labelEx($category, 'short_description');?> 
                    <?php echo $form->textArea($category, 'short_description',  $category->getHtmlOptions('short_description')); ?>
                    <?php echo $form->error($category, 'short_description');?>
                </div>
					</div>
                    <div class="row">
                    <div class="form-group col-sm-6">
                    <?php echo $form->labelEx($category, 'video');?> 
                    <?php echo $form->textField($category, 'video',  $category->getHtmlOptions('video')); ?>
                    <?php echo $form->error($category, 'video');?>
                </div>
                <div class="form-group col-sm-6">
                    <?php echo $form->labelEx($category, 'map');?> 
                    <?php echo $form->textField($category, 'map',  $category->getHtmlOptions('map')); ?>
                    <?php echo $form->error($category, 'map');?>
                </div>
                <script>
        document.getElementById('<?php echo $category->modelName;?>_map').addEventListener('paste', function(event) {
            // Get the pasted content
            let paste = (event.clipboardData || window.clipboardData).getData('text');
            
            // Create a temporary DOM element to parse the HTML string
            const tempDiv = document.createElement('div');
            tempDiv.innerHTML = paste;

            // Extract the src attribute from the iframe
            const iframe = tempDiv.querySelector('iframe');
            if (iframe) {
                const iframeSrc = iframe.getAttribute('src');
                // Copy the extracted src to the target textfield
                document.getElementById('targetTextField').value = iframeSrc;

                // Display an alert with the extracted src
                
            }  
        });
    </script>
                    </div>
                    <div class="row">
                                        <div class="form-group col-sm-12">
                                        <?php echo $form->labelEx($category, 'overview');?> 
                                        <?php echo $form->textArea($category, 'overview',  $category->getHtmlOptions('overview',['rows'=>'9'])); ?>
                                        <?php echo $form->error($category, 'overview');?>
                                        </div>
                                        <div class="form-group col-sm-12">
                                        <?php echo $form->labelEx($category, 'property');?> 
                                        <?php echo $form->textArea($category, 'property',  $category->getHtmlOptions('property',['rows'=>'9'])); ?>
                                        <?php echo $form->error($category, 'property');?>
                                        </div>
                                        <div class=" " style="padding-left:15px;">
                  
                  <div class="form-group col-lg-3">
    <style>
    #div_view_whatsapp_c_image img { width:100px !important; }
    </style>
 <?php  
 $fileField = 'cover_image';
 $types = '.png,.jpg,.pdf,.jpeg';
 $maxFiles = '1';
 $maxFilesize = '2';
 $article = $category;
  $this->renderPartial('backend.views.articles._file_field_browse3',compact('form','fileField','maxFilesize','types','maxFiles','article'));
   ?>
 
</div>

</div>
<style>#abc_banner .btn {width:100% !important;height: auto !important; } #abc_banner.browse_type .dropzone .dz-message .upload-btn-wrapper{ padding: 0px;box-shadow: unset;max-width: 200px;}
#abc_image  .dz-preview { display:none !important; }
#file_image .upload-btn-wrapper .drop_fil{ margin-top:15px !important; }
</style>
                    </div>
            <div class="clearfix"></div>
             	   <div class="clearfix"></div>	
				       <div class="clearfix"></div>
                       <hr>
                       FAQ's
                       <hr>
                       <table class="table table-bordered">
                        <tr>
                            <th>Question</th>
                            <th>Answer</th>
                            <th>Options</th>
                        </tr>
                        <?php
                        $total_faqs = 0; 
                        if(!empty($category->faqs)){
                            $category->faqs = json_decode($category->faqs,true);
                            $total_faqs = sizeOf($category->faqs['name']);
                        }
                        if($total_faqs=='0'){
                        ?>
                             <tr><td><input type="text" name="option[name][]"  class="form-control"  ></td><td><textarea  name="option[answer][]"  class="form-control" ></textArea></td><td><a href="javascript:void(0)"><i class="glyphicon glyphicon-trash text-danger"></i></a></td></tr>
                        <?php
                        }else{
                            for($i=0;$i<$total_faqs;$i++){
                                echo '<tr><td><input type="text" name="option[name][]" value="'.$category->faqs['name'][$i].'"  class="form-control"  ></td><td><textarea  name="option[answer][]"  class="form-control" >'.$category->faqs['answer'][$i].'</textArea></td><td><a href="javascript:void(0)"><i class="glyphicon glyphicon-trash text-danger"></i></a></td></tr>';
                            }
                        }
                        ?>
                             <tr id="last"><td colspan="3" ><a href="javascript:void(0)" onclick="addmore()" class="btn btn-success" onclick="removeth(this)" >Add More</a></td></tr>
                       </table>
                       <script>
                        function addmore(){
                            $('#last').before('<tr><td><input type="text" name="option[name][]" class="form-control" ></td><td><textarea  name="option[answer][]"  class="form-control" ></textArea></td><td><a href="javascript:void(0)" onclick="removeth(this)"><i class="glyphicon glyphicon-trash text-danger"></i></a></td></tr>')
                        }
                        function removeth(k){
                            $(k).closest('tr').remove();
                        }
                       </script>
              
                <div class="clearfix"><!-- --></div>
                   <?php 
                /**
                 * This hook gives a chance to append content after the active form fields.
                 * Please note that from inside the action callback you can access all the controller view variables 
                 * via {@CAttributeCollection $collection->controller->data}
                 * @since 1.3.3.1
                 */
                $hooks->doAction('after_active_form_fields', new CAttributeCollection(array(
                    'controller'    => $this,
                    'form'          => $form    
                )));
                ?>
                <div class="clearfix"><!-- --></div>
            </div>
            <div class="box-footer">
                <div class="pull-right">
                    <button type="submit" class="btn btn-primary btn-submit" data-loading-text="<?php echo Yii::t('app', 'Please wait, processing...');?>"><?php echo Yii::t('app', 'Save changes');?></button>
                </div>
                <div class="clearfix"><!-- --></div>
            </div>
        </div>
        <?php 
        $this->endWidget(); 
    } 
    /**
     * This hook gives a chance to append content after the active form.
     * Please note that from inside the action callback you can access all the controller view variables 
     * via {@CAttributeCollection $collection->controller->data}
     * @since 1.3.3.1
     */
    $hooks->doAction('after_active_form', new CAttributeCollection(array(
        'controller'      => $this,
        'renderedForm'    => $collection->renderForm,
    )));
}
/**
 * This hook gives a chance to append content after the view file default content.
 * Please note that from inside the action callback you can access all the controller view
 * variables via {@CAttributeCollection $collection->controller->data}
 * @since 1.3.3.1
 */
$hooks->doAction('after_view_file_content', new CAttributeCollection(array(
    'controller'        => $this,
    'renderedContent'   => $viewCollection->renderContent,
)));
?>
<script>
 
var modelName = '<?php echo $category->modelName;?>'
function load_via_ajax(k,id){
	var url_load = $(k).attr('data-url') 
	if(url_load !== undefined){
		url_load += '/id/'+$(k).val(); 
	 
		 $('#'+modelName+'_'+id).val('');
		 $('#'+modelName+'_'+id).html('<option value="">Loading...</option>').select2(); ;
		 var attr_id = $(k).attr('id');
		 
		 $.get(url_load,function(data){ var data = JSON.parse(data) ;   $('#'+modelName+'_'+id).html(data.data).select2();;  if(data.size != '0') {    $('#'+modelName+'_'+id).closest('.form-group').removeClass('hidden') }else{  $('#'+modelName+'_'+id).closest('.form-group').addClass('hidden') }  })
	}
}</script>
