<?php

/**
 * This is the model class for table "mw_ad_image".
 *
 * The followings are the available columns in table 'mw_ad_image':
 * @property integer $id
 * @property integer $ad_id
 * @property string $image_name
 * @property integer $priority
 * @property string $isTrash
 *
 * The followings are the available model relations:
 * @property PlaceAnAd $ad
 */
class AdImage extends ActiveRecord
{
    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return 'mw_ad_image';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('ad_id, image_name', 'required'),
            array('ad_id, priority', 'numerical', 'integerOnly'=>true),
            array('image_name', 'length', 'max'=>250),
            array('isTrash,status', 'length', 'max'=>1),
            array('xml_image,image_type , Title , IsMarketingImage , ImageRemarks ', 'safe'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, ad_id, image_name, priority, isTrash,status', 'safe', 'on'=>'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'ad' => array(self::BELONGS_TO, 'PlaceAnAd', 'ad_id'),
            'imageCount' => array(self::STAT, 'PlaceAnAd', 'ad_id','condition'=>"t.isTrash='0' and t.status='A'"),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'ad_id' => 'Ad',
            'image_name' => 'Image Name',
            'priority' => 'Priority',
            'isTrash' => 'Is Trash',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('id',$this->id);
        $criteria->compare('ad_id',$this->ad_id);
        $criteria->compare('image_name',$this->image_name,true);
        $criteria->compare('priority',$this->priority);
        $criteria->compare('status',$this->status,true);
        $criteria->compare('isTrash','0',true);

       return new CActiveDataProvider(get_class($this), array(
            'criteria'      => $criteria,
            'pagination'    => array(
                'pageSize'  => $this->paginationOptions->getPageSize(),
                'pageVar'   => 'page',
            ),
        
        ));
    }
  public function getImageUrl(){
	  	 
	  if($this->image_type=='F'){
		  	return  Yii::app()->apps->getBaseUrl('uploads/ads/'.$this->image_name);
	  }
	  else{
		  	return  Yii::app()->apps->getBaseUrl('uploads/ads/'.$this->image_name);
				
	  }
  }
    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return AdImage the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }
    public function HighestPriorityImage($ad_id)
    {
		 $criteria=new CDbCriteria;
		 $criteria->condition = "t.ad_id=:ad_id and isTrash='0' and status='A'";
		 $criteria->params[':ad_id'] = $ad_id;
		 $criteria->order = "priority";
		 return $this->find($criteria);
	}
 
	public function listImage($id)
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('ad_id',$this->ad_id);
        $criteria->order = "  t.priority DESC   , ISNULL(t.priority), t.id asc";
        $criteria->condition = "t.ad_id=:ad_id and isTrash='0'";
        // $criteria->compare('status',$this->status);
        $criteria->params[':ad_id'] = $id;
       return new CActiveDataProvider(get_class($this), array(
            'criteria'      => $criteria,
            'pagination'    => array(
                'pageSize'  => $this->paginationOptions->getPageSize(),
                'pageVar'   => 'page',
            ),
        
        ));
    }
    public function activeArray()
    {
		$arr = array("A"=>"Approved","I"=>"Disapproved");
		return $arr;
	}
	 public function getStatusWithStats($sta=null)
    {
	  $ar = $this->activeArray();
	   return (isset($ar[$sta]))?$ar[$sta]:"Inactive";
		 
    }
    public function getImagetThumb($w=150,$q=90)
    { 
	   $imagethuburl = Yii::app()->apps->getBaseUrl('timthumb/timthumb.php').'?&w='.$w.'&q='.$q.'&src='.Yii::app()->apps->getBaseUrl('uploads/ads');
	   return  $imagethuburl.'/'.$this->image_name ;
    }
    public function getImageRend(){
    return  CHtml::image( $this->ImagetThumb  ,"no Image Found",array("style"=>"width:50px;height:50px"));
    }
}
