<?php

/**
 * This is the model class for table "mw_banner".
 *
 * The followings are the available columns in table 'mw_banner':
 * @property integer $banner_id
 * @property integer $position_id
 * @property string $image
 * @property string $status
 * @property string $isTrash
 * @property integer $priority
 *
 * The followings are the available model relations:
 * @property BannerPosition $position
 */
class Banner extends ActiveRecord
{
    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return 'mw_banner';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('position_id,ad_type,', 'required'),
            array('link_url,image', 'required', 'on' => 'imageAD'),
            array('script', 'required', 'on' => 'scriptAD'),
            array('position_id, priority', 'numerical', 'integerOnly'=>true),
            array('image', 'length', 'max'=>250),
            array('image', 'file', 'types'=>'jpg,jpeg, gif, png','allowEmpty'=>true,'on'=>'imageAD'),
            array('status, isTrash', 'length', 'max'=>1),
          array('script,link_url', 'safe'),
          
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('banner_id, position_id, image, status, isTrash, priority ,script', 'safe', 'on'=>'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'position' => array(self::BELONGS_TO, 'BannerPosition', 'position_id','on'=>"position.isTrash='0'",'joinType'=>'INNER JOIN'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'banner_id' => 'Banner',
            'position_id' => 'Position',
            'image' => 'Image',
            'status' => 'Status',
            'isTrash' => 'Is Trash',
            'priority' => 'Priority',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('banner_id',$this->banner_id);
        $criteria->compare('position_id',$this->position_id);
        $criteria->compare('image',$this->image,true);
        $criteria->compare('t.isTrash',0,true);
        $criteria->compare('t.status','A',true);
        $criteria->compare('priority',$this->priority);
        $criteria->order="t.position_id,t.priority";
         $criteria->with ="position";

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }
    public function listpageBanners($f_type){
		$criteria=new CDbCriteria;
		$criteria->select = 't.image';
		$criteria->condition = '1'; 
     	$criteria=new CDbCriteria;  
        $criteria->compare('t.status','A');
        $criteria->compare('t.position_id',(int)$f_type); 
        $criteria->order="-t.priority desc";
        $ar =  $this->find($criteria);
        $items = '';
        if(!empty($ar)){
          
               $items  = $ar->image;  
           
        }
        return $items;
	}
    public function pageBannerList($f_type){
	    $cacheKey = 'page_b'. Yii::app()->options->get('system.common.banner_c_cahe','12e43').$f_type; 
		if ($items = Yii::app()->cache->get($cacheKey) and !isset($_GET['refresh'])) {
		     
			  return $items;
		}
		 
		$items = $this->listpageBanners($f_type);
 
		Yii::app()->cache->set($cacheKey, $items,60 * 60 * 24 * 30);
		return $items;
	}
    public function getBannerById($id=null){
         $criteria=new CDbCriteria;

        $criteria->compare('banner_id',(int)$id);
       
        return  self::model()->find($criteria); 
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Banner the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }
    public function getBanner($id)
	{
		 
		 
		return $this->findByPk($id) ;
		 
	}

 
}
