<?php



/**

 * This is the model class for table "{{insurance_form}}".

 *

 * The followings are the available columns in table '{{insurance_form}}':

 * @property integer $id

 * @property string $sal

 * @property string $f_name

 * @property string $m_name

 * @property string $last_name

 * @property string $m_status

 * @property integer $nationlity

 * @property string $dob

 * @property string $occupation

 * @property string $p_o

 * @property string $employer

 * @property string $phone

 * @property string $land

 * @property integer $city

 * @property string $email

 * @property string $address

 * @property string $date_added

 * @property string $last_updated

 */

class Brochure  extends ActiveRecord

{

    /**

     * @return string the associated database table name

     */

    

       public function tableName()

    {

        return '{{brochure_new}}';

    }



	public $name;

	public $email;

	public $phone_false;

	public $cover_letter;

	public $image;

	public $phone;

    /**

     * @return array validation rules for model attributes.

     */

    public function rules()

    {

        // NOTE: you should only define rules for those attributes that

        // will receive user inputs.

        return array(

            array('name,email,phone_false', 'required',   'message'=> 'Required' ),

             array('name,email,phone_false,cover_letter,image,master_id,ad_id,f_type', 'safe' ),

            array('name', 'length', 'max'=>100),

            array('image', 'length', 'max'=>400),

            array('phone', 'safe'),

             // array('_recaptcha', 'validateRecaptcha' ,"on"=>'insert' ),

              array('phone_false', 'validatePhone'),

            array('email', 'email','message'=> 'Enter a valid email address.' ),

                );

    }

     public function validateRecaptcha($attribute,$params){

		

		  if(!Yii::app()->request->isAjaxRequest){

 

	 

			$captcha= '';

			if(isset($_POST['g-recaptcha-response'])){

			$captcha=$_POST['g-recaptcha-response'];

			}



			if(!$captcha){

				$this->addError($attribute,  'Please check the   captcha form.' );

			}

		 

				 

			$data = array(

			'secret' =>  Yii::app()->options->get('system.common.google_recaptcha_secret','') ,

			'response' => $captcha,

			'remoteip' => $_SERVER['REMOTE_ADDR']

			);



			$verify = curl_init();

			curl_setopt($verify, CURLOPT_URL, "https://www.google.com/recaptcha/api/siteverify");

			curl_setopt($verify, CURLOPT_POST, true);

			curl_setopt($verify, CURLOPT_POSTFIELDS, http_build_query($data));

			curl_setopt($verify, CURLOPT_SSL_VERIFYPEER, false);

			curl_setopt($verify, CURLOPT_RETURNTRANSFER, true);

			$res = curl_exec($verify);



			$captcha = json_decode($res);

			

		 

				if ($captcha->success) {

						 

				 }

				 else{

					 $this->addError($attribute,  'You are a spammer.' );

				 }

				

 

		 

		  }

		   

	}

     public function beforeValidate(){

		

	   if(parent::beforeValidate()) 

	   {

            

             $this->phone = (!empty($this->phone)) ? $this->phone : $this->phone_false;

			  

		 

			 return true;

	   }

	return false;

	 

	} 

	 public function afterSave(){ 

	     parent::afterSave();
		$ad = PlaceAnAd::model()->findByPk($this->ad_id);
		ContactUs::model()->sendBrochureToBitrix($this->name, $this->email, $this->phone,  $ad->ad_title);

        $options = Yii::app()->options ; 

		  $emailTemplate_customer =  CustomerEmailTemplate::model()->getTemplateByUid("yt656j8le9752");

		  $emailTemplate_common = $this->commonTemplate()   ;

		  $emailTemplate_admin =  CustomerEmailTemplate::model()->getTemplateByUid("kz196ksv3h355");

		  /*

		  if($emailTemplate_customer){

					$subject		= $emailTemplate_customer->subject;

					$emailTemplate = $emailTemplate_customer->content;					 

					$emailTemplate = str_replace('[NAME]',$this->name, $emailTemplate);

					$emailTemplate =   Yii::t('app',$emailTemplate_common, array( '[CONTENT]'=>$emailTemplate)); 

					

					

					$email = new TransactionalEmail();

					$email->sendDirectly =true;

					$email->to_name      = $this->name;

					$email->to_email     = $this->email;

					$email->from_name    = $options->get('system.common.site_name', 'Marketing website');

					$email->subject      = $subject;

					$email->body         = $emailTemplate;

					$email->save(); 

					

					     

				}

				*/

		  if($emailTemplate_admin){

					$subject		= $emailTemplate_admin->subject;

					$emailTemplate = $emailTemplate_admin->content;	

					

							$emailTemplate =  Yii::t('app', $emailTemplate,

						

								array(

						 

								'{date}' => date('d-m-Y'),

								'{name}' => $this->name,

								'{email}' => $this->email, 

								'{phone}' => $this->phone, 

								'{property}' => $ad->ad_title,

								'{ref}' => $ad->referenceNumberTitle,

								)

							);


			



			$email = new TransactionalEmail();

					$email->sendDirectly =true;

					$email->to_name      = 'Admin';

					$email->to_email     = defined('MY_EMAIL') ?MY_EMAIL : $options->get('system.common.admin_email','support@kayeandco.ae');

					$email->from_name    = $options->get('system.common.site_name', 'Marketing website');

					$email->subject      = $subject;

					$email->body         = $emailTemplate;

					$email->save(); 

					 

				}

			 

			 
				$liamamodel = new ContactUs();
				$adModel                =    new PlaceAnAd();
				$criteria               =    $adModel->findAds(array('_sec_id'=>3),false,1); 
				$criteria->compare('t.id',(int)$this->ad_id);
				$adModel 			=   $adModel->find($criteria);
				$data = []; 
				 
				 
				 
			 
	 return true;

       

     

	}

	 public function getBackendUrl(){

		return ABS_URL.'/site/career_file/file/'.Yii::t('app',$this->image,array('/'=>'|'));

	}

	public function commonTemplate(){

		return Yii::app()->options->get('system.email_templates.common');

	}

    /**

     * @return array relational rules.

     */

      public function relations()

    {

        // NOTE: you may need to adjust the relation name and the related

        // class name for the relations automatically generated below.

        return array(

           'master0' => array(self::BELONGS_TO, 'Master', 'master_id'),

            'ad' => array(self::BELONGS_TO, 'PlaceAnAd', 'ad_id'),

        );

    }

  public function getadURl(){

      $url = $this->ad->PreviewUrlNew;

      return CHtml::link($this->ad_title,$url,array('target'=>'_blank'));

  }

  public $ad_title;public $ad_slug; 

    public function search()

    {

        // @todo Please modify the following code to remove attributes that should not be searched.



        $criteria=new CDbCriteria;$criteria->select = 't.*,ad.ad_title,ad.slug as ad_slug';
		$criteria->condition = '1'; 
        $criteria->compare('id',$this->id); 

        $criteria->compare('email',$this->email,true);

        $criteria->compare('ad.ad_title',$this->ad_title,true);

        $criteria->compare('name',$this->name,true); 
		if($this->f_type !=''){
			$criteria->condition .= ' and COALESCE(t.f_type,0) = :ftype'; 
			$criteria->params[':ftype'] = $this->f_type;
		}
         $criteria->join = ' inner join {{place_an_ad}} ad on ad.id = t.ad_id  ';

         $criteria->order="id desc";

		$pageSize = (Yii::app()->request->getQuery("page_size")) ?  (int) Yii::app()->request->getQuery("page_size") : $pageSize = 10;

	 return new CActiveDataProvider(get_class($this), array(

            'criteria'      => $criteria,

            'pagination'    => array(

                'pageSize'  => $this->paginationOptions->getPageSize(),

                'pageVar'   => 'page',

            ),

            'sort'  => array(

                'defaultOrder'  => array(

                    'id'   => CSort::SORT_ASC,

                ),

            ),

        ));

    }

    /**

     * @return array customized attribute labels (name=>label)

     */

    public function attributeLabels()

    {

        return array(

           'image' => 'Upload CV' ,

           'master_id' => 'Designation',
		   'f_type' => 'Request Type'

        );

    }
	public function FtypeArray(){
		return [
			'0' => 'Brochure',
			'1' => 'Floor Plan',
			'2' => 'Payment Plan'
		];
	}
	public function getFType(){
		switch($this->f_type){
			case '1' :
				return 'Floor Plan';
			break;
			case '2' :
				return 'Payment Plan';
			break;
			default :
				return 'Brochure';
			break;
		}
	}



    /**

     * Retrieves a list of models based on the current search/filter conditions.

     *

     * Typical usecase:

     * - Initialize the model fields with values from filter form.

     * - Execute this method to get CActiveDataProvider instance which will filter

     * models according to data in model fields.

     * - Pass data provider to CGridView, CListView or any similar widget.

     *

     * @return CActiveDataProvider the data provider that can return the models

     * based on the search/filter conditions.

     */

        

    public $agree;

    public $_recaptcha; 

 public function getAttibuteLabelWithEx($label){

		 $html ='';

		 if($this->isAttributeRequired($label)){  $html = '<span class="ateric"> * </span>'; };

		 return $this->getAttributeLabel($label).$html;

	 }

     public function validatePhone($attribute,$params)

	{

		if(!empty($this->$attribute)){

			$string = $this->$attribute;

			$strlen = strlen(Yii::t('app',$string,array(' '=>'')));

			if (strpos($this->$attribute, '+') !== false) {

				$string = substr($this->$attribute,1,strlen($this->$attribute));

			}

			if($strlen<9){

					 $this->addError($attribute,  Yii::t('app','Please enter a valid  Mobile No.'.$this->$attribute));	

			}

			if($strlen>14){

					 $this->addError($attribute,  Yii::t('app','Please enter a valid  Mobile No.'.$this->$attribute));	

			}

			if (substr_count($string, ' ') > 3 ) {

				 $this->addError($attribute,  Yii::t('app','Please enter a valid  Mobile No.'.$this->$attribute));				 

			}

			 

			$rtl_chars_pattern = '/^[\s\d]+$/';

			 

			if(preg_match($rtl_chars_pattern, $string)  ) {

			  

			}

			else {

			   $this->addError($attribute,  Yii::t('app','Please enter a valid  Mobile No.'.$this->$attribute));

			}

			 

		}

	}

    /**

     * Returns the static model of the specified AR class.

     * Please note that you should have this exact method in all your CActiveRecord descendants!

     * @param string $className active record class name.

     * @return InsuranceForm the static model class

     */

    public static function model($className=__CLASS__)

    {

        return parent::model($className);

    }

      

}