<?php

/**
 * This is the model class for table "mw_currency_preference".
 *
 * The followings are the available columns in table 'mw_currency_preference':
 * @property integer $currency_preference_id
 * @property float $value
 * @property string $label
 * @property string $country
 * @property string $date_added
 *
 */
class CurrencyPreference extends ActiveRecord
{
	 public $verifyCode;
    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return 'mw_currency_preference';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('value, label, country','required'),
            array('date_added', 'safe'),
            array('currency_preference_id, value, label, country, date_added', 'safe', 'on'=>'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array();
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'currency_preference_id' => 'View Currency Preference',
            'value' => 'Value',
            'label' => 'Label',
            'country' => 'Country',
            'date_added' => 'Added Date',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('currency_preference_id',$this->currency_preference_id);
        $criteria->compare('value',$this->value,true);
        $criteria->compare('label',$this->label,true);
        $criteria->compare('country',$this->country,true);
        $criteria->compare('date_added',$this->date_added,true);
// 		$criteria->together = true;
// 		$criteria->with = array('ad'=>array("condition"=>"ad.isTrash='0'"));
        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
             'pagination'    => array(
                'pageSize'  => $this->paginationOptions->getPageSize(),
                'pageVar'   => 'page',
            ),
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Contact the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }
}
