<?php

/**
 * This is the model class for table "mw_landing_registrations".
 *
 * The followings are the available columns in table 'mw_landing_registrations':
 * @property integer $register_id
 * @property string $full_name
 * @property string $email
 * @property string $phone
 * @property string $interested_in
 * @property string $i_am
 * @property string $added_date
 *
 */
class LandingRegistrations extends ActiveRecord
{
	 public $verifyCode;
    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return 'mw_landing_registrations';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('full_name, email, phone, interested_in, i_am', 'required'),
            array('added_date', 'safe'),
            array('full_name', 'length', 'max'=>250),
            array('email', 'length', 'max'=>150),
            array('email', 'email'),
            array('phone', 'length', 'max'=>15),
            array('interested_in', 'length', 'max'=>50),
            array('i_am', 'length', 'max'=>50),
            array('register_id, full_name, email, phone, interested_in, i_am, added_date', 'safe', 'on'=>'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array();
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'register_id' => 'View Registrations',
            'full_name' => 'Full Name',
            'email' => 'Email',
            'phone' => 'Phone',
            'interested_in' => 'Interested In',
            'i_am' => 'I Am',
            'added_date' => 'Added Date',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('register_id',$this->register_id);
        $criteria->compare('full_name',$this->full_name,true);
        $criteria->compare('email',$this->email,true);
        $criteria->compare('phone',$this->phone,true);
        $criteria->compare('interested_in',$this->interested_in,true);
        $criteria->compare('i_am',$this->i_am,true);
        $criteria->compare('added_date',$this->added_date,true);
		$criteria->together = true;
		$criteria->with = array('ad'=>array("condition"=>"ad.isTrash='0'"));
        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
             'pagination'    => array(
                'pageSize'  => $this->paginationOptions->getPageSize(),
                'pageVar'   => 'page',
            ),
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Contact the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }
}
