<?php

/**
 * This is the model class for table "{{newsletter}}".
 *
 * The followings are the available columns in table '{{newsletter}}':
 * @property integer $id
 * @property string $first_name
 * @property string $last_name
 * @property string $email
 * @property string $date_added
 */
class Newsletter extends  ActiveRecord
{
    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return '{{newsletter}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('first_name, email,last_name', 'required'),
            array('first_name', 'length', 'max'=>100),
            array('phone_false', 'validateHiddenInput' ),
            array('email', 'length', 'max'=>250),
            array('email', 'email'),
            array('email', 'unique'),
            array('is_phone_validated', 'safe'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, first_name, last_name, email, date_added', 'safe', 'on'=>'search'),
        );
    }
    public function validateHiddenInput($attribute,$params)
	{
		
			if($this->is_phone_validated!='1'){
				$this->addError('last_name',  'Please enter valid phone number');
		    }
			 
	}
    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public $phone_false; 
    public $is_phone_validated;
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'phone_false' => 'Phone Number',
            'first_name' => 'Name',
            'last_name' => 'Phone Number',
            'email' => 'Email',
            'date_added' => 'Date Added',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('id',$this->id);
        $criteria->compare('first_name',$this->first_name,true);
        $criteria->compare('last_name',$this->last_name,true);
        $criteria->compare('email',$this->email,true);
        $criteria->compare('date_added',$this->date_added,true);

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Newsletter the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }
    public function afterSave(){
		parent::afterSave();     
        $liamamodel = new ContactUs();   
        $data =   [
            [                                        
                "identity" => [
                    "email" =>  $this->email,
                    "token" => $_COOKIE["liana_t"],  //Liana Cookie fetched from the tracking cookie.
                ],
                "events" => [         
                    [
                        "verb" => "Contact",            
                        "items" => [
                                "Email" => $this->email
                        ]
                    ],
                    [
                        "verb" => "Subscribed to Newsletter",         
                        "items" => [
                            "Project Name" => $this->first_name,
                            "Project Location" =>$this->last_name,
                            "Page URL"    => "",
                        ]
                    ]
                ]
            ]
          ];
          $liamamodel->sendLiama($data); 
   
    return true; 
    }
}