<?php

/**
 * This is the model class for table "mw_place_an_ad".
 *
 * The followings are the available columns in table 'mw_place_an_ad':
 * @property integer $id
 * @property integer $section_id
 * @property integer $category_id
 * @property integer $sub_category_id
 * @property string $ad_title
 * @property string $ad_description
 * @property integer $engine_size
 * @property string $killometer
 * @property integer $model
 * @property string $price
 * @property string $year
 * @property integer $city
 * @property integer $neighbourhood
 * @property string $mobile_number
 * @property integer $employment_type
 * @property string $compensation
 * @property integer $education_level
 * @property integer $experience_level
 * @property string $skills
 * @property string $area
 * @property integer $bathrooms
 * @property integer $bedrooms
 * @property integer $user_id
 * @property string $added_date
 * @property string $modified_date
 * @property integer $priority
 * @property string $isTrash
 * @property string $status
 * @property string $slug
 */
class PlaceAnAd extends ActiveRecord
{
	public $amenities;
	public $amenities_fields;
	public $location;
	public $location_longitude;
	public $location_latitude;
	public $values;
	public $keyword;
	public $name;
	public $email;
	public $dynamicArray;
	public $image;
	public $p_img;
	public $xml_listing_date;
	public $_recaptcha;
	public $offering;
	public $p_allowed;
	public $contact_name;
	public $contact_email;
	public $rent_paid;
	public $car_parking;
	public $street_address;
	public $no_of_stories;
	public $pantry;
	public $kitchen;
	public $featured_list;

	const FEATURED_CONDITION = " t.isTrash='0' and featured='Y'  and t.status='A'   ";
	const LATEST_CONDITION   = " t.isTrash='0'  and t.status='A'  ";
	const FEATURED_ORDER     = " featured='Y' desc,t.id desc ";
	const LATEST_ORDER       = " t.id desc";
	const SALE_ID      	  = 1;
	const RENT_ID       	  = 2;
	const APARTMENT_FOR_SALE = 30;
	const APARTMENT_FOR_RENT = 36;
	const WAREHOUSE_ID       = 96;
	const VILLA_FOR_SALE 	  = 31;
	const VILLA_FOR_RENT     = 38;
	const OFFICE_FOR_SALE 	  = 33;
	const OFFICE_FOR_RENT    = 39;
	const COMMON_CONDITION   = " t.isTrash='0' and t.status='A'  ";
	const COMMON_ORDER       = " featured='Y' desc,t.id desc ";
	const BEDROOM_PLUS       = "10";
	const BATHROOM_PLUS      = "3";



	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'mw_place_an_ad';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		$rules1 =  array();
		if ($this->dynamic) {

			$rules1 =  array(

				//  array('ad_title,ad_description,country,state,property_name,PrimaryUnitView,price,image,  mobile_number,builtup_area,listing_type', 'required'),

				// no listing_type in frontend, removed
				array('country,price,image,  mobile_number', 'required'),
				array('builtup_area', !defined('OFFPLAN') ? 'required' : 'safe'),
				//array('location_latitude','required','message'=>'Please choose location'),
				array('bedrooms,bathrooms,parking', 'numerical', 'integerOnly' => true),
				array('price', 'numerical'),
				array('email', 'email'),
				array('p_img', 'file', 'types' => 'pdf,png,jpg', 'allowEmpty' => true),

			);
		}
		$rules  =  array(
			array('property_name,PrimaryUnitView,completion_date,project_status,sale_status,country_fetched,api_id', 'safe'),
			array('ad_title,community_id,ad_description,bg_img,caption,d_right,agent_name', defined('OFFPLAN') ? 'required' : 'safe'),
			array('listing_type,builtup_area,price,name,email,ad_title,ad_description,image,location_latitude', 'required', 'on' => 'f_insert'),
			array('_recaptcha', 'validateRecaptcha', "on" => 'f_insert'),
			array('section_id, user_id', 'required'),
			array('b_url', 'url', 'defaultScheme' => 'https'),
			array('category_id', defined('OFFPLAN') ? 'safe' : 'required'),
			array('developer_id', defined('OFFPLAN') ? 'required' : 'safe'),
			array('section_id, category_id, sub_category_id, country, state, city, district,   user_id, priority, xml_pk, community_id, sub_community_id,RetUnitCategory,floor,FloorNo', 'numerical', 'integerOnly' => true),
			array('ad_title, slug,   area_location, property_name, PrimaryUnitView, SecondaryUnitView, UnitModel, FloorNo,featured_list, MarketingUsp, Financing_company, bdm_pkg, marketing_option, arabic_title, arabic_description, mandate', 'length', 'max' => 250),
			array(' currency_abr, area_measurement', 'length', 'max' => 10),
			array('price', 'length', 'max' => 14),
			array('price,RentPerMonth,Rent', 'length', 'max' => 14),
			array('mobile_number', 'length', 'max' => 16),
			array('v_link', 'url', 'defaultScheme' => 'https'),
			array('isTrash,  dynamic,   featured, xml_inserted', 'length', 'max' => 1),
			array('caption,meta_title,meta_description,meta_keywords,pay_plan', 'length', 'max' => 250),
			array('location_latitude, location_longitude, salesman_email', 'length', 'max' => 150),
			array('xml_type', 'length', 'max' => 2),
			array('xml_reference', 'length', 'max' => 25),
			array('code, RefNo, builtup_area', 'length', 'max' => 20),
			array('parking', 'length', 'max' => 5),
			array('floor', 'length', 'max' => 3),
			array('p_numbers,rera,ded,brn,qr,listing_type,isTrash', 'safe'),
			array('nearest_metro,nearest_railway,amenities_fields,xml_inserted,p_o_r,construction_status,no_of_units,developer_id,	d_logo,d_name,	d_description,contractor,featured,	architect,l_architect,floor_pdf,payment_pdf,types_pdf,	broucher,	recmnded,promoted,is_new,add_property_types,faq,amenities,floor_plan,payment_plan,image,c1,bg_attachment1,bg_attachment2,c_img,c_description,agent_logo,b_image,header_content,footer_content,cron,register_bg', 'safe'),
			array('dynamicArray', 'unsafe'),
			array('price_on_application,service_charge,cheques,title_ar,description_ar,plot_size,developer,furnished,year,permit_number,agent_email,agent_name,agent_phone,agent_licence_number,unsubmited,off_plan,youtube_url,plot_area,area_unit_1,area_unit,bg_img_mobile', 'safe'),
			array('modified_date, xml_listing_date, xml_update_date, expiry_date,property_overview,LocalAreaAmenitiesDesc,RecommendedProperties,PropertyID,status,rental_period,name,state', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, section_id, category_id, sub_category_id, ad_title, ad_description, price, country, state, city, district, mobile_number, bathrooms, bedrooms, user_id, added_date, modified_date, priority, isTrash, status,occupant_status, slug, image, dynamic, dynamicArray, location_latitude, location_longitude, featured, area_location, xml_inserted, xml_pk, xml_type, xml_reference, xml_listing_date, xml_update_date, code, RefNo, community_id, sub_community_id, property_name, builtup_area, PrimaryUnitView, SecondaryUnitView, UnitModel, FloorNo, HandoverDate, MarketingUsp, Financing_company, parking, bdm_pkg, salesman_email, expiry_date, marketing_option, arabic_title, arabic_description, mandate, currency_abr, area_measurement, PDFBrochureLink,property_overview,ReraStrNo,image_file,b_image', 'safe', 'on' => 'search'),
		);
		return array_merge($rules1, $rules);
	}

	public function validateRecaptcha($attribute, $params)
	{

		if (!Yii::app()->request->isAjaxRequest) {


			$captcha = '';
			if (isset($_POST['g-recaptcha-response'])) {
				$captcha = $_POST['g-recaptcha-response'];
			}

			if (!$captcha) {
				$this->addError($attribute, Yii::app()->tags->getTag('captcha_check', 'Please check the   captcha form.'));
			}


			$data = array(
				'secret' =>  Yii::app()->options->get('system.common.google_recaptcha_secret', ''),
				'response' => $captcha,
				'remoteip' => $_SERVER['REMOTE_ADDR']
			);

			$verify = curl_init();
			curl_setopt($verify, CURLOPT_URL, "https://www.google.com/recaptcha/api/siteverify");
			curl_setopt($verify, CURLOPT_POST, true);
			curl_setopt($verify, CURLOPT_POSTFIELDS, http_build_query($data));
			curl_setopt($verify, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($verify, CURLOPT_RETURNTRANSFER, true);
			$res = curl_exec($verify);

			$captcha = json_decode($res);


			if ($captcha->success) {
			} else {
				$this->addError($attribute,  'You are a spammer.');
			}
		}
	}
	public function dynamicFields()
	{
		return array(

			'plot_size' => $this->getAttributeLabel('plot_size'),
			'builtup_area' => $this->getAttributeLabel('builtup_area'),
			'bathrooms' => $this->getAttributeLabel('bathrooms'),
			'bedrooms' => $this->getAttributeLabel('bedrooms'),
			'parking' => $this->getAttributeLabel('parking'),
			'furnished' => $this->getAttributeLabel('furnished'),
			'floor' => $this->getAttributeLabel('floor'),
			'FloorNo' => $this->getAttributeLabel('FloorNo'),
			'property_name' => $this->getAttributeLabel('property_name'),
			'PrimaryUnitView' => $this->getAttributeLabel('PrimaryUnitView'),
			'community_id' => $this->getAttributeLabel('community_id'),
			'sub_community_id' => $this->getAttributeLabel('sub_community_id'),
			'price_on_application' => $this->getAttributeLabel('price_on_application'),
			'cheques' => $this->getAttributeLabel('cheques'),
			'developer' => $this->getAttributeLabel('developer'),
			'year' => $this->getAttributeLabel('year'),
			'price' => $this->getAttributeLabel('price'),
			'permit_number' => $this->getAttributeLabel('permit_number'),




		);
	}
	public function getListingTypeTitle()
	{
		switch ($this->listing_type) {
			case 'C':
				return 'Commercial';
				break;
			case 'R':
				return 'Residential';
				break;
		}
	}
	public function ListingTypeArray()
	{
		return array(
			'C'  => 'Commercial',
			'R'  => 'Residential',


		);
	}
	public function getbedroomTitle()
	{
		if ($this->bedrooms == '15') {
			return 'Studio';
		} else if ($this->bedrooms == '14') {
			return '13+';
		} else {
			return $this->bedrooms;
		}
	}
	function getLocationString2()
	{

		$str = '';
		$str .=  !empty($this->community_id) ? $this->community->community_name : '';
		$str .= !empty($this->sub_community_id) ? ', ' . $this->subcommunity->sub_community_name : '';

		$str .= !empty($this->district) ? ',' . $this->district0->district_name : '';
		$str .= !empty($this->state) ? ',' . $this->state0->state_name : '';
		$str = rtrim(ltrim($str, ','), ',');
		return  $str;
	}

	public function getDetailUrl()
	{
		if ($this->section_id == '3') {
			return Yii::app()->createUrl('listings/project/', array('state_slug' => $this->state_slug, 'community_slug' => $this->community_slug, 'slug' => $this->slug));
		}
		return Yii::app()->createUrl('details/index/section/' . $this->section_id, array('slug' => $this->slug));
	}
	public function getdetailUrlAbsolute()
	{
		if ($this->section_id == '3') {
			return Yii::app()->createAbsoluteUrl('listings/project/', array('state_slug' => $this->state_slug, 'community_slug' => $this->community_slug, 'slug' => $this->slug));
		}
		return Yii::app()->createAbsoluteUrl('details/index/section/' . $this->section_id, array('slug' => $this->slug));
	}

	public function getWhatsaplink()
	{
		if (strpos($this->agent_phone, '0') === 0) {
			$this->agent_phone = preg_replace('/0/', '971', $this->agent_phone, 1);;;
		}
		return 'https://wa.me/' . Yii::t('app', $this->agent_phone, array(' ' => '', '+' => '')) . '?text=I would like to inquire about your property   - ID-' . $this->SystemRefNo . '. Please contact me at your earliest convenience. %0aProperty Link %0a  ' . $this->DetailUrlAbs;
	}
	public function getDetailUrlAbs()
	{

		return Yii::app()->createAbsoluteUrl('details/index/section/' . $this->section_id, array('slug' => $this->slug));
	}
	public function getExcerpt($length = 200)
	{
		return StringHelper::truncateLength($this->ad_description, $length);
	}
	public function getExcludeArray($fields)
	{
		$ar = $this->dynamicFields();
		if (empty($fields)) {
			return array_keys($ar);
		} else {
			foreach ($fields as $k => $v) {

				if (array_key_exists($k, $ar)) {

					unset($ar[$k]);
				}
			}
			return array_keys($ar);
		}
	}

	public function checkFieldsShow($field)
	{

		if (in_array($field, (array)$this->dynamicArray)) {
			return true;
		}
		return false;
	}


	public function price_on_application_value()
	{
		return  array('Yes' => 'Yes', 'No' => 'No');
	}
	public function furnishedArrray()
	{
		return  array('Yes' => 'Yes', 'No' => 'No', 'Partly' => 'Partly');
	}
	public function cheques_value()
	{
		for ($i = 1; $i <= 12; $i++) {
			$ar[$i] = $i;
		}
		return  $ar;
	}


	public function dynamicFieldsForPropertyForsale()
	{
		return array(
			'section_id' => 'Section',
			'category_id' => 'Category',
			'sub_category_id' => 'Sub Category',
			'body_type' => 'Body Ttype',
			'bodycondition' => 'Body Condition',
			'bedrooms' => 'Bedrooms',
			'compensation' => 'Compensation',
			'current_occupation' => 'Current Occupation',
			'color' => 'Color',
			'cylinders' => 'Cylinders',
			'door' => 'Door',
			'education_level' => 'Education Level',
			'experience_level' => 'Experience Level',
			'employment_type' => 'Employment Type',
			'fuel_type' => 'Fuel Type',
			'height' => 'Height',
			'killometer' => 'Killometer',
			'marital_status' => 'Marital Status',
			'mechanicalcondition' => 'Mechanical Condition',
			'model' => 'Model',
			'mother_tongue' => 'Mother Tongue',
			'price' => 'Price',
			'religion_id' => 'Religion',
			'skills' => 'Skills',
			'year' => 'Year',
			'warranty' => 'Warranty',
			'location_latitude' => 'Please select location on map',




		);
	}





















	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'adAmenities' => array(self::HAS_MANY, 'AdAmenities', 'ad_id'),
			'faqList' => array(self::HAS_MANY, 'AdFaq', 'ad_id'),
			'adFloorPlans' => array(self::HAS_MANY, 'AdFloorPlan', 'ad_id'),
			'adImages' => array(self::HAS_MANY, 'AdImage', 'ad_id', 'on' => "adImages.isTrash='0'"),
			'adImagesAll' => array(self::HAS_MANY, 'AdImage', 'ad_id'),
			'singleAdImage' => array(self::HAS_ONE, 'AdImage', 'ad_id', 'on' => "singleAdImage.isTrash='0' and singleAdImage.status='A'", "order" => "singleAdImage.priority"),
			'adImagesOnView' => array(self::HAS_MANY, 'AdImage', 'ad_id', 'on' => "adImagesOnView.isTrash='0' and adImagesOnView.status='A'", "order" => "adImagesOnView.priority"),
			'adImagesOnView2' => array(self::HAS_MANY, 'AdImage', 'ad_id', 'on' => "adImagesOnView2.isTrash='0'", "order" => "adImagesOnView2.status ='A' desc,adImagesOnView2.status='A' desc,adImagesOnView2.priority"),
			'adImagesOnView3' => array(self::HAS_MANY, 'AdImage', 'ad_id', 'condition' => "adImagesOnView3.isTrash='0' and adImagesOnView3.status='I' "),
			//           'adImagesOnView3' => array(self::HAS_MANY, 'AdImage', 'ad_id','on'=>"adImages.isTrash='0'"),
			'subCategory' => array(self::BELONGS_TO, 'Subcategory', 'sub_category_id'),
			'section' => array(self::BELONGS_TO, 'Section', 'section_id'),
			'ADIMAGE' => array(self::BELONGS_TO, 'Category', 'category_id'),
			'category' => array(self::BELONGS_TO, 'Category', 'category_id'),
			'community' => array(self::BELONGS_TO, 'Community', 'community_id'),
			'subcommunity' => array(self::BELONGS_TO, 'SubCommunity', 'sub_community_id'),
			'stateLocation' => array(self::BELONGS_TO, 'States', 'state'),
			'country0' => array(self::BELONGS_TO, 'Countries', 'country'),
			'state0' => array(self::BELONGS_TO, 'States', 'state'),
			'city0' => array(self::BELONGS_TO, 'City', 'city'),
			'district0' => array(self::BELONGS_TO, 'District', 'district'),
			'Marital' => array(self::BELONGS_TO, 'MaritalStatus', 'marital_status'),
			'Religion' => array(self::BELONGS_TO, 'Religion', 'religion_id'),
			'EngineSize' => array(self::BELONGS_TO, 'EngineSize', 'engine_size'),
			'Model' => array(self::BELONGS_TO, 'VehicleModel', 'model'),
			'EmploymentType' => array(self::BELONGS_TO, 'EmploymentType', 'employment_type'),
			'EducationLevel' => array(self::BELONGS_TO, 'EducationLevel', 'education_level'),
			'Occupation' => array(self::BELONGS_TO, 'Occupation', 'current_occupation'),
			'Experience' => array(self::BELONGS_TO, 'Experience', 'experience_level'),
			'Colors' => array(self::BELONGS_TO, 'Color', 'color'),
			'Customer' => array(self::BELONGS_TO, 'ListingUsers', 'user_id'),
			'Doors' => array(self::BELONGS_TO, 'Door', 'door'),
			'Bodyconditions' => array(self::BELONGS_TO, 'Bodycondition', 'bodycondition'),
			'Mechanicalconditions' => array(self::BELONGS_TO, 'Mechanicalcondition', 'mechanicalcondition'),
			'FuelTypes' => array(self::BELONGS_TO, 'FuelType', 'fuel_type'),
			'BodyTypes' => array(self::BELONGS_TO, 'BodyType', 'body_type'),
			'pTypes' => array(self::HAS_MANY, 'AdPaymentPlan', 'ad_id'),
			'pTypes1' => array(self::HAS_MANY, 'AdPropertyTypes', 'ad_id'),
		);
	}
	public $add_property_types;
	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		$label1 =  array();
		if (!empty($this->category->section_id) and $this->category->section_id == self::RENT_ID) {

			$label1 =
				array('price' => 'Rent');
		}
		$label2 =  array(
			'd_right' =>  'Right Side Image (740px x 948px)',
			'bg_img' => 'Project Image (1920px x 1080px)',
			'bg_attachment1' => 'Background Attachment 1 (1920px x 1080px)',
			'bg_attachment2' => 'Background Attachment 2 (1920px x 1080px)',
			'c_img' => 'Location Image   (678 × 668 px)',
			'c_description' => 'Community Description',
			'id' => 'ID',
			'section_id' => 'Section',
			'rent_pad' => 'Rent Paid On ',
			'category_id' => 'Category',
			'sub_category_id' => 'Sub Category',
			'ad_title' => 'Ad Title',
			'ad_description' => 'Ad Description',
			'engine_size' => 'Engine Size',
			'killometer' => 'Killometer',
			'pay_plan' => 'Payment Plan Short Description',
			'model' => 'Model',
			//  'price' => 'Price',
			'year' => 'Builtup Year',
			'country' => 'Country',
			'state' => 'State',
			'mobile_number' => 'Mobile Number',
			'p_img' => 'Passport detail [ **pdf, jpg, png]',
			'employment_type' => 'Employment Type',
			'compensation' => 'Compensation',
			'education_level' => 'Education Level',
			'experience_level' => 'Experience Level',
			//   'skills' => 'Skills',
			'area' => 'Area (sqft)',
			'bathrooms' => 'No of bathrooms',
			'bedrooms' => 'No of bedrooms',
			'parking' => 'No of parking spaces',
			'furnished' => 'Furnishing type',
			'developer' => 'Property Developer',
			'plot_size' => 'Built-up Area',
			'price' => 'Price [' . Yii::app()->options->get('system.common.defalut_currency') . ']',
			'user_id' => 'Customer',
			'added_date' => 'Added Date',
			'modified_date' => 'Modified Date',
			'age' => 'Age',
			'height' => 'Height',
			'marital_status' => 'Marital Status',
			'religion_id' => 'Religion',
			'mother_tongue' => 'Mother Tongue',
			'current_occupation' => 'Current Occupation',
			'priority' => 'Priority',
			'isTrash' => 'Is Trash',
			'status' => 'Status',
			'slug' => 'Slug',
			'bodycondition' => 'Body Condition',
			'mechanicalcondition' => 'Mechanical Condition',
			'cylinders' => 'Cylinder',
			'area_location' => 'Location',
			'community_id' => 'Community',
			'sub_community_id' => 'Sub Community',
			'builtup_area_sqft' => 'Builtup Area ( Sq.Ft. )',
			'nearest_metro' => 'Nearest metro stations',
			'nearest_railway' => 'Nearest school',
			'builtup_area' => 'Size in SQFT',
			'community_id' => 'Community ',
			'cheques' => 'The no. of cheques required',
			'floor' => 'Floor where property is located.',
			'off_plan' => 'Is Off Plan Property?',
			'youtube_url' => 'Youtube Video URL',
			'c1' =>  'Completion Year',
			'payment_pdf' => 'Upload payment plan pdf',
			'floor_pdf' => 'Upload floor plan pdf',
			'broucher' =>  'Brochure',
			'types_pdf' => 'Upload property types pdf',
			'l_architect' =>  'Landscape Architect',
			'architect' =>  'Architect',
			'd_name' => 'Developer Name',
			'd_logo' => 'Developer Logo',
			'd_description' => 'Developer Description',
			'developer_id' =>  'Developer',
			'agent_logo' => 'Agent Image',
			'b_url' => 'Brochure URL',
			'b_image' => 'Brochure Detail Page  Image',
			'header_content' => 'Header Script',
			'footer_content' => 'Footer Script',
			'v_link' => '3D Tour URL',
			'p_numbers' => 'Permit Number',
			'rera' => 'RERA',
			'ded' => 'DED',
			'brn' => 'BRN',
			'qr' => 'Trakheesi Permit',
			'register_bg' => 'Register Interest Bg',
			'bg_img_mobile' => 'Project Image Mobile  (1080px x 1920px) '

		);

		// return array_replace($label2,$label1);
		return array_merge($label2, $label1);
	}


	public function getLocationTitle()
	{
		if ($this->city_name == $this->state_name) {
			return $this->state_name;
		}
		return $this->city_name . ' , ' . $this->state_name;
	}
	public function getLocationTitleOffering()
	{

		$html =  $this->CommunityTitle;
		$str =  '<span style="font-size: 12px;color:rgba(0,0,0,0.9);font-weight: normal;"> <i class="bi bi-geo-alt" style="position: relative;top: -2px;font-size: 16px;margin-right: 4px;"></i>' . $html . '</span>';
		return   $str;
	}
	public function getCommunityTitle()
	{
		$html .= $this->community_name;
		if (!empty($this->sub_community_name)) {
			$html .=   ', ' . $this->sub_community_name;
		}

		return $html;
	}
	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search($return = false)
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria = new CDbCriteria;
		$criteria->condition = '1';
		$criteria->compare('id', $this->id);
		$criteria->compare('t.section_id', $this->section_id);
		$criteria->compare('t.listing_type', $this->listing_type);
		$criteria->compare('t.category_id', $this->category_id);
		$criteria->compare('t.sub_category_id', $this->sub_category_id);
		$criteria->compare('t.ad_title', $this->ad_title, true);
		$criteria->compare('t.featured', $this->featured, true);
		$criteria->compare('t.featured', $this->featured_list);
		$criteria->compare('t.off_plan', $this->off_plan);
		if(defined('OFFPLAN_SEARCH')){
			
			$criteria->compare('t.api_id', $this->api_id);
			$criteria->compare('t.project_status', $this->project_status);
			$criteria->compare('t.sale_status', $this->sale_status);
			$criteria->compare('t.country', $this->country);
			$criteria->join .=  ' inner join {{community}} cmnty on cmnty.community_id = t.community_id ';
			if(!empty($this->community_id)){ 
				$criteria->compare('cmnty.community_name', $this->community_id,true);
		
			}
		}
		if (empty($this->isTrash)) {
			$criteria->condition .= ' and (COALESCE(t.isTrash,"0")="0" OR  t.isTrash="")   ';
			// $criteria->compare('t.isTrash',$this->isTrash);
		}

		if (!empty($this->xml_inserted)) {
			$criteria->compare('t.xml_inserted', 1);
		}
		$criteria->compare('t.status', $this->status);
		$criteria->condition .= ' and t.cron is null';
		$criteria->order = "t.id desc";
		if (Yii::app()->isAppName('backend')) {
			if (defined('OFFPLAN')) {
				$criteria->compare('t.section_id', '3');
			}
			if (defined('NORMAL')) {
				$criteria->compare('t.section_id!', '3');
			}
		}
		if ($return) {
			return $criteria;
		}
		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
			'pagination'    => array(
				'pageSize'  => $this->paginationOptions->getPageSize(),
				'pageVar'   => 'page',
			),
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return PlaceAnAd the static model class
	 */
	public static function model($className = __CLASS__)
	{
		return parent::model($className);
	}
	public function behaviors()
	{
		return array_merge(
			parent::behaviors(),
			array(
				'SlugBehavior' => array(
					'class' => 'common.models.SlugBehavior.SlugBehavior',
					'slug_col' => 'slug',
					'title_col' => 'ad_title',
					'overwrite' => false
				)
			)
		);
	}
	public function bathrooms()
	{
		$ar = array();

		for ($i = 1; $i <= 20; $i++) {

			$ar[$i] =     $i;
		}

		return $ar;
	}

	public function getOfferingType()
	{
		if ($this->section_id == '1' and $this->listing_type == 'C') {
			return 'Commercial Property for Sale';
		} else if ($this->section_id == '1' and $this->listing_type == 'R') {
			return 'Residential Property for Sale';
		} else if ($this->section_id == '2' and $this->listing_type == 'C') {
			return 'Commercial Property for Rent';
		} else if ($this->section_id == '2' and $this->listing_type == 'R') {
			return 'Residential Property for Rent';
		}
	}

	public function getOfferingTypeUrl()
	{
		if ($this->section_id == '1' and $this->listing_type == 'C') {
			return CHtml::link('Commercial Property for Sale', Yii::app()->createUrl('searchlist/index/section/1/listing_type/C'));
		} else if ($this->section_id == '1' and $this->listing_type == 'R') {
			return CHtml::link('Residential Property for Sale', Yii::app()->createUrl('searchlist/index/section/1/listing_type/R'));
		} else if ($this->section_id == '2' and $this->listing_type == 'C') {
			return CHtml::link('Commercial Property for Rent', Yii::app()->createUrl('searchlist/index/section/2/listing_type/C'));
		} else if ($this->section_id == '2' and $this->listing_type == 'R') {
			return CHtml::link('Residential Property for Rent', Yii::app()->createUrl('searchlist/index/section/2/listing_type/R'));
		}
	}



	public function bedrooms()
	{
		$ar = array();

		for ($i = 1; $i <= 15; $i++) {

			$ar[$i] =     $i;
		}
		$ar[14] = '13+';
		$ar[15] = 'Studio';
		return $ar;
	}
	public function year()
	{
		$ar = array();

		for ($i = date("Y"); $i >= 1920; $i--) {
			$ar[$i] = $i;
		}
		return $ar;
	}
	public function warranty()
	{
		return array("Y" => "Yes", "N" => "No", "D" => "Does not apply");
	}
	public function cylinders()
	{
		return array(
			"3" => "3 Cylinder",
			"4" => "4 Cylinder",
			"5" => "5 Cylinder",
			"6" => "6 Cylinder",
			"7" => "7 Cylinder",
			"8" => "8 Cylinder",
			"9" => "9 Cylinder",
			"10" => "10 Cylinder",
			"11" => "11 Cylinder",
			"12" => "12 Cylinder",
			"13" => "Unknown",
		);
	}
	public function getCylinders($id)
	{
		$ar =  $this->cylinders();
		if (isset($ar[$id])) {
			return $ar[$id];
		} else {
			return "Unknown";
		}
	}
	public function getWarranty($id)
	{
		$ar =  $this->warranty();
		if (isset($ar[$id])) {
			return $ar[$id];
		} else {
			return "No ";
		}
	}

	public function YesNoArray()
	{
		return array("Y" => "Yes", "N" => "No", "I" => "Inactive", "A" => "Active");
	}
	public function YesNo($val)
	{

		if ((string)$val == "Y") {
			return "'Featured1'";
		} else {
			return "'Featured'";
		}
	}
	public function search_2()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria = new CDbCriteria;
		$criteria->compare('t.isTrash', '0', true);
		$criteria->order = "t.id desc";
		$criteria->with = array("adImagesOnView3");
		$criteria->together = true;
		$pageSize = (Yii::app()->request->getQuery("page_size")) ?  (int) Yii::app()->request->getQuery("page_size") : $pageSize = 20;
		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
			'pagination' => array(
				'pageSize' => $pageSize,
			),

		));
	}

	public function getFeaturedAd()
	{
		$criteria = new CDbCriteria;
		$condition		 =  "t.isTrash='0' and t.status='A' and featured='Y' and t.country=:country";;
		$paramsArray[":country"] = Yii::app()->request->cookies['country']->value;
		//FOR SPECIFI STATES

		if (Yii::app()->request->cookies['state']->value != 0) {
			$condition		 .=  " and t.state=:state";
			$paramsArray[":state"] = Yii::app()->request->cookies['state']->value;
		}
		$criteria->condition = $condition;
		$criteria->params = $paramsArray;
		$criteria->order  = "t.id desc";
		$criteria->limit = "18";
		return  $this->findAll($criteria);
	}

	public function getAdTitle()
	{
		return $this->ad_title;
	}
	public $ad_images_g;
	public $main_image;
	public function getProfileImage()
	{
		if (!empty($this->ad_images_g)) {
			$imagesArray = explode(',', $this->ad_images_g);
			if (!empty($imagesArray)) {
				$this->main_image = $imagesArray[0];
			}
		}
		if (!empty($this->main_image)) {
			return Yii::app()->apps->getBaseUrl('uploads/ads/' . $this->main_image);
		}
	}
	public function getOffplanImage()
	{
		if (!empty($this->ad_images_g)) {
			$imagesArray = explode(',', $this->ad_images_g);
			if (!empty($imagesArray)) {
				$this->main_image = $imagesArray[0];
			}
		}
		if (!empty($this->main_image)) {
			return Yii::app()->apps->getBaseUrl('uploads/images/' . $this->main_image);
		}
	}
	public function getlistImageD($img)
	{

		return Yii::app()->apps->getBaseUrl('uploads/ads/' . $img);
	}
	public function getlistImageDthumb($img, $w = 110, $q = 65)
	{
		$imagethuburl = Yii::app()->apps->getBaseUrl('timthumb/timthumb.php') . '?&w=' . $w . '&q=' . $q . '&src=' . Yii::app()->apps->getBaseUrl('uploads/ads');
		return  $imagethuburl . '/' . $img;
	}
	public function getTotalImage()
	{
		if (!empty($this->ad_images_g)) {
			$imagesArray = explode(',', $this->ad_images_g);
			if (!empty($imagesArray)) {
				$this->main_image = $imagesArray[0];
			}
			return sizeOf($imagesArray);
		}
		return 0;
	}
	public function detailArray()
	{
		return array(
			'offering_type' => $this->OfferingType,
			'category' =>  !empty($this->category_id) ? $this->category->category_name : '',
			'sub_category_id' =>  !empty($this->sub_category_id) ? $this->subCategory->sub_category_name : '',
			'Location' => $this->LocationTitle,
			'Community' => $this->community_name,
			'sub_community' => $this->sub_community_name,

			'bedrooms' => $this->bedroomTitle,
			'bathrooms' => $this->bathrooms,

			'builtup_area' => $this->builtupAreaString,
			'plot_size' => $this->PltAreaArea,

			'parking' => $this->parking,
			'furnished' => $this->furnished,
			'floor' => $this->floor,
			'FloorNo' => $this->FloorNo,

			'PrimaryUnitView' => $this->PrimaryUnitView,
			//'community_id' => !empty($this->community_id) ? $this->community->community_name: ''  ,
			//'sub_community_id' =>  !empty($this->sub_community_id) ? $this->subcommunity->sub_community_name: '' ,
			//	'price_on_application' => $this->price_on_application  ,
			'property_name' => $this->property_name,
			//	'cheques' => $this->cheques  ,
			'developer' => $this->developer,
			'year' => $this->year,
			//	'permit_number'=> $this->permit_number ,			
			//	'refNo'=> $this->SystemRefNo ,			




		);
	}
	public $community_name;
	public $community_slug;
	public $sub_community_slug;
	public $sub_community_name;
	public $city_name;
	public $state_name;
	public $fav;
	public $category_name;
	public $category_slug;
	public function findAds($formData = array(), $count_future = false, $returnCriteria = false, $calculate = false, $user_id = false)
	{

		$criteria = $this->search(1);
		$criteria->compare('t.isTrash', '0');
		$criteria->compare('t.status', 'A');
		$criteria->select  = 't.*,t.d_logo,cit.city_name,st.slug as state_slug,st.state_name,category0.category_name,category0.slug as category_slug,cm.slug as community_slug,cm.community_name as community_name,sub.slug as sub_community_slug,sub.sub_community_name,(SELECT  group_concat(`image_name` order by -img.priority asc ,img.id asc )  FROM {{ad_image}} img  WHERE  img.ad_id = t.id and  img.status="A" and  img.isTrash="0"    )   as ad_images_g   ';
		$criteria->join  = ' LEFT JOIN  {{community}} cm ON cm.community_id = t.community_id  ';
		$criteria->join  .= ' LEFT JOIN  {{category}} category0 ON category0.category_id = t.category_id  ';
		$criteria->join  .= ' LEFT JOIN  {{sub_community}} sub ON sub.sub_community_id = t.sub_community_id  ';
		$criteria->join  .= ' LEFT JOIN  {{states}} st ON st.state_id = t.state  ';
		$criteria->join  .= ' LEFT JOIN  {{city}} cit ON cit.city_id  = t.city ';
		if (isset($formData['user_fav_only'])) {
			$dataC = array();
			if ((isset(Yii::app()->request->cookies['USERFAV2']))) {
				$dataC =  Yii::app()->request->cookies['USERFAV2']->value;
			}
			$dataC	= (array) $dataC;
			$userStr = implode("', '", $dataC);
			$criteria->condition .= " and  CASE WHEN t.id  in ('{$userStr}') THEN 1 ELSE 0 END   ";
		}
		if ((isset(Yii::app()->request->cookies['USERFAV2']))) {
			$cook =  Yii::app()->request->cookies['USERFAV2']->value;
			if (!empty($cook) and is_array($cook)) {

				$userStr = implode("', '", $cook);
				$criteria->select .= " , CASE WHEN t.id  in ('{$userStr}') THEN 1 ELSE 0 END as fav ";
			}
		}
		if (isset($formData['tour3d']) and !empty($formData['tour3d'])) {

			$criteria->condition  .= ' and t.v_link  is not  null ';
		}
		if (isset($formData['agent_id']) and !empty($formData['agent_id'])) {

			$criteria->condition  .= ' and t.user_id  =  :lslug ';
			$criteria->params[':lslug'] =  $formData['agent_id'];
		}
		$community_array = array();
		$subcommunity_array = array();
		if (isset($formData['community']) and !empty($formData['community'])) {

			$community_array =  array_filter(explode('|', $formData['community']));
			if (!empty($community)) {
				// $criteria->addInCondition('cm.slug',$community);
			}
		}
		if (isset($formData['subcommunity']) and !empty($formData['subcommunity'])) {

			$subcommunity_array =  array_filter(explode('|', $formData['subcommunity']));
			if (!empty($subcommunity_array)) {
				// $criteria->addInCondition('sub.slug',$community);
			}
		}
		if (defined('DEVELOPER_ID')) {
			$criteria->condition  .= ' and t.developer_id  =  :developer_id1 ';
			$criteria->params[':developer_id1'] =  DEVELOPER_ID;
		}

		if (!empty($community_array) || !empty($subcommunity_array)) {
			$new_community_array = array_merge($community_array, $subcommunity_array);
			if (!empty($new_community_array)) {
				$ids1 =  join("','", $new_community_array);
				$criteria->condition .= " and (cm.slug in ('$ids1') OR  sub.slug in ('$ids1') )  ";
			}
		}

		if (isset($formData['listing_type']) and !empty($formData['listing_type'])) {

			$criteria->condition  .= ' and t.listing_type  =  :listing_type ';
			$criteria->params[':listing_type'] =  $formData['listing_type'];
		}
		if (isset($formData['off_plan']) and $formData['off_plan'] == '1') {
			$criteria->compare('t.off_plan', '1');
		}
		if (isset($formData['sect']) and !empty($formData['sect'])) {

			$criteria->condition  .= ' and t.section_id  =  :sect ';
			$criteria->params[':sect'] =  $formData['sect'];
		}
		if (isset($formData['category']) and !empty($formData['category'])) {

			$criteria->condition  .= ' and t.category_id  =  :category ';
			$criteria->params[':category'] =  $formData['category'];
		}

		if (isset($formData['keyword']) and !empty($formData['keyword'])) {

			$criteria->condition  .=   ' and ( LOWER(t.ad_title) like :keyword or LOWER(cm.community_name) like :keyword  or sub.sub_community_name like  :keyword or st.state_name like :keyword    or LOWER(t.ad_description)   like :keyword   or t.RefNo  like :keyword  or t.id  like :keyword ) ';
			$criteria->params[':keyword'] = '%' . strtolower($formData['keyword']) . '%';
		}
		if (isset($formData['keyword1']) and !empty($formData['keyword1'])) {

			$criteria->condition  .=   ' and ( LOWER(t.ad_title) like :keyword or LOWER(cm.community_name) like :keyword     or LOWER(t.ad_description)   like :keyword   or t.RefNo  like :keyword  or t.id  like :keyword ) ';
			$criteria->params[':keyword'] = '%' . strtolower($formData['keyword1']) . '%';
		}
		if (isset($formData['minbeds']) and !empty($formData['minbeds'])) {
			if ($formData['minbeds'] == 'bedroom-equal-and-more') {

				$criteria->condition  .=   Yii::t('ad', ' and t.bedrooms  >= "{bedrooms}"', array('{bedrooms}' => PlaceAnAd::BEDROOM_PLUS));
			} else {
				$criteria->condition  .= Yii::t('ad', ' and t.bedrooms  >= "{bedrooms}"', array('{bedrooms}' => $formData['minbeds']));
			}
		}

		if (isset($formData['maxbeds']) and !empty($formData['maxbeds'])) {
			if ($formData['maxbeds'] == 'bedroom-equal-and-more') {
				$criteria->condition  .=   Yii::t('ad', '  and ( t.bedrooms =    "11" or t.bedrooms =    "12"  or t.bedrooms =    "13"   or t.bedrooms =    "14" )  ');
			} else {
				$criteria->condition  .= Yii::t('ad', ' and t.bedrooms   = "{bedrooms}"', array('{bedrooms}' => $formData['maxbeds']));
			}
		}


		if (isset($formData['minprice']) and !empty($formData['minprice'])) {

			$criteria->condition  .= Yii::t('ad', ' and t.price >= {price}', array('{price}' => $formData['minprice']));
		}

		if (isset($formData['maxprice']) and !empty($formData['maxprice'])) {

			$criteria->condition  .= Yii::t('ad', ' and t.price <= {price}', array('{price}' => $formData['maxprice']));
		}
		if (isset($formData['p_type']) and !empty($formData['p_type'])) {


			$pp_type =  Category::model()->findByAttributes(array('slug' => $formData['p_type']));
			if ($pp_type) {
				$criteria->join  .= ' left join {{ad_property_types}} apt ON apt.ad_id = t.id and apt.type_id  =    :p_type    ';
				$criteria->params[':p_type'] = $pp_type->category_id;
				$criteria->condition  .=  ' and apt.ad_id is NOT NULL ';
			}
		}
		if (isset($formData['_state_id']) and !empty($formData['_state_id'])) {
			$criteria->condition .= ' and t.state =:_state_id ';
			$criteria->params[':_state_id'] = $formData['_state_id'];
		}
		if (isset($formData['_sec_id']) and !empty($formData['_sec_id'])) {
			$criteria->condition .= ' and t.section_id =:new_section_id ';
			$criteria->params[':new_section_id'] = $formData['_sec_id'];
		} else {
			if (!defined('ALL_PROPERTIES')) {
				$criteria->condition .= ' and t.section_id != "3" ';
			}
		}

		switch (@$formData['sort']) {
			case 'N':
				$criteria->order   =  't.id desc';
				break;
			case 'H':
				$criteria->order   =  't.price desc';
				break;

			case 'L':
				$criteria->order   =  't.price asc';
				break;
			default:
				$criteria->order   =  't.featured="Y" desc ,t.id desc ';
				break;
		}
		if ($returnCriteria) {
			return $criteria;
		}

		$criteria->limit  = Yii::app()->request->getQuery('limit', '10');
		$criteria->offset = Yii::app()->request->getQuery('offset', '0');
		/* SaFE neighbours */

		if ($calculate and $criteria->offset == 0) {
			$total = self::model()->count($criteria);
		}
		if (!empty($count_future)) {
			$Result = self::model()->findAll($criteria);
			$criteria->offset = $criteria->limit + $criteria->offset;
			$criteria->select = 't.id';
			$criteria->limit = '1';
			$future_count = self::model()->find($criteria);
			return array('result' => $Result, 'future_count' => $future_count, 'total' => $total);
		} else {
			return  self::model()->findAll($criteria);
		}
	}
	public function getFeaturedListings($limit)
	{
		$criteria			 	 =	new CDbCriteria;
		$condition			 =  self::FEATURED_CONDITION;
		$criteria->condition   =  $condition;
		$criteria->order  	 =  self::FEATURED_ORDER;
		$criteria->limit 		 =  $limit;
		return  $this->findAll($criteria);
	}
	public $cmmunityName;

	public $subcmmunityName;

	public static function getCommonCondition()
	{
		return " t.isTrash='0' and t.status='A' and t.country=" . Countries::model()->getDefaultCountryId();
	}

	public function getRealtedAds($notinIds, $section, $limit)
	{
		$criteria			 	  =	 new CDbCriteria;
		$condition			  =  self::COMMON_CONDITION;
		if ($section != "") {
			$condition			 .=  Yii::t('ad', ' and t.section_id  = "{section}"', array('{section}' => $section));
		}
		$criteria->condition   =  $condition;
		$criteria->addNotInCondition('id',  $notinIds);
		$criteria->order  	 =  self::COMMON_ORDER;
		$criteria->limit 		 =  $limit;
		return  $this->findAll($criteria);
	}

	public function getLatestListings($limit, $category = null)
	{
		$criteria			 	 =	new CDbCriteria;
		$condition			 =  self::LATEST_CONDITION;
		if ($category != "") {
			$condition			 .=  " and t.section_id=:sec";
			$criteria->params[':sec'] = $category;
		}
		$criteria->condition   =  $condition;
		$criteria->order  	 =  self::FEATURED_ORDER;
		$criteria->limit 		 =  $limit;
		return  $this->findAll($criteria);
	}
	public function offplanAfterSave()
	{
		$AdFloorPlan     = new AdFloorPlan();
		$AdPropertyTypes = new AdPropertyTypes;
		$AdFaq           = new AdFaq();
		if (!$this->isNewRecord) {
			$AdFloorPlan->deleteAllByAttributes(array('ad_id' => $this->primaryKey));
			$AdPropertyTypes->deleteAllByAttributes(array('ad_id' => $this->primaryKey));
			$AdFaq->deleteAllByAttributes(array('ad_id' => $this->primaryKey));
		}
		$imgArr =  array_filter(explode(',', $this->floor_plan));
		if (!empty($imgArr)) {
			foreach ($imgArr as $k) {
				$AdFloorPlan->isNewRecord = true;
				$AdFloorPlan->floor_id = "";
				$AdFloorPlan->ad_id = $this->id;
				$string = implode('-', explode('_', $k, -1));
				$string =  Yii::t('trn', $string, array('-' => ' ', '_' => ' '));
				//$AdFloorPlan->floor_title   =  ucfirst($string) ;
				$AdFloorPlan->floor_file   =  $k;
				$AdFloorPlan->save();
			}
		}
		$post =  Yii::App()->request->getPost('add_property_types', array());

		if (!empty($post)) {


			for ($i = 0; $i < sizeOf($post['title']); $i++) {


				$AdPropertyTypes->isNewRecord = true;
				$AdPropertyTypes->id = '';
				$AdPropertyTypes->ad_id  = $this->id;;
				$AdPropertyTypes->title = $post['title'][$i];
				$AdPropertyTypes->type_id = $post['type_id'][$i];
				$AdPropertyTypes->bed = $post['bed'][$i];
				$AdPropertyTypes->bath = $post['bath'][$i];

				$pro_description = $post['description'][$i];
				if (!empty($pro_description)) {
					$AdPropertyTypes->description = $pro_description;
				} else {
					$AdPropertyTypes->description = null;
				}
				$pro_image = $post['image'][$i];
				if (!empty($pro_image)) {
					$AdPropertyTypes->image = $pro_image;
				} else {
					$AdPropertyTypes->image = null;
				}
				$AdPropertyTypes->area_unit = '';
				$AdPropertyTypes->price_unit = '';
				$AdPropertyTypes->size = $this->formatnuber($post['size'][$i]);
				//$AdPropertyTypes->size_to =$this->formatnuber($post['size_to'][$i]);
				$AdPropertyTypes->from_price = $this->formatnuber($post['from_price'][$i]);
				//$AdPropertyTypes->to_price =$this->formatnuber($post['to_price'][$i]);
				if (!$AdPropertyTypes->save()) {
					print_r($AdPropertyTypes->getErrors());
					exit;
				}
			};
		}
		/*saving faq */
		$post =  Yii::App()->request->getPost('faq', array());

		if (!empty($post)) {


			for ($i = 0; $i < sizeOf($post['title']); $i++) {
				if (empty($post['title'][$i])) {
				} else {
					$AdFaq->isNewRecord = true;
					$AdFaq->faq_id = '';
					$AdFaq->ad_id  = $this->id;;
					$AdFaq->title = $post['title'][$i];
					$AdFaq->file  = $post['file'][$i];
					$AdFaq->save();
				}
			};
		}


		if (defined('OFFPLAN')) {
			//  $this->saveSchoolInfo();
		}
		return true;
	}
	public function beforeSave()
	{
		if(!empty($this->completion_date)){
			$this->completion_date = date('Y-m-d',strtotime($this->completion_date));
		}
		return parent::beforeSave(); 
	}
	public function afterSave()
	{
		parent::afterSave();
		if (defined('OFFPLAN')) {
			$this->offplanAfterSave();
		} else {
			$AdPaymentPlan = new AdPaymentPlan;
			if (!$this->isNewRecord) {
				$AdPaymentPlan->deleteAllByAttributes(array('ad_id' => $this->primaryKey));
			}
			/*saving property types*/
			$post =  Yii::App()->request->getPost('add_property_types', array());

			if (!empty($post)) {


				for ($i = 0; $i < sizeOf($post['title']); $i++) {

					if (empty($post['title'][$i])) {
					} else {

						$AdPaymentPlan->isNewRecord = true;
						$AdPaymentPlan->row_id = $i;
						$AdPaymentPlan->ad_id  = $this->id;;
						$AdPaymentPlan->title = $post['title'][$i];
						$AdPaymentPlan->description = $post['description'][$i];

						$AdPaymentPlan->save();
					}
				}
			}
		}
	}

	public function afterFind()
	{

		if (Yii::app()->isAppName('backend')) {
			//if(defined('OFFPLAN')){
			$this->fieldDecorator->onHtmlOptionsSetup = array($this, '_setDefaultEditorForContent');
			//}
			$this->amenities =  CHtml::listData($this->adAmenities, 'amenities_id', 'amenities_id');
		}
		parent::afterFind();
	}
	protected function afterConstruct()
	{
		if (Yii::app()->isAppName('backend')) {
			//if(defined('OFFPLAN')){

			$this->fieldDecorator->onHtmlOptionsSetup = array($this, '_setDefaultEditorForContent');
			// }
			// $this->fieldDecorator->onHtmlOptionsSetup = array($this, '_setDefaultEditorForContent');
		}
		parent::afterConstruct();
	}

	public function _setDefaultEditorForContent(CEvent $event)
	{
		if ($event->params['attribute'] == 'ad_description') {
			$options = array();
			if ($event->params['htmlOptions']->contains('wysiwyg_editor_options')) {
				$options = (array)$event->params['htmlOptions']->itemAt('wysiwyg_editor_options');
			}
			$options['id'] = CHtml::activeId($this, $event->params['attribute']);
			$options['height'] = 150;
			$options['toolbar'] = 'Simple';
			$event->params['htmlOptions']->add('wysiwyg_editor_options', $options);
		}
		if ($event->params['attribute'] == 'c_description') {
			$options = array();
			if ($event->params['htmlOptions']->contains('wysiwyg_editor_options')) {
				$options = (array)$event->params['htmlOptions']->itemAt('wysiwyg_editor_options');
			}
			$options['id'] = CHtml::activeId($this, $event->params['attribute']);
			$options['height'] = 150;
			$options['toolbar'] = 'Simple';
			$event->params['htmlOptions']->add('wysiwyg_editor_options', $options);
		}
		if ($event->params['attribute'] == 'caption') {
			$options = array();
			if ($event->params['htmlOptions']->contains('wysiwyg_editor_options')) {
				$options = (array)$event->params['htmlOptions']->itemAt('wysiwyg_editor_options');
			}
			$options['id'] = CHtml::activeId($this, $event->params['attribute']);
			$options['height'] = 150;
			$options['toolbar'] = 'Simple';
			$event->params['htmlOptions']->add('wysiwyg_editor_options', $options);
		}
		if ($event->params['attribute'] == 'header_content') {
			$options = array();
			if ($event->params['htmlOptions']->contains('wysiwyg_editor_options')) {
				$options = (array)$event->params['htmlOptions']->itemAt('wysiwyg_editor_options');
			}
			$options['id'] = CHtml::activeId($this, $event->params['attribute']);
			$options['height'] = 150;
			$options['toolbar'] = 'Simple';
			$event->params['htmlOptions']->add('wysiwyg_editor_options', $options);
		}
		if ($event->params['attribute'] == 'footer_content') {
			$options = array();
			if ($event->params['htmlOptions']->contains('wysiwyg_editor_options')) {
				$options = (array)$event->params['htmlOptions']->itemAt('wysiwyg_editor_options');
			}
			$options['id'] = CHtml::activeId($this, $event->params['attribute']);
			$options['height'] = 150;
			$options['toolbar'] = 'Simple';
			$event->params['htmlOptions']->add('wysiwyg_editor_options', $options);
		}
	}


	public function listDataFromSlug($slug)
	{
		$criteria = new CDbCriteria;
		$criteria->condition = "t.isTrash='0' and t.status='A'";
		$criteria->with = array("subCategory" => array("on" => "subCategory.isTrash='0' and subCategory.status='A'", "condition" => "subCategory.slug=:sname", "params" => array(":sname" => $slug), 'joinType' => 'INNER JOIN'));
		return  $this->findAll($criteria);
	}
	public function AdFromSlug($slug)
	{
		$criteria = new CDbCriteria;
		$criteria->condition = "t.isTrash='0' and t.status='A' and t.slug=:slug";
		$criteria->params[':slug'] = $slug;
		return  $this->find($criteria);
	}
	public function SearchCondition($search)
	{

		$condition		 =  "t.isTrash='0' and t.status='A' and t.country=:country";
		$paramsArray[":country"] = Yii::app()->request->cookies['country']->value;


		//FOR SPECIFI STATES

		if (Yii::app()->request->cookies['state']->value != 0) {
			$condition		 .=  " and t.state=:state";
			$paramsArray[":state"] = Yii::app()->request->cookies['state']->value;
		}




		//PRICE SEARCH
		if (isset($search["price__from"]) and $search["price__from"] != "") {
			$condition 			   .=  " and t.price>=:price_from";
			$paramsArray[":price_from"]  =  $search["price__from"];
		}

		if (isset($search["price__to"]) and $search["price__to"] != "") {
			$condition 			 .=  " and t.price<=:price_to";
			$paramsArray[":price_to"]  =  $search["price__to"];
		}
		//KILOMETER SEARCH
		if (isset($search["kilometer__from"]) and $search["kilometer__from"] != "") {
			$condition 					.=  " and t.killometer>=:kilometer__from";
			$paramsArray[":kilometer__from"]  =  $search["kilometer__from"];
		}

		if (isset($search["kilometer__to"]) and $search["kilometer__to"] != "") {
			$condition 				  .=  " and t.killometer<=:kilometer__to";
			$paramsArray[":kilometer__to"]  =  $search["kilometer__to"];
		}

		//BEDROOM SEARCH
		if (isset($search["bedrooms_min"]) and $search["bedrooms_min"] != "") {
			$condition 				 .=  " and t.bedrooms>=:bedrooms_min";
			$paramsArray[":bedrooms_min"]  =  $search["bedrooms_min"];
		}

		if (isset($search["bedrooms_max"]) and $search["bedrooms_max"] != "") {
			$condition 				 .=  " and t.bedrooms<=:bedrooms_max";
			$paramsArray[":bedrooms_max"]  =  $search["bedrooms_max"];
		}

		//BATHROOM SEARCH
		if (isset($search["bathrooms_min"]) and $search["bathrooms_min"] != "") {
			$condition 				  .=  " and t.bathrooms>=:bathrooms_min";
			$paramsArray[":bathrooms_min"]  =  $search["bathrooms_min"];
		}

		if (isset($search["bathrooms_max"]) and $search["bathrooms_max"] != "") {
			$condition 				  .=  " and t.bathrooms<=:bathrooms_max";
			$paramsArray[":bathrooms_max"]  =  $search["bathrooms_max"];
		}

		//YEAR SEARCH
		if (isset($search["year_min"]) and $search["year_min"] != "") {
			$condition 			 .=  " and t.year>=:year_min";
			$paramsArray[":year_min"]  =  $search["year_min"];
		}

		if (isset($search["year_max"]) and $search["year_max"] != "") {
			$condition 			 .=  " and t.year<=:year_max";
			$paramsArray[":year_max"]  =  $search["year_max"];
		}
		//Model
		if (isset($search["model"]) and $search["model"] != "") {
			$condition 			 .=  " and t.model=:model";
			$paramsArray[":model"]  =  $search["model"];
		}
		//Section
		if (isset($search["section_id"]) and $search["section_id"] != "") {
			$condition 			 .=  " and t.section_id=:section_id";
			$paramsArray[":section_id"]  =  $search["section_id"];
		}
		//CATEGORY
		if (isset($search["category_id"]) and $search["category_id"] != "") {
			$condition 			 .=  " and t.category_id=:category_id";
			$paramsArray[":category_id"]  =  $search["category_id"];
		}
		//SUBCATEGORY
		if (isset($search["sub_category_id"]) and $search["sub_category_id"] != "") {
			$condition 			 .=  " and t.sub_category_id=:sub_category_id";
			$paramsArray[":sub_category_id"]  =  $search["sub_category_id"];
		}


		//COLOR
		if (isset($search["color_id"]) and !empty($search["color_id"])) {
			$list =  implode(',', $search["color_id"]);
			$condition  .= " and  t.color in (:list)";
			$paramsArray[":list"] =  $list;
		}
		//DOOR
		if (isset($search["door_id"]) and !empty($search["door_id"])) {
			$list =  implode(',', $search["door_id"]);
			$condition  .= " and  t.door in (:list2)";
			$paramsArray[":list2"] =  $list;
		}
		//bodycondition
		if (isset($search["bodycondition_id"]) and !empty($search["bodycondition_id"])) {
			$list =  implode(',', $search["bodycondition_id"]);
			$condition  .= " and  t.bodycondition in (:list3)";
			$paramsArray[":list3"] =  $list;
		}

		//mechanicalcondition
		if (isset($search["mechanicalcondition_id"]) and !empty($search["mechanicalcondition_id"])) {
			$list =  implode(',', $search["mechanicalcondition_id"]);
			$condition  .= " and  t.mechanicalcondition in (:list4)";
			$paramsArray[":list4"] =  $list;
		}
		//user ID
		if (isset($search["user_id"]) and !empty($search["user_id"])) {

			$condition  .= " and  t.user_id in (:usr)";
			$paramsArray[":usr"] = $search["user_id"];
		}
		//fuel_id
		if (isset($search["fuel_id"]) and !empty($search["fuel_id"])) {
			$list =  implode(',', $search["fuel_id"]);
			$condition  .= " and  t.fuel_type in (:list5)";
			$paramsArray[":list5"] =  $list;
		}
		//body_type
		if (isset($search["body_type_id"]) and !empty($search["body_type_id"])) {
			$list =  implode(',', $search["body_type_id"]);
			$condition  .= " and  t.body_type in (:list6)";
			$paramsArray[":list6"] =  $list;
		}

		//DATE COMPARE
		if (isset($search["added__date"]) and $search["added__date"] != "") {
			switch ($search["added__date"]) {
				case 0:
					$condition  .= " and  DATE(t.added_date) = CURDATE()";
					break;
				case 3:
					$condition  .= " and   t.added_date >= DATE_ADD(CURDATE(), INTERVAL -3 DAY)";
				case 7:
					$condition  .= " and   t.added_date >= DATE_ADD(CURDATE(), INTERVAL -7 DAY)";
				case 14:
					$condition  .= " and   t.added_date >= DATE_ADD(CURDATE(), INTERVAL -14 DAY)";
				case 30:
					$condition  .= " and   t.added_date >= DATE_ADD(CURDATE(), INTERVAL -1 MONTH)";
				case 90:
					$condition  .= " and   t.added_date >= DATE_ADD(CURDATE(), INTERVAL -3 MONTH)";
				case 190:
					$condition  .= " and   t.added_date >= DATE_ADD(CURDATE(), INTERVAL -6 MONTH)";
			}
		}





		//KEYWORD
		if (isset($search["keyword"]) and $search["keyword"] != "") {
			$condition  .= " and ( t.ad_title like :keyword or t.ad_description like :keyword ) ";
			$paramsArray[":keyword"] = "%{$search['keyword']}%";
		}

		return array("condition" => $condition, "params" => $paramsArray);
	}
	public function getBedroomsTitle()
	{
		if ($this->bedrooms == '15') {
			return 'Studio';
		} else if ($this->bedrooms == '14') {
			return '13+';
		} else {
			return $this->bedrooms;
		}
	}
	public function getBedroomsTitle1()
	{
		if ($this->bedrooms == '15') {
			return 'Studio';
		} else if ($this->bedrooms == '14') {
			return '13+ Beds';
		} else {
			return $this->bedrooms . ' Beds';
		}
	}
	public function getBathroomsTitle()
	{
		return $this->bathrooms;
	}
	public function getBathroomsTitle1()
	{
		return $this->bathrooms . ' Baths';
	}
	public function SearchConditionCount($search)
	{
		$condition		 =  "t.isTrash='0' and t.status='A' and t.country=:country";
		$paramsArray[":country"] = Yii::app()->request->cookies['country']->value;


		//FOR SPECIFI STATES

		if (Yii::app()->request->cookies['state']->value != 0) {
			$condition		 .=  " and t.state=:state";
			$paramsArray[":state"] = Yii::app()->request->cookies['state']->value;
		}
		//PRICE SEARCH
		if (isset($search["price__from"]) and $search["price__from"] != "") {
			$condition 			   .=  " and t.price>=:price_from";
			$paramsArray[":price_from"]  =  $search["price__from"];
		}

		if (isset($search["price__to"]) and $search["price__to"] != "") {
			$condition 			 .=  " and t.price<=:price_to";
			$paramsArray[":price_to"]  =  $search["price__to"];
		}
		//KILOMETER SEARCH
		if (isset($search["kilometer__from"]) and $search["kilometer__from"] != "") {
			$condition 					.=  " and t.killometer>=:kilometer__from";
			$paramsArray[":kilometer__from"]  =  $search["kilometer__from"];
		}

		if (isset($search["kilometer__to"]) and $search["kilometer__to"] != "") {
			$condition 				  .=  " and t.killometer<=:kilometer__to";
			$paramsArray[":kilometer__to"]  =  $search["kilometer__to"];
		}

		//BEDROOM SEARCH
		if (isset($search["bedrooms_min"]) and $search["bedrooms_min"] != "") {
			$condition 				 .=  " and t.bedrooms>=:bedrooms_min";
			$paramsArray[":bedrooms_min"]  =  $search["bedrooms_min"];
		}

		if (isset($search["bedrooms_max"]) and $search["bedrooms_max"] != "") {
			$condition 				 .=  " and t.bedrooms<=:bedrooms_max";
			$paramsArray[":bedrooms_max"]  =  $search["bedrooms_max"];
		}

		//BATHROOM SEARCH
		if (isset($search["bathrooms_min"]) and $search["bathrooms_min"] != "") {
			$condition 				  .=  " and t.bathrooms>=:bathrooms_min";
			$paramsArray[":bathrooms_min"]  =  $search["bathrooms_min"];
		}

		if (isset($search["bathrooms_max"]) and $search["bathrooms_max"] != "") {
			$condition 				  .=  " and t.bathrooms<=:bathrooms_max";
			$paramsArray[":bathrooms_max"]  =  $search["bathrooms_max"];
		}

		//YEAR SEARCH
		if (isset($search["year_min"]) and $search["year_min"] != "") {
			$condition 			 .=  " and t.year>=:year_min";
			$paramsArray[":year_min"]  =  $search["year_min"];
		}

		if (isset($search["year_max"]) and $search["year_max"] != "") {
			$condition 			 .=  " and t.year<=:year_max";
			$paramsArray[":year_max"]  =  $search["year_max"];
		}
		//KEYWORD
		if (isset($search["keyword"]) and $search["keyword"] != "") {
			$condition  .= " and ( t.ad_title like :keyword or t.ad_description like :keyword ) ";
			$paramsArray[":keyword"] = "%{$search['keyword']}%";
		}
		//Model
		if (isset($search["model"]) and $search["model"] != "") {
			$condition 			 .=  " and t.model=:model";
			$paramsArray[":model"]  =  $search["model"];
		}

		//Section
		if (isset($search["section_id"]) and $search["section_id"] != "") {
			$condition 			 .=  " and t.section_id=:section_id";
			$paramsArray[":section_id"]  =  $search["section_id"];
		}
		//CATEGORY
		if (isset($search["category_id"]) and $search["category_id"] != "") {
			$condition 			 .=  " and t.category_id=:category_id";
			$paramsArray[":category_id"]  =  $search["category_id"];
		}
		//SUBCATEGORY
		if (isset($search["sub_category_id"]) and $search["sub_category_id"] != "") {
			$condition 			 .=  " and t.sub_category_id=:sub_category_id";
			$paramsArray[":sub_category_id"]  =  $search["sub_category_id"];
		}

		//COLOR
		if (isset($search["color_id"]) and !empty($search["color_id"])) {
			$list =  implode(',', $search["color_id"]);
			$condition  .= " and  t.color in (:list)";
			$paramsArray[":list"] =  $list;
		}
		//DOOR
		if (isset($search["door_id"]) and !empty($search["door_id"])) {
			$list =  implode(',', $search["door_id"]);
			$condition  .= " and  t.door in (:list2)";
			$paramsArray[":list2"] =  $list;
		}
		//bodycondition
		if (isset($search["bodycondition_id"]) and !empty($search["bodycondition_id"])) {
			$list =  implode(',', $search["bodycondition_id"]);
			$condition  .= " and  t.bodycondition in (:list3)";
			$paramsArray[":list3"] =  $list;
		}

		//mechanicalcondition
		if (isset($search["mechanicalcondition_id"]) and !empty($search["mechanicalcondition_id"])) {
			$list =  implode(',', $search["mechanicalcondition_id"]);
			$condition  .= " and  t.mechanicalcondition in (:list4)";
			$paramsArray[":list4"] =  $list;
		}

		//fuel_id
		if (isset($search["fuel_id"]) and !empty($search["fuel_id"])) {
			$list =  implode(',', $search["fuel_id"]);
			$condition  .= " and  t.fuel_type in (:list5)";
			$paramsArray[":list5"] =  $list;
		}
		//user ID
		if (isset($search["user_id"]) and !empty($search["user_id"])) {

			$condition  .= " and  t.user_id in (:usr)";
			$paramsArray[":usr"] = $search["user_id"];
		}
		//body_type
		if (isset($search["body_type_id"]) and !empty($search["body_type_id"])) {
			$list =  implode(',', $search["body_type_id"]);
			$condition  .= " and  t.body_type in (:list6)";
			$paramsArray[":list6"] =  $list;
		}
		//DATE COMPARE
		if (isset($search["added__date"])) {
			switch ($search["added__date"]) {
				case 0:
					$condition  .= " and  DATE(t.added_date) = CURDATE()";
					break;
				case 3:
					$condition  .= " and   t.added_date >= DATE_ADD(CURDATE(), INTERVAL -3 DAY)";
				case 7:
					$condition  .= " and   t.added_date >= DATE_ADD(CURDATE(), INTERVAL -7 DAY)";
				case 14:
					$condition  .= " and   t.added_date >= DATE_ADD(CURDATE(), INTERVAL -14 DAY)";
				case 30:
					$condition  .= " and   t.added_date >= DATE_ADD(CURDATE(), INTERVAL -1 MONTH)";
				case 90:
					$condition  .= " and   t.added_date >= DATE_ADD(CURDATE(), INTERVAL -3 MONTH)";
				case 190:
					$condition  .= " and   t.added_date >= DATE_ADD(CURDATE(), INTERVAL -6 MONTH)";

				default:

					break;
			}
		}
		//echo $condition;exit;
		return array("condition" => $condition, "params" => $paramsArray);
	}
	function updateXmlAds($status)
	{

		$criteria		=	new CDbCriteria;
		$criteria->condition = "xml_inserted=:xml_status";
		$criteria->params[':xml_status'] = '1';
		$this->updateAll(array('status' => $status), $criteria);
	}
	public function getAllxmlPk($SectionID)
	{
		$criteria		=	new CDbCriteria;
		$criteria->select = "t.xml_pk";
		$criteria->condition = "xml_inserted=:xml_status and t.section_id=:sec";
		$criteria->params[':xml_status'] = '1';
		$criteria->params[':sec'] = $SectionID;
		return $this->findAll($criteria);
	}
	public function getAllProspace_xml()
	{

		$criteria		=	new CDbCriteria;
		$criteria->select = "t.xml_reference,t.xml_update_date";
		$criteria->condition = "xml_inserted=:xml_status and t.xml_type=:type";
		$criteria->params[':xml_status'] = '1';
		$criteria->params[':type'] = 'P';
		return $this->findAll($criteria);
	}
	public function getAllxml($section)
	{

		$criteria		=	new CDbCriteria;
		$criteria->select = "t.id,t.modified_date,t.code";
		$criteria->condition = "t.xml_type=:type and t.section_id=:section";
		$criteria->params[':type'] = 'P';
		$criteria->params[':section'] = $section;
		return $this->findAll($criteria);
	}

	function category_isert($SectionID, $v1)
	{
		$category_model = new Category;
		$category_model->isNewRecord = true;
		$category_model->category_id     = "";
		$category_model->section_id     = $SectionID;
		$category_model->category_name  = $v1;
		$category_model->amenities_required  = 'Y';
		$category_model->xml_inserted  = '1';
		$category_model->slug = $category_model->getUniqueSlug();
		$category_model->save();
		return  Yii::app()->db->getLastInsertId();
	}


	function fieldInsertion($category_id)
	{

		$Fileds =  new   CategoryFieldList;
		$attributes2 = array('price', 'area', 'bathrooms', 'bedrooms');
		foreach ($attributes2 as $field) {
			$Fileds->isNewRecord = true;
			$Fileds->field_name = $field;
			$Fileds->category_id = $category_id;
			$Fileds->save();
		}
	}
	function subcategory_insert($category_id, $unitType, $SectionID)
	{
		$sub_category_model = new Subcategory;
		$subcategory = CHtml::listData(Subcategory::model()->ListDataForCategory($category_id), 'sub_category_id', 'sub_category_name');
		if (!$this->in_arrayi($unitType, $subcategory)) {
			$sub_category_model->isNewRecord    = true;
			$sub_category_model->section_id     = $SectionID;
			$sub_category_model->sub_category_id     = "";
			$sub_category_model->category_id     = $category_id;
			$sub_category_model->sub_category_name  = $unitType;
			$sub_category_model->amenities_required  = 'Y';
			$sub_category_model->xml_inserted  = '1';
			$sub_category_model->slug = $sub_category_model->getUniqueSlug();
			$sub_category_model->save();
			return  Yii::app()->db->getLastInsertId();
		} else {
			return  array_search(strtolower($unitType), array_map('strtolower', $subcategory));
		}
	}
	function country_insert($con, $v1)
	{
		$country = new Countries;
		if (!$this->in_arrayi($v1, $con)) {
			$country->country_name = $v1;
			$country->country_code = 'XXX';
			$country->location_longitude = '1';
			$country->location_latitude = '1';
			$country->save();
			return  Yii::app()->db->getLastInsertId();
		} else {

			return  array_search(strtolower($v1), array_map('strtolower', $con));
		}
	}
	function state_insert($con, $v1, $country_id)
	{
		$state = new States;
		if (!$this->in_arrayi($v1, $con)) {
			$state->state_name = $v1;
			$state->country_id = $v1;
			$state->location_longitude = '1';
			$state->location_latitude = '1';
			$state->save();
			return  Yii::app()->db->getLastInsertId();
		} else {

			return  array_search(strtolower($v1), array_map('strtolower', $con));
		}
	}
	function in_arrayi($needle, $haystack)
	{

		return in_array(strtolower($needle), array_map('strtolower', $haystack));
	}
	function insertUser($user_email, $user_phone, $user_name, $user_image)
	{

		$model = new ListingUsers();
		$img_user = "";
		/*
			if (@GetImageSize($user_image)) {



			$path =  Yii::app()->basePath . '/../../uploads' ;
			$img_user = 'usr'.rand(0,9999).'_'.time().".jpg";
			$content = file_get_contents($path);
			file_put_contents($path."/avatar/{$img_user}", $content);
			}
			* */

		$model->email = $user_email;
		$model->phone = $user_phone;
		$serexplode = explode(' ', $user_name);
		$model->first_name = @$serexplode['0'];
		$model->last_name = @$serexplode['1'];
		$password = '123456';
		$model->image = $img_user;
		$model->con_password =  $password;
		$model->password = $password;
		$model->status = 'A';
		$model->xml_inserted = '1';
		$model->xml_image = $user_image;
		$model->save();
		return  Yii::app()->db->getLastInsertId();
	}
	function imageinsert($imagearray, $ad_id, $delete = 0)
	{

		$room_image = new AdImage;
		if ($delete == 1) {
			$room_image->deleteAll(array("condition" => "ad_id=:ad_id", "params" => array(":ad_id" => $ad_id)));
		}

		if (!empty($imagearray)) {
			foreach ($imagearray as  $photo) {

				$img = "";

				if (@GetImageSize($photo)) {

					$path =  Yii::app()->basePath . '/../../uploads';
					$img = rand(0, 9999) . '_' . time() . ".jpg";
					$content = file_get_contents($photo);
					file_put_contents($path . "/ads/{$img}", $content);
				}


				$room_image->isNewRecord = true;
				$room_image->id = "";
				$room_image->ad_id = $ad_id;
				$room_image->image_name = $img;
				$room_image->xml_image = $photo;
				$room_image->status = "A";
				$room_image->save();
			}
		}
	}
	function adsMessage($totalcount, $totalinsertcount, $totalupdatecount, $fetched, $section = "")
	{
		echo "Dear Admin ,<br />";
		$remaining = $totalcount - ($fetched + $totalinsertcount + $totalupdatecount);
		$remainin_msg = "";
		if ((int)$remaining > 0) {
			$remainin_msg = " and remaining <b>{$remaining} </b> Ads to fetch";
		}
		echo "Total Ads {$totalcount} found and {$totalinsertcount} inserted and {$totalupdatecount} updated on section {$section}" . $remainin_msg;
		exit;
	}
	function renderImage($image = "", $xml = "P", $image_name = "")
	{


		$image = Yii::app()->basePath . '/../../uploads/ads/' . $image_name;
		if (is_file($image)) {

			return Yii::app()->apps->getBaseUrl('uploads/ads/' . $image_name);
		} else {
			return   Yii::app()->theme->baseUrl . '/images/ucnoimage.jpg';
		}


		if ($xml == "N") {

			$image = Yii::app()->basePath . '/../../uploads/ads/' . $image_name;
			if (is_file($image)) {

				return Yii::app()->apps->getBaseUrl('uploads/ads/' . $image_name);
			} else {
				return   Yii::app()->theme->baseUrl . '/images/ucnoimage.jpg';
			}
		}
		if (@GetImageSize($image)) {
			return   $image;
		} else {

			return   Yii::app()->theme->baseUrl . '/images/ucnoimage.jpg';
		}
	}
	function renderImageNew($image_name = "")
	{


		$image = Yii::app()->basePath . '/../../uploads/ads/' . $image_name;
		if (is_file($image)) {

			return Yii::app()->apps->getBaseUrl('uploads/ads/' . $image_name);
		} else {
			return   Yii::app()->theme->baseUrl . '/images/ucnoimage.jpg';
		}
	}


	function currencyAbreviation($currency = "")
	{
		return ($currency == "") ? Yii::app()->options->get('system.common.defalut_currency') : $currency;
	}
	function getPriceWithCurrncy()
	{
		return  Yii::app()->options->get('system.common.defalut_currency') . ' ' .  number_format($this->price, 0, '.', ',');
	}
	public function getCurrencyTitle()
	{
		return 'AED';
	}
	function getPriceOnly()
	{
		return    number_format($this->price, 0, '.', ',');
	}
	function getBuiltUpArea()
	{
		if (!empty($this->builtup_area_sqft)) {
			return     number_format($this->builtup_area_sqft, 0, '.', ',') . ' Sq.Ft.';
		}
	}
	function getPltAreaArea()
	{
		if (!empty($this->plot_size)) {
			return     number_format($this->plot_size, 0, '.', ',') . ' Sq.Ft.';
		}
	}
	function getSystemRefNo()
	{
		if (!empty($this->RefNo)) {
			return $this->RefNo;
		} else {
			return 'K' . str_pad($this->id, 5, 0, STR_PAD_LEFT);
		}
		return     number_format($this->builtup_area_sqft, 0, '.', ',') . ' Sq.Ft.';
	}
	function getPriceDetail()
	{
		$htmlTag =   $this->priceOnly;

		return $htmlTag;
	}
	function getRentalPeriod()
	{
		if ($this->section_id == self::RENT_ID) {
			return  '/' . $this->rentPaid2;
		}
	}
	function getPriceHtml()
	{
		$htmlTag =  '<div class="Price_span"> ' . $this->priceWithCurrncy;
		if ($this->section_id == self::RENT_ID) {
			$htmlTag .= '<br><span class="rentpermonth" style="font-size:12px">(rent per  ' . $this->rentPaid2 . ')</span>';
		}
		$htmlTag .= ' </div> ';
		return $htmlTag;
	}
	function getPriceHtmlN()
	{
		$htmlTag =  '<div class="Price_span"> ' . $this->priceWithCurrncy;
		if ($this->section_id == self::RENT_ID) {
			$htmlTag .= '<span class="rentpermonth" style="font-size:12px;margin-left:5px;">(rent per  ' . $this->rentPaid2 . ')</span>';
		}
		$htmlTag .= ' </div> ';
		return $htmlTag;
	}
	function getDetailsPriceHtml()
	{

		$htmlTag = '<span class="unit-price-div">' . Yii::app()->options->get('system.common.defalut_currency') . ' <span class="price-text">' . number_format($this->price, 0, '.', ',') . '</span>';
		if ($this->section_id == self::RENT_ID) {
			$htmlTag .= '<span class="rentpermonth">(rent per  ' . $this->rentPaid2 . ')</span>';
		}
		$htmlTag .= '</span>';

		return $htmlTag;
	}

	public function rental_periodArray()
	{
		return array(
			'Y' => 'Yearly',
			'M' => 'Monthly',
			'W' => 'Weekly',
			'D' => 'Daily'
		);
	}
	function getRentPaid()
	{
		if (empty($this->rental_period)) {
			$this->rental_period = 'yearly';
		}
		return  ' / ' . $this->rental_period;
	}
	function getRentPaid2()
	{
		if (empty($this->rental_period)) {
			$this->rental_period = 'yearly';
		}
		$ar = $this->rental_periodArray();
		return isset($ar[$this->rental_period]) ? $ar[$this->rental_period] : '';
	}
	function getLocationString()
	{
		if (!empty($this->district)) {
			return 	$this->district0->district_name;
		} else {
			return 	$this->state0->state_name;
		}
	}
	function getReadyString2()
	{
		if (!empty($this->occupant_status) and $this->occupant_status == 'Vacant') {
			return '<div class="readynow-div2"> <span>Ready Now</span> </div>';
		}
	}
	function getReadyString()
	{
		if (!empty($this->occupant_status) and $this->occupant_status == 'Vacant') {
			return '<div class="readynow-div"> <span>Ready Now</span> </div>';
		}
	}
	function getPropertyDatilUrl()
	{
		return   Yii::app()->createUrl($this->slug . '/detailView');
	}
	public $ad_image;
	function getPropertyAbsoluteDatilUrl()
	{
		return Yii::app()->createAbsoluteUrl('details/index/section/' . $this->section_id, array('slug' => $this->slug));
		//return   Yii::app()->createAbsoluteUrl($this->slug.'/detailView'); 

	}
	public function getShortDescription($length = 130)
	{
		return StringHelper::truncateLength($this->ad_description, (int)$length);
	}
	function getBuiltupAreaString()
	{
		if (!empty($this->builtup_area)) {
			return 	$this->builtup_area .  ' sq.ft.';
		}
	}
	function getBuiltupAreaString2()
	{
		if (!empty($this->builtup_area)) {
			return 	(int)$this->builtup_area .  ' sq.ft.';
		}
	}


	public function sortArray()
	{
		return array(
			'' => 'Featured',
			'N' => 'Newest',
			'L' => 'Lowest',
			'H' => 'Highest',
		);
	}

	function getLocalBedString()
	{
		$htmlTag = '';
		if (!empty($this->bedrooms)) {
			$htmlTag .= '<span style="float:left;">' . (int) $this->bedrooms . '</span><span title="' . (int) $this->bedrooms . ' Bedroom(s)" class="unitbeds"></span>';
		}
		if (!empty($this->bathrooms)) {
			$htmlTag .= '<span style="float:left;">' . (int) $this->bathrooms . '</span><span title="' . (int) $this->bathrooms . ' Bathroom(s)" class="unitbaths"></span>';
		}
		if (!empty($this->parking)) {
			$htmlTag .= '<span style="float:left;">' . (int) $this->parking  . '</span><span title="' . (int) $this->parking . ' Car Parking(s)" class="unitparkng"></span>';
		}
		return $htmlTag;
	}
	function FomatMoney($money = "0")
	{
		return  number_format($money, 0, '.', ',');
	}
	function priceArray()
	{
		return array(
			10000 => '10000 ' . Yii::app()->options->get('system.common.defalut_currency'),
			50000 => '50000 ' . Yii::app()->options->get('system.common.defalut_currency'),
			100000 => '100000 ' . Yii::app()->options->get('system.common.defalut_currency'),
			200000 => '200000 ' . Yii::app()->options->get('system.common.defalut_currency'),
			300000 => '300000 ' . Yii::app()->options->get('system.common.defalut_currency'),
			400000 => '400000 ' . Yii::app()->options->get('system.common.defalut_currency'),
			500000 => '500000 ' . Yii::app()->options->get('system.common.defalut_currency'),
			1000000 => '1000000 ' . Yii::app()->options->get('system.common.defalut_currency'),
		);
	}
	function getMinPriceHtml()
	{
		$minPrice = Yii::app()->request->getQuery("minprice");
		$currency = Yii::app()->options->get('system.common.defalut_currency');
?>
		<option value="">Min Price</option>
		<option value="10000" <?php echo ($minPrice == "10000") ? "selected=true" : ""; ?>><?php echo $currency; ?> <?php echo number_format('10000.00', 2, '.', ','); ?></option>
		<option value="50000" <?php echo ($minPrice == "50000") ? "selected=true" : ""; ?>><?php echo $currency; ?> <?php echo number_format('50000.00', 2, '.', ','); ?></option>
		<option value="100000" <?php echo ($minPrice == "100000") ? "selected=true" : ""; ?>><?php echo $currency; ?> <?php echo number_format('100000.00', 2, '.', ','); ?></option>
		<option value="200000" <?php echo ($minPrice == "200000") ? "selected=true" : ""; ?>><?php echo $currency; ?> <?php echo number_format('200000.00', 2, '.', ','); ?></option>
		<option value="300000" <?php echo ($minPrice == "300000") ? "selected=true" : ""; ?>><?php echo $currency; ?> <?php echo number_format('300000.00', 2, '.', ','); ?></option>
		<option value="400000" <?php echo ($minPrice == "400000") ? "selected=true" : ""; ?>><?php echo $currency; ?> <?php echo number_format('400000.00', 2, '.', ','); ?></option>
		<option value="500000" <?php echo ($minPrice == "500000") ? "selected=true" : ""; ?>><?php echo $currency; ?> <?php echo  number_format('500000.00', 2, '.', ','); ?></option>
		<option value="1000000" <?php echo ($minPrice == "1000000") ? "selected=true" : ""; ?>><?php echo $currency; ?> <?php echo number_format('1000000.00', 2, '.', ','); ?></option>

	<?
	}
	function getMaxPriceHtml()
	{
		$maxprice = Yii::app()->request->getQuery("maxprice");
		$currency = Yii::app()->options->get('system.common.defalut_currency');

	?>
		<option value="">Max Price</option>
		<option value="10000" <?php echo ($maxprice == "10000") ? "selected=true" : ""; ?>><?php echo Yii::app()->options->get('system.common.defalut_currency'); ?> <?php echo number_format('10000.00', 2, '.', ','); ?></option>
		<option value="50000" <?php echo ($maxprice == "50000") ? "selected=true" : ""; ?>><?php echo Yii::app()->options->get('system.common.defalut_currency'); ?> <?php echo number_format('50000.00', 2, '.', ','); ?></option>
		<option value="100000" <?php echo ($maxprice == "100000") ? "selected=true" : ""; ?>><?php echo Yii::app()->options->get('system.common.defalut_currency'); ?> <?php echo number_format('100000.00', 2, '.', ','); ?></option>
		<option value="200000" <?php echo ($maxprice == "200000") ? "selected=true" : ""; ?>><?php echo Yii::app()->options->get('system.common.defalut_currency'); ?> <?php echo number_format('200000.00', 2, '.', ','); ?></option>
		<option value="300000" <?php echo ($maxprice == "300000") ? "selected=true" : ""; ?>><?php echo Yii::app()->options->get('system.common.defalut_currency'); ?> <?php echo number_format('300000.00', 2, '.', ','); ?></option>
		<option value="400000" <?php echo ($maxprice == "400000") ? "selected=true" : ""; ?>><?php echo Yii::app()->options->get('system.common.defalut_currency'); ?> <?php echo number_format('400000.00', 2, '.', ','); ?></option>
		<option value="500000" <?php echo ($maxprice == "500000") ? "selected=true" : ""; ?>><?php echo Yii::app()->options->get('system.common.defalut_currency'); ?> <?php echo  number_format('500000.00', 2, '.', ','); ?></option>
		<option value="1000000" <?php echo ($maxprice == "1000000") ? "selected=true" : ""; ?>><?php echo Yii::app()->options->get('system.common.defalut_currency'); ?> <?php echo number_format('1000000.00', 2, '.', ','); ?></option>

	<?
	}
	function getBedroomHtml()
	{
		$bed = Yii::app()->request->getQuery("minbeds");
	?>
		<option value="">Min Beds</option>
		<option value="1" <?php echo ($bed == "1") ? "selected=true" : ""; ?>>1 Bedrooms</option>
		<option value="2" <?php echo ($bed == "2") ? "selected=true" : ""; ?>>2 Bedrooms</option>
		<option value="3" <?php echo ($bed == "3") ? "selected=true" : ""; ?>>3 Bedrooms</option>
		<option value="4" <?php echo ($bed == "4") ? "selected=true" : ""; ?>>4 Bedrooms</option>
		<option value="5" <?php echo ($bed == "5") ? "selected=true" : ""; ?>>5 Bedrooms</option>
		<option value="6" <?php echo ($bed == "6") ? "selected=true" : ""; ?>>6 Bedrooms</option>
		<option value="7" <?php echo ($bed == "7") ? "selected=true" : ""; ?>>7 Bedrooms</option>
		<option value="8" <?php echo ($bed == "8") ? "selected=true" : ""; ?>>8 Bedrooms</option>
		<option value="9" <?php echo ($bed == "9") ? "selected=true" : ""; ?>>9 Bedrooms</option>
		<option value="10" <?php echo ($bed == "10") ? "selected=true" : ""; ?>>10 Bedrooms</option>
		<option value="11" <?php echo ($bed == "bedroom-equal-and-more") ? "selected=true" : ""; ?>>10+ Bedrooms</option>

	<?
	}
	function getMaxBedroomHtml()
	{
		$bed = Yii::app()->request->getQuery("maxbeds");
	?>
		<option value="">Bedrooms</option>
		<option value="1" <?php echo ($bed == "1") ? "selected=true" : ""; ?>>1 Bedrooms</option>
		<option value="2" <?php echo ($bed == "2") ? "selected=true" : ""; ?>>2 Bedrooms</option>
		<option value="3" <?php echo ($bed == "3") ? "selected=true" : ""; ?>>3 Bedrooms</option>
		<option value="4" <?php echo ($bed == "4") ? "selected=true" : ""; ?>>4 Bedrooms</option>
		<option value="5" <?php echo ($bed == "5") ? "selected=true" : ""; ?>>5 Bedrooms</option>
		<option value="6" <?php echo ($bed == "6") ? "selected=true" : ""; ?>>6 Bedrooms</option>
		<option value="7" <?php echo ($bed == "7") ? "selected=true" : ""; ?>>7 Bedrooms</option>
		<option value="8" <?php echo ($bed == "8") ? "selected=true" : ""; ?>>8 Bedrooms</option>
		<option value="9" <?php echo ($bed == "9") ? "selected=true" : ""; ?>>9 Bedrooms</option>
		<option value="10" <?php echo ($bed == "10") ? "selected=true" : ""; ?>>10 Bedrooms</option>
		<option value="bedroom-equal-and-more" <?php echo ($bed == "bedroom-equal-and-more") ? "selected=true" : ""; ?>>10+ Bedrooms</option>

	<?
	}
	function getMBathroomHtml()
	{
	?>
		<option value="">Bathrooms</option>
		<option value="1" <?php echo (Yii::app()->request->getQuery("bathrooms") == "1") ? "selected=true" : ""; ?>>1 Bathrooms</option>
		<option value="2" <?php echo (Yii::app()->request->getQuery("bathrooms") == "2") ? "selected=true" : ""; ?>>2 Bathrooms</option>
		<option value="3" <?php echo (Yii::app()->request->getQuery("bathrooms") == "3") ? "selected=true" : ""; ?>>3 Bathrooms</option>
		<option value="4" <?php echo (Yii::app()->request->getQuery("bathrooms") == "4") ? "selected=true" : ""; ?>>4 Bathrooms</option>
		<option value="5" <?php echo (Yii::app()->request->getQuery("bathrooms") == "5") ? "selected=true" : ""; ?>>5 Bathrooms</option>
		<option value="6" <?php echo (Yii::app()->request->getQuery("bathrooms") == "6") ? "selected=true" : ""; ?>>6 Bathrooms</option>
		<option value="7" <?php echo (Yii::app()->request->getQuery("bathrooms") == "7") ? "selected=true" : ""; ?>>7 Bathrooms</option>
		<option value="8" <?php echo (Yii::app()->request->getQuery("bathrooms") == "8") ? "selected=true" : ""; ?>>8 Bathrooms</option>
		<option value="9" <?php echo (Yii::app()->request->getQuery("bathrooms") == "9") ? "selected=true" : ""; ?>>9 Bathrooms </option>
		<option value="10" <?php echo (Yii::app()->request->getQuery("bathrooms") == "10") ? "selected=true" : ""; ?>>10 Bathrooms</option>
		<option value="bathroom-equal-and-more" <?php echo (Yii::app()->request->getQuery("bathrooms") == "bathroom-equal-and-more") ? "selected=true" : ""; ?>>10+ Bathrooms</option>

<?
	}
	public function getShortName($length = 20)
	{
		return StringHelper::truncateLength($this->ad_title, (int)$length);
	}
	public function getfeaturedT()
	{
		if ($this->featured == 'Y') {
			return '<i class="glyphicon    glyphicon-star   text-green"></i>';
		}
	}
	const BULK_ACTION_TRASH = 'trash';
	const BULK_ACTION_DOWNLOAD = 'download';
	const BULK_ACTION_DELETE = 'delete';
	const BULK_ACTION_RESTORE = 'restore';
	const BULK_ACTION_EXPIRED = 'expired';
	const BULK_ACTION_SENDNOTIFICATIOB = 'send-notification';
	public function getBulkActionsList()
	{
		$ar =
			array(
				self::BULK_ACTION_DELETE         => Yii::t('app', 'Delete Permanently '),

			);

		if (Yii::app()->controller->action->id == 'trash') {
			$ar[self::BULK_ACTION_RESTORE] =  Yii::t('app', 'Restore');
		} else {
			$ar[self::BULK_ACTION_TRASH] =  Yii::t('app', 'Move To Trash');
		}
		return $ar;
	}
	public function getPublishList()
	{
			 $ar['A'] =  Yii::t('app', 'Publish');
			 $ar['I'] =  Yii::t('app', 'Unpublish');
		 
		return $ar;
	}
	public function getSaveFave()
	{
		if (!empty($this->fav)) {
			return '<a href="#" data-property-id="' . $this->id . '" class="btn-wishlist open"><i class="fa fa-heart"></i></a>';
		} else {
			return '<a href="#" data-property-id="' . $this->id . '" class="btn-wishlist"><i class="fa fa-heart"></i></a>';
		}
	}
	public function constructionArray()
	{

		return array('R' => 'Ready', 'N' => 'Off-Plan');
	}
	public function thumbnailImage()
	{
		return array(
			'jpg',
			'jpeg',
			'png',
		);
	}
	public function generateFormat()
	{
		$merged_array =  $this->thumbnailImage();
		$str = '';
		foreach ($merged_array as $format) {
			$str .= '.' . $format . ',';
		}
		return rtrim($str, ',');
	}
	public $floor_plan;
	public $payment_plan;
	public $pro_type_images;
	public $channel;
	public $faq;
	public function statusArray()
	{
		return array("A" => "Active", "I" => "Inactive", "W" => "Waiting", 'R' => 'Rejected');
	}
	public function detailList() {}
	public function getPriceTitleSpan($code = '')
	{

		$code = 'AED';
		$html =  '<span class="pri sec_' . $this->section_id . '">' . number_format($this->price, 0, '.', ',') . '</span> ' . $code;

		return $html;
	}
	public function getPreviewUrlTrash()
	{
		return $this->PreviewUrlNew . '?showTrash=1';
		if ($this->section_id == '3') {
			return $this->PreviewUrlNew . '?showTrash=1';
			return Yii::app()->apps->getAppUrl('frontend', 'project/' . $this->slug . '?showTrash=1', true);
		}
		return  Yii::app()->apps->getAppUrl('frontend', 'property/' . $this->slug . '?showTrash=1', true);
	}
	public function all_amentitie_from_array($from_array)
	{
		$criteria = new CDbCriteria;
		$criteria->select = 't.amenities_id,t.amenities_name';
		$criteria->addInCondition('t.amenities_id', $from_array);
		$criteria->order = ' amenities_name asc';
		return Amenities::model()->findAll($criteria);
	}
	public function formatnuber($num)
	{
		return Yii::t('app', $num, array(',' => ''));
	}
	public function getSmallDate()
	{
		return date('d m,Y', strtotime($this->date_added));
	}
	public function getAdTitleWithIcons()
	{
		$html =  $this->ad_title;
		if ($this->featured == "Y") {
			$html .=  '<i title="FEATURED" class="glyphicon glyphicon-star"></i>';
		}
		if ($this->status == "I") {
			$html .=  '<i title="DISABLED" class="glyphicon glyphicon-ban-circle"></i>';
		}
		return  $html;
	}
	public function getStatusTitle()
	{

		switch ($this->status) {
			case 'A':
				return  'Published';
				break;
			case 'W':
				return  'Waiting Approval';
				break;
			case 'I':
				return  'Inactive';
				break;
			case 'R':
				return  'Rejected';
				break;
			case 'D':
				return 'Draft';
				break;
		}
	}
	public function getStatusLinkFront()
	{
		$title = $this->StatusTitle;
		switch ($this->status) {
			case 'A':
				return '<span class="btn btn-xs  btn-success" title="' . $title . '">' . $title . '</span>';
				break;
			case 'W':
				return '<span class="btn btn-xs btn-teal"   title="' . $title . '">' . $title . '</span>';
				break;
			case 'I':
				return '<span class="btn btn-xs btn-warning"   title="' . $title . '">' . $title . '</span>';
				break;
			case 'R':
				return '<span class="btn btn-xs  btn-danger" title="' . $title . '">' . $title . '</span>';
				break;
			case 'D':
				return '<span class="btn btn-xs  btn-danger" title="' . $title . '">' . $title . '</span>';
				break;
		}
	}
	public function getAtttributePropertyDetails()
	{
		$type_is     =    $this->all_property_types_details();
		$type_is_c   =    $this->all_property_types_detailsgroup();
		$overViewhtm  = '';
		$proprty_type_title = '';
		$bed_title =  'Beds';
		$size_title = 'Size';
		if (!empty($type_is_c)) {
			foreach ($type_is_c as $k => $v) {
				if ($k != '0') {
					continue;
				}
				$c = $v->type_id_c > 1 ? '1' : '';
				$overViewhtm .= ' <li>' . $v->type->categoryIdLanItSelf($c) . '</li>';
				if (!empty($v->bed)) {
					if (!empty(rtrim($v->bed_c, ','))) {
						if ($v->bed == '14') {
							$tit = '13+';
						} else {
							$tit = !empty($v->bed_c) ? rtrim($v->bed_c, ',') : '';
						}

						$overViewhtm .= '<li><label> ' . $bed_title . '</label> ' . ltrim($tit, ',') . ' </li>';
					}
				} else if (!empty($v->size) and $v->size != '0.00') {
					$overViewhtm .= '<li><label> ' . $size_title . '</label> ' . number_format(Yii::t('app', $v->size, array('.00' => '')), 0, '.', ',') . ' Sq.Ft.</li>';
				}
			}
		}
		return $overViewhtm;
	}
	public function all_property_types_details()
	{
		$criteria = new CDbCriteria;
		$criteria->condition = '(case when t.type_id = "135" then "" when t.type_id = "121" then "" else t.bed end ) as bed,t.type_id,bath,title,from_price,to_price,size,size_to,area_unit,price_unit';
		$criteria->condition = 't.ad_id = :ad   ';
		$criteria->params[':ad'] = $this->id;
		$criteria->order = ' t.id asc';
		return AdPropertyTypes::model()->findAll($criteria);
	}
	public function all_property_types_detailsgroup()
	{
		$criteria = new CDbCriteria;
		$criteria->select = 't.*,count(type_id) as  type_id_c,group_concat(DISTINCT (case when t.type_id = "135" then "" when t.type_id = "121" then "" when t.bed = "0" then "" else t.bed end )) as bed_c';
		$criteria->condition = 't.ad_id = :ad   ';
		$criteria->params[':ad'] = $this->id;
		$criteria->order = ' t.id asc';
		$criteria->group = 't.type_id';
		return AdPropertyTypes::model()->findAll($criteria);
	}
	public $developer_name;
	public $developer_logo;
	public function getDeveloperName()
	{
		if(!empty($this->developer_id)){
			$dev = Developers::model()->findByPK($this->developer_id);
			if(!empty($dev)){
				return $dev->developer_name;
			}
		}
		return $this->developer_name;
	}

	public function getBgImage()
	{
		if (!empty($this->d_logo)) {
			return   Yii::app()->apps->getBaseUrl('uploads/ads/' . $this->d_logo);
		} 
	}
	public function getPriceTitleDetail()
	{
		
		if ($this->p_o_r == '1') {
			return 'Ask for Price';
		}
		if ($this->price == '0.00') {
			return 'Ask for Price';
		}
		 
		$html = '<span data-id="' . $this->price . '">AED</span> ' . number_format($this->price, 0, '.', ',');

		return $html;
	}
	public function all_images()
	{
		$criteria = new CDbCriteria;
		$criteria->select = 't.image_name,t.id';
		$criteria->condition = 't.status="A" and isTrash="0" and  t.ad_id = :ad   ';
		$criteria->params[':ad'] = $this->id;
		$criteria->order = '-t.priority desc,id asc';
		return AdImage::model()->findAll($criteria);
	}
	public $first_name;
	public $last_name;
	public $state_slug;
	public function detailList2()
	{
		return  array(
			'reference' 	 =>     $this->SystemRefNo,
			'builtup_area' 	 =>    $this->BuiltUpArea,

			'mandate'		   =>   $this->mandate,
			'community_id'	   =>  $this->community_name,
			'sub_community_id' =>   $this->sub_community_name,

			'status'		   =>  $this->StatusTitle,
		);
	}
	public function all_amentitie()
	{
		$criteria = new CDbCriteria;
		$criteria->select = 't.amenities_id';
		$criteria->condition = 'am.status="A" and am.isTrash="0" and t.ad_id = :ad   ';
		$criteria->join = ' INNER JOIN {{amenities}} am on am.amenities_id = t.amenities_id ';
		$criteria->params[':ad'] = $this->id;

		$criteria->select .= ' ,am.amenities_name,am.icon_list';

		$criteria->order = ' amenities_name asc';
		return AdAmenities::model()->findAll($criteria);
	}
	public function getsection_name()
	{
		switch ($this->section_id) {
			case '1':
				return 'Sale';
				break;
			case '2':
				return 'Rent';
				break;
			case '3':
				return 'Off-Plan';
				break;
		}
	}
	public function getPriceTitle($code = '')
	{

		$code =  'AED';
		$html =  $code . number_format($this->price, 0, '.', ',');

		return $html;
	}
	public function getReferenceNumberTitle()
	{
		return $this->SystemRefNo;
	}
	public function all_bed_detailsTitle()
	{
		$criteria = new CDbCriteria;
		$criteria->select = 't.bed';
		$criteria->distinct = 't.bed';
		$criteria->condition = 't.ad_id = :ad and t.bed > 0  ';
		$criteria->params[':ad'] = $this->id;
		$criteria->order = ' t.id asc';
		$data =  AdPropertyTypes::model()->findAll($criteria);
		$html = '';
		if ($data) {
			foreach ($data as $k => $v) {
				$html[] = $v->bed;
			}
		}
		return $html;
	}
	public function getConstructionTitle()
	{
		$ar = $this->constructionArray();
		return isset($ar[$this->construction_status]) ?  $ar[$this->construction_status] : '';
	}
	public function getAdDescription()
	{

		return $this->ad_description;
	}
	public function getAdTitleWithTags2()
	{
		$found = false;
		$html = '';
		$html =  ' <span class="label  bg-green ';
		$html .= $this->featured == "Y" ? '' : 'dis';
		$html .= '" data-fun="F" data-id="' . $this->id . '" title="Featured" onclick="updateTag(this,event)" href="#">Featured</span>';

		// $html .=  ' <span class="label  bg-red '; $html .=  ($this->recmnded=="1")? '' : 'dis';  $html .= '"  data-fun="R" data-id="'.$this->id.'"  title="Recommanded" onclick="updateTag(this,event)" href="#">Featured</span>';
		$html .=  ' <span class="label  bg-aqua ';
		$html .= ($this->is_new == "1") ? '' : 'dis';
		$html .= '"  data-fun="N" data-id="' . $this->id . '" title="New" onclick="updateTag(this,event)" href="#">Exclusive</span>';
		if ($this->status == "I") {
			$html .=  '<i title="DISABLED" class="glyphicon glyphicon-ban-circle"></i>';
		}
		return  $html;
	}
	public $ref_id;
	public $s_r;
	public $order_by;
	public function getshowDateAddedField()
	{
		return $this->order_by != 'last_updated' ? true : false;
	}
	public function getshowUpdatedField()
	{
		return $this->order_by == 'last_updated' ? true : false;
	}
	public function getLitleWithTag2()
	{
		return CHtml::Link(@$this->ad_title, Yii::app()->createUrl("offplan/update", array("id" => $this->id)), array('class' => 'oneline', 'title' => $this->ad_title)) . $this->AdTitleWithTags2 . '';;
	}
	public function getPreviewUrlNew()
	{

		$criteria = new CDbCriteria;
		$criteria->select = 't.*,  st.slug as state_slug,cm.slug as community_slug  , (SELECT image_name FROM {{ad_image}} img  WHERE  img.ad_id = t.id and  img.status="A" and  img.isTrash="0" limit 1 )   as ad_image';
		$criteria->condition = '1';
		$criteria->join  .= ' left join {{community}} cm ON cm.community_id = t.community_id ';
		$criteria->join  .= ' left join {{states}} st ON st.state_id = t.state ';
		$criteria->select .= ',st.state_name as state_name,ad_title as    ad_title2  ';
		$criteria->condition .= ' and t.id=:slug ';
		$criteria->params[':slug'] = $this->primaryKey;
		$model2 = PlaceAnAd::model()->find($criteria);
		return Yii::t('app', ABS_URL . $model2->DetailUrl, array('backend/index.php/' => ''));
	}
	public function getRedirectPathBrochure()
	{
		$bro_file = '';
		if (!empty($this->b_url)) {
			$bro_file = $this->b_url;
		} else if (!empty($this->broucher)) {
			$bro_file = Yii::app()->createAbsoluteUrl('site/view_file', array('file' => base64_encode($this->broucher)));
		}
		if (!empty($bro_file)) {
			return $bro_file;
		}
	}
	public function getopenBrouchre()
	{
		$bro_file = '';
		if (!empty($this->b_url)) {
			$bro_file = $this->b_url;
		} else if (!empty($this->broucher)) {
			$bro_file = Yii::app()->createAbsoluteUrl('site/view_file', array('file' => base64_encode($this->broucher)));
		}

		if (!empty($bro_file)) {
			echo '<script>window.location.href ="' . $bro_file . '";</script>';
			exit;
		} else {
			throw new CHttpException(404, Yii::t('app', 'The requested bochure does not exist.'));
		}
	}
	public function getTour_3dlink()
	{
		if (!empty($this->v_link)) {
			return CHtml::link('<svg viewBox="0 0 15 15" class="button_icon-style3"><use xlink:href="#viewd-3d"></use></svg> <span>3D Tour</span>', 'javascript:void(0)', array('onclick' => "open3dVideo(this)", 'data-url' => $this->v_link, 'class' => "tour-link"));
		}
	}
	public function getinactiveVisibility()
	{
		return  $this->status == "A" ? true : false;
	}
	public function getactiveVisibility()
	{
		return  $this->status == "I" ? true : false;
	}
	public function getOffplanImage1()
	{
		return $this->bg_img;
	}
	public function getPriceTitleDetailT()
	{
		if ($this->p_o_r == '1') {
			return 'Ask for Price';
		}
		if ($this->price == '0.00') {
			return 'Ask for Price';
		}
		$html = 'AED <span>' . number_format($this->price, 0, '.', ',') . '</span>';

		return $html;
	}
	public function getSimilarProperties($limit = 10)
	{
		$order = '';
		if (!empty($this->developer_id)) {
			$order .= ' t.developer_id="' . $this->city . '" desc,   ';
		}
		if (!empty($this->sub_community_id)) {
			$order .= '   t.sub_community_id = "' . $this->sub_community_id . '" desc  , ';
		}
		$order .= 't.community_id = "' . $this->community_id . '" desc';

		$neighbours = PlaceAnAd::model()->findAds(array('sort' => 'custom', 'custom_order' => $order, '_sec_id' => '3'), false, 1, false, false);
		$neighbours->limit = $limit;
		$neighbours->condition .= '   and t.id != :this ';
		$neighbours->params[':this'] = $this->id;

		$neighbours->join        .=     ' left join {{developers}} dvp ON dvp.developer_id = t.developer_id   ';
		$neighbours->select      .=         ',dvp.developer_name,dvp.logo as developer_logo';
		$neighbours->order  = $order;
		return  $this->findAll($neighbours);
	}
	public function getLatestProhectsFromCache()
	{
		$cacheKey = 'newprojcts' . Yii::app()->options->get('system.common.newprojcts', '12e43234') . $f_type;
		if ($items = Yii::app()->cache->get($cacheKey) and !isset($_GET['refresh'])) {
			return $items;
		}
		$adModel                =    new PlaceAnAd();
		$criteria               =    $adModel->findAds(array('_sec_id' => 3), false, 1);
		$criteria->order        =    ' t.id desc  ';
		$criteria->limit        = 7;
		$criteria->select = 'st.slug as state_slug,cm.slug as community_slug,t.slug,t.ad_title';

		$latest_project =   $adModel->findAll($criteria);
		$items = array();
		if ($latest_project) {
			foreach ($latest_project as $k => $v) {
				$items[] = ['url' => $v->detailUrl, 'title' => $v->ad_title];
			}
		}
		Yii::app()->cache->set($cacheKey, $items, 60 * 60 * 24 * 1);
		return $items;
	}
	public function getsectionTitle1()
	{
		switch ($this->section_id) {
			case '1':
				return 'Sale';
				break;
			case '2':
				return 'Rent';
				break;
			case '3':
				return 'Off-Plan';
				break;
		}
	}
	public function getProjectImage()
	{
		return '<img src="' . Yii::app()->apps->getBaseUrl('uploads/ads/' . $this->bg_img) . '" width="100">';
	}
	public function project_statusList(){
		$criteria = new CDbCriteria;
		$criteria->group = 'project_status';
		$criteria->select = 't.project_status';
		$data = PlaceAnAd::model()->findAll($criteria);
		return CHtml::listData($data, 'project_status', 'project_status'); 
	}
	public function sale_statusList()
	{
		$criteria = new CDbCriteria;
		$criteria->group = 'sale_status';
		$criteria->select = 't.sale_status';
		$data = PlaceAnAd::model()->findAll($criteria);
		return CHtml::listData($data, 'sale_status', 'sale_status');
	}
	public function countryListId()
	{
		$criteria = new CDbCriteria;
		$criteria->group = 'country';
		$criteria->select = 't.country';
		$data = PlaceAnAd::model()->findAll($criteria);
		$country_list =  CHtml::listData($data, 'country', 'country');
		foreach($country_list as $country){
			$countryModel = Countries::model()->findByPk($country);
			$Ar[$country] = $countryModel->country_name; 
		}
		return $Ar; 
	}
}
