<?php

/**
 * This is the model class for table "mw_place_an_ad".
 *
 * The followings are the available columns in table 'mw_place_an_ad':
 * @property integer $id
 * @property integer $section_id
 * @property integer $category_id
 * @property integer $sub_category_id
 * @property string $ad_title
 * @property string $ad_description
 * @property integer $engine_size
 * @property string $killometer
 * @property integer $model
 * @property string $price
 * @property string $year
 * @property integer $city
 * @property integer $neighbourhood
 * @property string $mobile_number
 * @property integer $employment_type
 * @property string $compensation
 * @property integer $education_level
 * @property integer $experience_level
 * @property string $skills
 * @property string $area
 * @property integer $bathrooms
 * @property integer $bedrooms
 * @property integer $user_id
 * @property string $added_date
 * @property string $modified_date
 * @property integer $priority
 * @property string $isTrash
 * @property string $status
 * @property string $slug
 */
class PlaceAnAd extends ActiveRecord
{
	 public $amenities;
	 public $location;
	 public $location_longitude;
	 public $location_latitude;
	 public $values;
	 public $keyword;
	 public $name;
	 public $email;
	 
	 
     const FEATURED_CONDITION = " t.isTrash='0' and featured='Y'  and t.status='A'   "; 
     const LATEST_CONDITION   = " t.isTrash='0'  and t.status='A'  "; 
     const FEATURED_ORDER     = " featured='Y' desc,t.id desc "; 
     const LATEST_ORDER       = " t.id desc"; 
     const SALE_ID      	  = 1; 
     const RENT_ID       	  = 2; 
     const APARTMENT_FOR_SALE = 30; 
     const APARTMENT_FOR_RENT = 36; 
     const WAREHOUSE_ID       = 96; 
     const VILLA_FOR_SALE 	  = 31; 
     const VILLA_FOR_RENT     = 38; 
     const OFFICE_FOR_SALE 	  = 33; 
     const OFFICE_FOR_RENT    = 39; 
     const COMMON_CONDITION   = " t.isTrash='0' and t.status='A'  " ;
     const COMMON_ORDER       = " featured='Y' desc,t.id desc ";
     const BEDROOM_PLUS       = "10";
     const BATHROOM_PLUS      = "3";
     
	 
	 
    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return 'mw_place_an_ad';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
		 $rules1 =  array(); 
		 if($this->dynamic)
		 {
	 
		  $rules1 =  array(  
		  
		    array('ad_title,ad_description,country,state,property_name,PrimaryUnitView,price,image,occupant_status, mobile_number,builtup_area', 'required'),
		    //array('location_latitude','required','message'=>'Please choose location'),
		    array('bedrooms,bathrooms,parking', 'numerical', 'integerOnly'=>true),
		    array('price', 'numerical' ),
		    array('email', 'email'),
		    
		  );
	     }
		 $rules  =  array(
            array('section_id, category_id,user_id', 'required'),
            array('section_id, category_id, sub_category_id, country, state, city, district,   user_id, priority, xml_pk, community_id, sub_community_id,RetUnitCategory', 'numerical', 'integerOnly'=>true),
            array('ad_title, slug, image, area_location, property_name, PrimaryUnitView, SecondaryUnitView, UnitModel, FloorNo, MarketingUsp, Financing_company, bdm_pkg, marketing_option, arabic_title, arabic_description, mandate', 'length', 'max'=>250),
            array(' currency_abr, area_measurement', 'length', 'max'=>10),
            array('price', 'length', 'max'=>14),
            array('price,RentPerMonth,Rent', 'length', 'max'=>14),
            array('mobile_number', 'length', 'max'=>15),
            array('isTrash,  dynamic, dynamicArray, featured, xml_inserted', 'length', 'max'=>1),
            array('location_latitude, location_longitude, salesman_email', 'length', 'max'=>150),
            array('xml_type', 'length', 'max'=>2),
            array('xml_reference', 'length', 'max'=>25),
            array('code, RefNo, builtup_area', 'length', 'max'=>20),
            array('parking', 'length', 'max'=>5),
            array('nearest_metro,nearest_railway', 'safe'),
            array('modified_date, xml_listing_date, xml_update_date, expiry_date,property_overview,LocalAreaAmenitiesDesc,RecommendedProperties,PropertyID,status,rent_paid,name', 'safe'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, section_id, category_id, sub_category_id, ad_title, ad_description, price, country, state, city, district, mobile_number, bathrooms, bedrooms, user_id, added_date, modified_date, priority, isTrash, status,occupant_status, slug, image, dynamic, dynamicArray, location_latitude, location_longitude, featured, area_location, xml_inserted, xml_pk, xml_type, xml_reference, xml_listing_date, xml_update_date, code, RefNo, community_id, sub_community_id, property_name, builtup_area, PrimaryUnitView, SecondaryUnitView, UnitModel, FloorNo, HandoverDate, MarketingUsp, Financing_company, parking, bdm_pkg, salesman_email, expiry_date, marketing_option, arabic_title, arabic_description, mandate, currency_abr, area_measurement, PDFBrochureLink,property_overview,ReraStrNo', 'safe', 'on'=>'search'),
        );
        return array_merge($rules1,$rules);
    }
    
 
  public function dynamicFields()
  {
	   return array(
				//'age' =>'Age',
				'builtup_area' => 'Builtup area',
				'bathrooms' => 'Bathrooms',
				
				//'body_type'=>'Body Ttype',
				//'bodycondition' => 'Body Condition',
				'bedrooms' => 'Bedrooms',
				//'compensation' => 'Compensation',
				//'current_occupation' =>'Current Occupation',
				//'color'=>'Color',
				//'cylinders'=>'Cylinders',
				//'door'=>'Door',
				//'education_level' => 'Education Level',
				//'experience_level' => 'Experience Level',
				//'employment_type' => 'Employment Type',
				//'fuel_type' => 'Fuel Type',price
				//'height'=>'Height',
				//'killometer' => 'Killometer',
				//'marital_status' =>'Marital Status',
				//'mechanicalcondition' => 'Mechanical Condition',
				//'model' => 'Model',
				//'mother_tongue' =>'Mother Tongue',
				'price'=>'Price',
				//'religion_id' =>'Religion',
				//'skills' => 'Skills',
				//'year' => 'Year',
				//'warranty'=>'Warranty',
				'property_name' => 'Property Name',
				'PrimaryUnitView' => 'Primary Unit View',
				'parking' => 'Parking',
				'FloorNo' => 'Floor No',
				'occupant_status' => 'Occupant status',
				'community_id' => 'Community ',
			
           
        );
  }
  
  
  
  
  
  
   public function dynamicFieldsForPropertyForsale()
  {
	   return array(
				'section_id' =>'Section',
				'category_id' => 'Category',
				'sub_category_id' => 'Sub Category',
				'body_type'=>'Body Ttype',
				'bodycondition' => 'Body Condition',
				'bedrooms' => 'Bedrooms',
				'compensation' => 'Compensation',
				'current_occupation' =>'Current Occupation',
				'color'=>'Color',
				'cylinders'=>'Cylinders',
				'door'=>'Door',
				'education_level' => 'Education Level',
				'experience_level' => 'Experience Level',
				'employment_type' => 'Employment Type',
				'fuel_type' => 'Fuel Type',
				'height'=>'Height',
				'killometer' => 'Killometer',
				'marital_status' =>'Marital Status',
				'mechanicalcondition' => 'Mechanical Condition',
				'model' => 'Model',
				'mother_tongue' =>'Mother Tongue',
				'price'=>'Price',
				'religion_id' =>'Religion',
				'skills' => 'Skills',
				'year' => 'Year',
				'warranty'=>'Warranty',
			
			
			
           
        );
  }
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'adAmenities' => array(self::HAS_MANY, 'AdAmenities', 'ad_id'),
            'adImages' => array(self::HAS_MANY, 'AdImage', 'ad_id','on'=>"adImages.isTrash='0'"),
            'adImagesAll' => array(self::HAS_MANY, 'AdImage', 'ad_id'),
             'singleAdImage' => array(self::HAS_ONE, 'AdImage', 'ad_id','on'=>"singleAdImage.isTrash='0' and singleAdImage.status='A'","order"=>"singleAdImage.priority"),
            'adImagesOnView' => array(self::HAS_MANY, 'AdImage', 'ad_id','on'=>"adImagesOnView.isTrash='0' and adImagesOnView.status='A'","order"=>"adImagesOnView.priority"),
            'adImagesOnView2' => array(self::HAS_MANY, 'AdImage', 'ad_id','on'=>"adImagesOnView2.isTrash='0'","order"=>"adImagesOnView2.status ='A' desc,adImagesOnView2.status='A' desc,adImagesOnView2.priority"),
            'adImagesOnView3' => array(self::HAS_MANY, 'AdImage', 'ad_id','condition'=>"adImagesOnView3.isTrash='0' and adImagesOnView3.status='I' "),
             //           'adImagesOnView3' => array(self::HAS_MANY, 'AdImage', 'ad_id','on'=>"adImages.isTrash='0'"),
            'subCategory' => array(self::BELONGS_TO, 'Subcategory', 'sub_category_id'),
            'section' => array(self::BELONGS_TO, 'Section', 'section_id'),
            'ADIMAGE' => array(self::BELONGS_TO, 'Category', 'category_id'),
            'category' => array(self::BELONGS_TO, 'Category', 'category_id'),
            'community' => array(self::BELONGS_TO, 'Community', 'community_id'),
            'subcommunity' => array(self::BELONGS_TO, 'SubCommunity', 'sub_community_id'),
            'stateLocation' => array(self::BELONGS_TO, 'States', 'state'),
            'country0' => array(self::BELONGS_TO, 'Countries', 'country'),
            'state0' => array(self::BELONGS_TO, 'States', 'state'),
            'city0' => array(self::BELONGS_TO, 'City', 'city'),
            'district0' => array(self::BELONGS_TO, 'District', 'district'),
            'Marital' => array(self::BELONGS_TO, 'MaritalStatus', 'marital_status'),
            'Religion' => array(self::BELONGS_TO, 'Religion', 'religion_id'),
            'EngineSize' => array(self::BELONGS_TO, 'EngineSize', 'engine_size'),
            'Model' => array(self::BELONGS_TO, 'VehicleModel', 'model'),
            'EmploymentType' => array(self::BELONGS_TO, 'EmploymentType', 'employment_type'),
            'EducationLevel' => array(self::BELONGS_TO, 'EducationLevel', 'education_level'),
            'Occupation' => array(self::BELONGS_TO, 'Occupation', 'current_occupation'),
            'Experience' => array(self::BELONGS_TO, 'Experience', 'experience_level'),
            'Colors' => array(self::BELONGS_TO, 'Color', 'color'),
            'Customer' => array(self::BELONGS_TO, 'ListingUsers', 'user_id'),
            'Doors' => array(self::BELONGS_TO, 'Door', 'door'),
            'Bodyconditions' => array(self::BELONGS_TO, 'Bodycondition', 'bodycondition'),
            'Mechanicalconditions' => array(self::BELONGS_TO, 'Mechanicalcondition', 'mechanicalcondition'),
            'FuelTypes' => array(self::BELONGS_TO, 'FuelType', 'fuel_type'),
            'BodyTypes' => array(self::BELONGS_TO, 'BodyType', 'body_type'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
		$label1 =  array();
		 if(!empty($this->category->section_id) and $this->category->section_id==self::RENT_ID)
		 {
 
		  $label1 =   
		    array('price'=> 'Rent') ;
		     
	      }
         $label2 =  array(
            'id' => 'ID',
            'section_id' => 'Section',
            'rent_pad' => 'Rent Paid On ',
            'category_id' => 'Category',
            'sub_category_id' => 'Sub Category',
            'ad_title' => 'Ad Title',
            'ad_description' => 'Ad Description',
            'engine_size' => 'Engine Size',
            'killometer' => 'Killometer',
            'model' => 'Model',
          //  'price' => 'Price',
            'year' => 'Year',
            'country' => 'Country',
            'state' => 'State',
            'mobile_number' => 'Mobile Number',
            'employment_type' => 'Employment Type',
            'compensation' => 'Compensation',
            'education_level' => 'Education Level',
            'experience_level' => 'Experience Level',
         //   'skills' => 'Skills',
            'area' => 'Area (sqft)',
            'bathrooms' => 'Bathrooms',
            'bedrooms' => 'Bedrooms',
            'price' => 'Price ['. Yii::app()->options->get('system.common.defalut_currency').']',
            'user_id' => 'Customer',
            'added_date' => 'Added Date',
            'modified_date' => 'Modified Date',
             'age' =>'Age',
            'height'=>'Height',
            'marital_status' =>'Marital Status',
            'religion_id' =>'Religion',
            'mother_tongue' =>'Mother Tongue',
            'current_occupation' =>'Current Occupation',
            'priority' => 'Priority',
            'isTrash' => 'Is Trash',
            'status' => 'Status',
            'slug' => 'Slug',
            'bodycondition' => 'Body Condition',
            'mechanicalcondition' => 'Mechanical Condition',
            'cylinders'=>'Cylinder',
            'area_location' =>'Location',
            	'community_id'=>'Community',
				'sub_community_id'=>'Sub Community',
				'builtup_area_sqft' =>'Builtup Area ( Sq.Ft. )',
				'nearest_metro' =>'Nearest metro stations',
				'nearest_railway' =>'Nearest school',
					'builtup_area'=>'Builtup area in Sq.Ft.',
        );
  
           // return array_replace($label2,$label1);
           return array_merge($label2,$label1);
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.
	 
        $criteria=new CDbCriteria;

        $criteria->compare('id',$this->id);
        $criteria->compare('section_id',$this->section_id);
        $criteria->compare('category_id',$this->category_id);
        $criteria->compare('sub_category_id',$this->sub_category_id);
        $criteria->compare('ad_title',$this->ad_title,true);
        $criteria->compare('featured',$this->featured,true);
        $criteria->compare('isTrash','0',true);
        $criteria->compare('status',$this->status);
        $criteria->order ="id desc";

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
             'pagination'    => array(
                'pageSize'  => $this->paginationOptions->getPageSize(),
                'pageVar'   => 'page',
            ),
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return PlaceAnAd the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }
    public function behaviors(){
    return array_merge(parent::behaviors(),array(
        'SlugBehavior' => array(
            'class' => 'common.models.SlugBehavior.SlugBehavior',
            'slug_col' => 'slug',
            'title_col' => 'ad_title',
            'overwrite' => false
        ))
    );
   }
   public function bathrooms()
   {
	   $ar =array();
	   
	   for($i=0;$i<=11;$i++)
	   {
		    $ar[]=  ($i==11)? '10+' : $i;
	   }
	   return $ar;
   }
   public function bedrooms()
   {
	   $ar =array();
	   
	   for($i=0;$i<=11;$i++)
	   {
		   
		   $ar[]=  ($i==11)? '10+' : $i;
	   }
	   return $ar;
   }
   public function year()
   {
	   $ar =array();
	   
	   for($i=date("Y");$i>=1920;$i--)
	   {
		   $ar[$i]= $i;
	   }
	   return $ar;
   }
   public function warranty()
   {
	 return array("Y"=>"Yes","N"=>"No","D"=>"Does not apply");
	    
   }
   public function cylinders()
   {
	 return array(
	 "3"=>"3 Cylinder",
	 "4"=>"4 Cylinder",
	 "5"=>"5 Cylinder",
	 "6"=>"6 Cylinder",
	 "7"=>"7 Cylinder",
	 "8"=>"8 Cylinder",
	 "9"=>"9 Cylinder",
	 "10"=>"10 Cylinder",
	 "11"=>"11 Cylinder",
	 "12"=>"12 Cylinder",
	 "13"=>"Unknown",
	 );
	    
   }
   public function getCylinders($id)
   {
	  $ar =  $this->cylinders() ;
	  if(isset($ar[$id]))
	  {
		  return $ar[$id];
	  }
	  else
	  {
		  return "Unknown";
	  }
   }
   public function getWarranty($id)
   {
	  $ar =  $this->warranty() ;
	  if(isset($ar[$id]))
	  {
		  return $ar[$id];
	  }
	  else
	  {
		  return "No ";
	  }
   }
   
   public function YesNoArray()
   {
	   return array("Y"=>"Yes","N"=>"No","I"=>"Inactive","A"=>"Active");
   }
   public function YesNo($val)
   {
	    
	    if((string)$val=="Y")
	    {
			return "'Featured1'";
		}
		else
		{
			return "'Featured'";
		}
   }
    public function search_2()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria=new CDbCriteria;
        $criteria->compare('t.isTrash','0',true);
        $criteria->order ="t.id desc";
        $criteria->with = array("adImagesOnView3");
        $criteria->together = true;
		$pageSize = (Yii::app()->request->getQuery("page_size")) ?  (int) Yii::app()->request->getQuery("page_size") : $pageSize = 20;
        return new CActiveDataProvider($this, array(
		'criteria'=>$criteria,
		'pagination'=>array(
		'pageSize'=>$pageSize,
    ),
            
        ));
    }
    
   public function getFeaturedAd()
   {
		  $criteria=new CDbCriteria;
		  $condition		 =  "t.isTrash='0' and t.status='A' and featured='Y' and t.country=:country";;
	      $paramsArray[":country"] = Yii::app()->request->cookies['country']->value;
		 //FOR SPECIFI STATES
		 
		  if(Yii::app()->request->cookies['state']->value!=0)
		  {
			  $condition		 .=  " and t.state=:state";
			  $paramsArray[":state"] = Yii::app()->request->cookies['state']->value;
		  }
		  $criteria->condition = $condition;
		  $criteria->params = $paramsArray;
		  $criteria->order  = "t.id desc";
		  $criteria->limit ="18";
		  return  $this->findAll($criteria);
   }
   public function getFeaturedListings($limit)
   {
		  $criteria			 	 =	new CDbCriteria;
		  $condition			 =  self::FEATURED_CONDITION;
		  $criteria->condition   =  $condition;
		  $criteria->order  	 =  self::FEATURED_ORDER;
		  $criteria->limit 		 =  $limit;
		  return  $this->findAll($criteria);
   }
   
   public static function getCommonCondition()
   { 
	    return " t.isTrash='0' and t.status='A' and t.country=".Countries::model()->getDefaultCountryId() ;
   }
   
   public function getRealtedAds($notinIds,$section,$limit)
   {
		  $criteria			 	  =	 new CDbCriteria;
		  $condition			  =  self::COMMON_CONDITION;
		  if($section!="")
		  {
		  $condition			 .=  Yii::t('ad', ' and t.section_id  = "{section}"',array('{section}'=>$section)); 
		  }
		  $criteria->condition   =  $condition;
		  $criteria->addNotInCondition('id',  $notinIds  );
		  $criteria->order  	 =  self::COMMON_ORDER;
		  $criteria->limit 		 =  $limit;
		  return  $this->findAll($criteria);
   }
   
    public function getLatestListings($limit,$category=null)
   {
		  $criteria			 	 =	new CDbCriteria;
		  $condition			 =  self::LATEST_CONDITION;
		  if($category !="")
		  {
		  $condition			 .=  " and t.section_id=:sec";
		  $criteria->params[':sec'] =$category;
		  }
		  $criteria->condition   =  $condition;
		  $criteria->order  	 =  self::FEATURED_ORDER;
		  $criteria->limit 		 =  $limit;
		  return  $this->findAll($criteria);
   }
   
   
   public function afterFind(){
	    $this->fieldDecorator->onHtmlOptionsSetup = array($this, '_setDefaultEditorForContent');
	   $this->amenities =  CHtml::listData($this->adAmenities,'amenities_id','amenities_id');
	    parent::afterFind();
   }
    protected function afterConstruct()
    {
        $this->fieldDecorator->onHtmlOptionsSetup = array($this, '_setDefaultEditorForContent');
        parent::afterConstruct();
    }
   
     public function _setDefaultEditorForContent(CEvent $event)
    {
        if ($event->params['attribute'] == 'ad_description') {
            $options = array();
            if ($event->params['htmlOptions']->contains('wysiwyg_editor_options')) {
                $options = (array)$event->params['htmlOptions']->itemAt('wysiwyg_editor_options');
            }
            $options['id'] = CHtml::activeId($this, $event->params['attribute']);
            $options['height'] = 150;
            $options['toolbar']= 'Simple';
            $event->params['htmlOptions']->add('wysiwyg_editor_options', $options);
        }
    }
   
   
   public function listDataFromSlug($slug)
   {
	     $criteria=new CDbCriteria;
		 $criteria->condition = "t.isTrash='0' and t.status='A'";
		 $criteria->with = array("subCategory"=>array("on"=>"subCategory.isTrash='0' and subCategory.status='A'","condition"=>"subCategory.slug=:sname","params"=>array(":sname"=>$slug),'joinType'=>'INNER JOIN'));
		 return  $this->findAll($criteria);
   }
   public function AdFromSlug($slug)
   {
	     $criteria=new CDbCriteria;
		 $criteria->condition = "t.isTrash='0' and t.status='A' and t.slug=:slug";
		 $criteria->params[':slug'] = $slug;
		 return  $this->find($criteria);
   }
   public function SearchCondition($search)
   {
	  
	     $condition		 =  "t.isTrash='0' and t.status='A' and t.country=:country";
	     $paramsArray[":country"] = Yii::app()->request->cookies['country']->value;
		  
		 
		 //FOR SPECIFI STATES
		 
		 if(Yii::app()->request->cookies['state']->value!=0)
		 {
			  $condition		 .=  " and t.state=:state";
			  $paramsArray[":state"] = Yii::app()->request->cookies['state']->value;
		 }
		 
		
		 
		
		 //PRICE SEARCH
		 if(isset($search["price__from"]) and $search["price__from"]!="")
		 {
			  $condition 			   .=  " and t.price>=:price_from";
			  $paramsArray[":price_from"]  =  $search["price__from"];
		 }
		 
		 if(isset($search["price__to"]) and $search["price__to"]!="")
		 {
			  $condition 			 .=  " and t.price<=:price_to";
			  $paramsArray[":price_to"]  =  $search["price__to"];
		 }
		 //KILOMETER SEARCH
		 if(isset($search["kilometer__from"]) and $search["kilometer__from"]!="")
		 {
			  $condition 					.=  " and t.killometer>=:kilometer__from";
			  $paramsArray[":kilometer__from"]  =  $search["kilometer__from"];
		 }
		 
		 if(isset($search["kilometer__to"]) and $search["kilometer__to"]!="")
		 {
			  $condition 				  .=  " and t.killometer<=:kilometer__to";
			  $paramsArray[":kilometer__to"]  =  $search["kilometer__to"];
		 }
		
		 //BEDROOM SEARCH
		 if(isset($search["bedrooms_min"]) and $search["bedrooms_min"]!="")
		 {
			  $condition 				 .=  " and t.bedrooms>=:bedrooms_min";
			  $paramsArray[":bedrooms_min"]  =  $search["bedrooms_min"];
		 }
		 
		 if(isset($search["bedrooms_max"]) and $search["bedrooms_max"]!="")
		 {
			  $condition 				 .=  " and t.bedrooms<=:bedrooms_max";
			  $paramsArray[":bedrooms_max"]  =  $search["bedrooms_max"];
		 }
		 
		 //BATHROOM SEARCH
		 if(isset($search["bathrooms_min"]) and $search["bathrooms_min"]!="")
		 {
			  $condition 				  .=  " and t.bathrooms>=:bathrooms_min";
			  $paramsArray[":bathrooms_min"]  =  $search["bathrooms_min"];
		 }
		 
		 if(isset($search["bathrooms_max"]) and $search["bathrooms_max"]!="")
		 {
			  $condition 				  .=  " and t.bathrooms<=:bathrooms_max";
			  $paramsArray[":bathrooms_max"]  =  $search["bathrooms_max"];
		 }
		 
		 //YEAR SEARCH
		 if(isset($search["year_min"]) and $search["year_min"]!="")
		 {
			  $condition 			 .=  " and t.year>=:year_min";
			  $paramsArray[":year_min"]  =  $search["year_min"];
		 }
		 
		 if(isset($search["year_max"]) and $search["year_max"]!="")
		 {
			  $condition 			 .=  " and t.year<=:year_max";
			  $paramsArray[":year_max"]  =  $search["year_max"];
		 }
		 //Model
		 if(isset($search["model"]) and $search["model"]!="")
		 {
			  $condition 			 .=  " and t.model=:model";
			  $paramsArray[":model"]  =  $search["model"];
		 }
		 //Section
		 if(isset($search["section_id"]) and $search["section_id"]!="")
		 {
			  $condition 			 .=  " and t.section_id=:section_id";
			  $paramsArray[":section_id"]  =  $search["section_id"];
		 }
		 //CATEGORY
		 if(isset($search["category_id"]) and $search["category_id"]!="")
		 {
			  $condition 			 .=  " and t.category_id=:category_id";
			  $paramsArray[":category_id"]  =  $search["category_id"];
		 }
		 //SUBCATEGORY
		 if(isset($search["sub_category_id"]) and $search["sub_category_id"]!="")
		 {
			  $condition 			 .=  " and t.sub_category_id=:sub_category_id";
			  $paramsArray[":sub_category_id"]  =  $search["sub_category_id"];
		 }
		  
		 
		 //COLOR
		 if(isset($search["color_id"]) and !empty($search["color_id"]))
		 {
		 $list =  implode(',',$search["color_id"]); 
		 $condition  .= " and  t.color in (:list)";
		 $paramsArray[":list"] =  $list;
	     }
		 //DOOR
		 if(isset($search["door_id"]) and !empty($search["door_id"]))
		 {
		 $list =  implode(',',$search["door_id"]); 
		 $condition  .= " and  t.door in (:list2)";
		 $paramsArray[":list2"] =  $list;
	     }
		 //bodycondition
		 if(isset($search["bodycondition_id"]) and !empty($search["bodycondition_id"]))
		 {
		 $list =  implode(',',$search["bodycondition_id"]); 
		 $condition  .= " and  t.bodycondition in (:list3)";
		 $paramsArray[":list3"] =  $list;
	     }
		 
		 //mechanicalcondition
		 if(isset($search["mechanicalcondition_id"]) and !empty($search["mechanicalcondition_id"]))
		 {
		 $list =  implode(',',$search["mechanicalcondition_id"]); 
		 $condition  .= " and  t.mechanicalcondition in (:list4)";
		 $paramsArray[":list4"] =  $list;
	     }
		  //user ID
		 if(isset($search["user_id"]) and !empty($search["user_id"]))
		 {
		 
		 $condition  .= " and  t.user_id in (:usr)";
		 $paramsArray[":usr"] = $search["user_id"];
	     }
		 //fuel_id
		 if(isset($search["fuel_id"]) and !empty($search["fuel_id"]))
		 {
		 $list =  implode(',',$search["fuel_id"]); 
		 $condition  .= " and  t.fuel_type in (:list5)";
		 $paramsArray[":list5"] =  $list;
	     }
		 //body_type
		 if(isset($search["body_type_id"]) and !empty($search["body_type_id"]))
		 {
		 $list =  implode(',',$search["body_type_id"]); 
		 $condition  .= " and  t.body_type in (:list6)";
		 $paramsArray[":list6"] =  $list;
	     }
	      
	     //DATE COMPARE
		 if(isset($search["added__date"]) and $search["added__date"]!="")
		 {
			switch($search["added__date"]) {
			case 0:
			$condition  .= " and  DATE(t.added_date) = CURDATE()";
			break;
			case 3:
			$condition  .= " and   t.added_date >= DATE_ADD(CURDATE(), INTERVAL -3 DAY)";
			case 7:
			$condition  .= " and   t.added_date >= DATE_ADD(CURDATE(), INTERVAL -7 DAY)";
			case 14:
			$condition  .= " and   t.added_date >= DATE_ADD(CURDATE(), INTERVAL -14 DAY)";
			case 30:
			$condition  .= " and   t.added_date >= DATE_ADD(CURDATE(), INTERVAL -1 MONTH)";
			case 90:
			$condition  .= " and   t.added_date >= DATE_ADD(CURDATE(), INTERVAL -3 MONTH)";
			case 190:
			$condition  .= " and   t.added_date >= DATE_ADD(CURDATE(), INTERVAL -6 MONTH)";
			 
			 
			}
		  }
	    
		
		 
		 
		 
		 //KEYWORD
		 if(isset($search["keyword"]) and $search["keyword"]!="")
		 {
		 $condition  .= " and ( t.ad_title like :keyword or t.ad_description like :keyword ) ";
		 $paramsArray[":keyword"] = "%{$search['keyword']}%";
	     }
		 
		 return array("condition"=>$condition,"params"=>$paramsArray);
   }
   public function SearchConditionCount($search)
   {
	     $condition		 =  "t.isTrash='0' and t.status='A' and t.country=:country";
	     $paramsArray[":country"] = Yii::app()->request->cookies['country']->value;
		  
		 
		 //FOR SPECIFI STATES
		 
		 if(Yii::app()->request->cookies['state']->value!=0)
		 {
			  $condition		 .=  " and t.state=:state";
			  $paramsArray[":state"] = Yii::app()->request->cookies['state']->value;
		 }
		 //PRICE SEARCH
		 if(isset($search["price__from"]) and $search["price__from"]!="")
		 {
			  $condition 			   .=  " and t.price>=:price_from";
			  $paramsArray[":price_from"]  =  $search["price__from"];
		 }
		 
		 if(isset($search["price__to"]) and $search["price__to"]!="")
		 {
			  $condition 			 .=  " and t.price<=:price_to";
			  $paramsArray[":price_to"]  =  $search["price__to"];
		 }
		 //KILOMETER SEARCH
		 if(isset($search["kilometer__from"]) and $search["kilometer__from"]!="")
		 {
			  $condition 					.=  " and t.killometer>=:kilometer__from";
			  $paramsArray[":kilometer__from"]  =  $search["kilometer__from"];
		 }
		 
		 if(isset($search["kilometer__to"]) and $search["kilometer__to"]!="")
		 {
			  $condition 				  .=  " and t.killometer<=:kilometer__to";
			  $paramsArray[":kilometer__to"]  =  $search["kilometer__to"];
		 }
		
		 //BEDROOM SEARCH
		 if(isset($search["bedrooms_min"]) and $search["bedrooms_min"]!="")
		 {
			  $condition 				 .=  " and t.bedrooms>=:bedrooms_min";
			  $paramsArray[":bedrooms_min"]  =  $search["bedrooms_min"];
		 }
		 
		 if(isset($search["bedrooms_max"]) and $search["bedrooms_max"]!="")
		 {
			  $condition 				 .=  " and t.bedrooms<=:bedrooms_max";
			  $paramsArray[":bedrooms_max"]  =  $search["bedrooms_max"];
		 }
		 
		 //BATHROOM SEARCH
		 if(isset($search["bathrooms_min"]) and $search["bathrooms_min"]!="")
		 {
			  $condition 				  .=  " and t.bathrooms>=:bathrooms_min";
			  $paramsArray[":bathrooms_min"]  =  $search["bathrooms_min"];
		 }
		 
		 if(isset($search["bathrooms_max"]) and $search["bathrooms_max"]!="")
		 {
			  $condition 				  .=  " and t.bathrooms<=:bathrooms_max";
			  $paramsArray[":bathrooms_max"]  =  $search["bathrooms_max"];
		 }
		 
		 //YEAR SEARCH
		 if(isset($search["year_min"]) and $search["year_min"]!="")
		 {
			  $condition 			 .=  " and t.year>=:year_min";
			  $paramsArray[":year_min"]  =  $search["year_min"];
		 }
		 
		 if(isset($search["year_max"]) and $search["year_max"]!="")
		 {
			  $condition 			 .=  " and t.year<=:year_max";
			  $paramsArray[":year_max"]  =  $search["year_max"];
		 }
		  //KEYWORD
		 if(isset($search["keyword"]) and $search["keyword"]!="")
		 {
		 $condition  .= " and ( t.ad_title like :keyword or t.ad_description like :keyword ) ";
		 $paramsArray[":keyword"] = "%{$search['keyword']}%";
	     }
	      //Model
		 if(isset($search["model"]) and $search["model"]!="")
		 {
			  $condition 			 .=  " and t.model=:model";
			  $paramsArray[":model"]  =  $search["model"];
		 }
		 
		  //Section
		 if(isset($search["section_id"]) and $search["section_id"]!="")
		 {
			  $condition 			 .=  " and t.section_id=:section_id";
			  $paramsArray[":section_id"]  =  $search["section_id"];
		 }
		 //CATEGORY
		 if(isset($search["category_id"]) and $search["category_id"]!="")
		 {
			  $condition 			 .=  " and t.category_id=:category_id";
			  $paramsArray[":category_id"]  =  $search["category_id"];
		 }
		 //SUBCATEGORY
		 if(isset($search["sub_category_id"]) and $search["sub_category_id"]!="")
		 {
			  $condition 			 .=  " and t.sub_category_id=:sub_category_id";
			  $paramsArray[":sub_category_id"]  =  $search["sub_category_id"];
		 }
		  
		 //COLOR
		 if(isset($search["color_id"]) and !empty($search["color_id"]))
		 {
		 $list =  implode(',',$search["color_id"]); 
		 $condition  .= " and  t.color in (:list)";
		 $paramsArray[":list"] =  $list;
	     }
		 //DOOR
		 if(isset($search["door_id"]) and !empty($search["door_id"]))
		 {
		 $list =  implode(',',$search["door_id"]); 
		 $condition  .= " and  t.door in (:list2)";
		 $paramsArray[":list2"] =  $list;
	     }
		 //bodycondition
		 if(isset($search["bodycondition_id"]) and !empty($search["bodycondition_id"]))
		 {
		 $list =  implode(',',$search["bodycondition_id"]); 
		 $condition  .= " and  t.bodycondition in (:list3)";
		 $paramsArray[":list3"] =  $list;
	     }
		 
		 //mechanicalcondition
		 if(isset($search["mechanicalcondition_id"]) and !empty($search["mechanicalcondition_id"]))
		 {
		 $list =  implode(',',$search["mechanicalcondition_id"]); 
		 $condition  .= " and  t.mechanicalcondition in (:list4)";
		 $paramsArray[":list4"] =  $list;
	     }
		 
		 //fuel_id
		 if(isset($search["fuel_id"]) and !empty($search["fuel_id"]))
		 {
		 $list =  implode(',',$search["fuel_id"]); 
		 $condition  .= " and  t.fuel_type in (:list5)";
		 $paramsArray[":list5"] =  $list;
	     }
		 //user ID
		 if(isset($search["user_id"]) and !empty($search["user_id"]))
		 {
		 
		 $condition  .= " and  t.user_id in (:usr)";
		 $paramsArray[":usr"] = $search["user_id"];
	     }
		 //body_type
		 if(isset($search["body_type_id"]) and !empty($search["body_type_id"]))
		 {
		 $list =  implode(',',$search["body_type_id"]); 
		 $condition  .= " and  t.body_type in (:list6)";
		 $paramsArray[":list6"] =  $list;
	     }
	     //DATE COMPARE
		 if(isset($search["added__date"]))
		 {
			switch($search["added__date"]) {
			case 0:
			$condition  .= " and  DATE(t.added_date) = CURDATE()";
			break;
			case 3:
			$condition  .= " and   t.added_date >= DATE_ADD(CURDATE(), INTERVAL -3 DAY)";
			case 7:
			$condition  .= " and   t.added_date >= DATE_ADD(CURDATE(), INTERVAL -7 DAY)";
			case 14:
			$condition  .= " and   t.added_date >= DATE_ADD(CURDATE(), INTERVAL -14 DAY)";
			case 30:
			$condition  .= " and   t.added_date >= DATE_ADD(CURDATE(), INTERVAL -1 MONTH)";
			case 90:
			$condition  .= " and   t.added_date >= DATE_ADD(CURDATE(), INTERVAL -3 MONTH)";
			case 190:
			$condition  .= " and   t.added_date >= DATE_ADD(CURDATE(), INTERVAL -6 MONTH)";
			 
			default:
			 
			break;
			}
		  }
		//echo $condition;exit;
		 return array("condition"=>$condition,"params"=>$paramsArray);
   }
   function updateXmlAds($status)
   {
	   
        $criteria		=	new CDbCriteria;
        $criteria->condition ="xml_inserted=:xml_status";
        $criteria->params[':xml_status'] = '1' ;
        $this->updateAll(array('status'=>$status), $criteria);
   }
   public function getAllxmlPk($SectionID)
   {
	   $criteria		=	new CDbCriteria;
	   $criteria->select = "t.xml_pk";
        $criteria->condition ="xml_inserted=:xml_status and t.section_id=:sec";
        $criteria->params[':xml_status'] = '1' ;
        $criteria->params[':sec'] =$SectionID;
        return $this->findAll($criteria);
	   
   }
   public function getAllProspace_xml()
   {
	   
			$criteria		=	new CDbCriteria;
			$criteria->select = "t.xml_reference,t.xml_update_date";
			$criteria->condition ="xml_inserted=:xml_status and t.xml_type=:type";
			$criteria->params[':xml_status'] = '1' ;
			$criteria->params[':type'] = 'P' ;
			return $this->findAll($criteria);
	   
   }
   public function getAllxml($section)
   {
	   
			$criteria		=	new CDbCriteria;
			$criteria->select = "t.id,t.modified_date,t.code";
			$criteria->condition ="t.xml_type=:type and t.section_id=:section";
			$criteria->params[':type'] = 'P' ;
			$criteria->params[':section'] = $section ;
			return $this->findAll($criteria);
	   
   }
   
    function category_isert($SectionID,$v1)
     {
							$category_model = new Category;
							$category_model->isNewRecord =true;  
							$category_model->category_id     = "";
							$category_model->section_id     = $SectionID;
							$category_model->category_name  = $v1;
							$category_model->amenities_required  = 'Y';
							$category_model->xml_inserted  = '1';
							$category_model->slug = $category_model->getUniqueSlug();
							$category_model->save();
							return  Yii::app()->db->getLastInsertId();
	 }
	 
	 
	 function fieldInsertion($category_id)
	 {
		
								   $Fileds =  new   CategoryFieldList;
			                       $attributes2=array('price','area','bathrooms','bedrooms');
								   foreach($attributes2 as $field)
								   {
										$Fileds->isNewRecord =true;
										$Fileds->field_name = $field ;
										$Fileds->category_id = $category_id;
										$Fileds->save();
								   }  
	}
	function subcategory_insert($category_id,$unitType,$SectionID)
	{
							 $sub_category_model = new Subcategory;
							 $subcategory = CHtml::listData(Subcategory::model()->ListDataForCategory($category_id),'sub_category_id','sub_category_name');
							 if(!$this->in_arrayi($unitType, $subcategory))
							 {
								 $sub_category_model->isNewRecord    = true;
								 $sub_category_model->section_id     = $SectionID;
								 $sub_category_model->sub_category_id     ="";
								 $sub_category_model->category_id     = $category_id;
								 $sub_category_model->sub_category_name  = $unitType;
								 $sub_category_model->amenities_required  = 'Y';
								 $sub_category_model->xml_inserted  = '1';
								 $sub_category_model->slug = $sub_category_model->getUniqueSlug();
								 $sub_category_model->save();
								 return  Yii::app()->db->getLastInsertId();
								  
								  
							 }
							 else
							 {
								  return  array_search(strtolower($unitType),array_map('strtolower', $subcategory ) );
							 }
	}
	function country_insert($con,$v1)
    {
		$country = new Countries;
		                    if(!$this->in_arrayi($v1, $con))
		                    {
								$country->country_name =$v1;
								$country->country_code ='XXX';
								$country->location_longitude ='1';
								$country->location_latitude ='1';
								$country->save();
								return  Yii::app()->db->getLastInsertId();

							}
							 else
							 {
								  
								 return  array_search(strtolower($v1),array_map('strtolower', $con ) );
							 }
	}
    function state_insert($con,$v1,$country_id)
    {  
							$state = new States;
		                    if(!$this->in_arrayi($v1, $con))
		                    {
								$state->state_name =$v1;
								$state->country_id =$v1;
								$state->location_longitude ='1';
								$state->location_latitude ='1';
								$state->save();
								return  Yii::app()->db->getLastInsertId();

							}
							 else
							 {
								 
								  return  array_search(strtolower($v1),array_map('strtolower', $con ) );
							 }
	}
	 function in_arrayi($needle, $haystack) {
	
		return in_array(strtolower($needle), array_map('strtolower', $haystack));
	}
	 function insertUser($user_email, $user_phone,$user_name,$user_image)
    {
		 
		   $model = new ListingUsers();
			$img_user="";
			/*
			if (@GetImageSize($user_image)) {



			$path =  Yii::app()->basePath . '/../../uploads' ;
			$img_user = 'usr'.rand(0,9999).'_'.time().".jpg";
			$content = file_get_contents($path);
			file_put_contents($path."/avatar/{$img_user}", $content);
			}
			* */
										 
			$model->email = $user_email;
			$model->phone = $user_phone;
			$serexplode = explode(' ',$user_name);
            $model->first_name = @$serexplode['0'];
            $model->last_name =@$serexplode['1'];
            $password = '123456' ;
            $model->image= $img_user ; 
            $model->con_password=  $password  ;
            $model->password= $password ;
            $model->status='A';
            $model->xml_inserted='1';
            $model->xml_image=$user_image;
            $model->save() ;
            return  Yii::app()->db->getLastInsertId();
	}
	function imageinsert($imagearray,$ad_id,$delete=0)
	{
		 
				 $room_image = new AdImage;
				 if($delete==1)
				 {
					 $room_image->deleteAll(array("condition"=>"ad_id=:ad_id","params"=>array(":ad_id"=>$ad_id)));
					
				 }
				 
				 if(!empty($imagearray))
				 {
				 foreach($imagearray as  $photo)
									 {
										 
											$img ="";
											 
											if (@GetImageSize($photo)) {

											$path =  Yii::app()->basePath . '/../../uploads' ;
											$img = rand(0,9999).'_'.time().".jpg";
											$content = file_get_contents($photo);
											file_put_contents($path."/ads/{$img}", $content);

											}
											 
										 
											$room_image->isNewRecord = true;
											$room_image->id = "";
											$room_image->ad_id = $ad_id;
											$room_image->image_name = $img ;
											$room_image->xml_image = $photo ;
											$room_image->status = "A";
											$room_image->save();
										 
										   
											  
									 }
								 }
	}
    function adsMessage($totalcount,$totalinsertcount,$totalupdatecount,$fetched,$section="")
    {
		echo "Dear Admin ,<br />"; 
		$remaining = $totalcount-($fetched+$totalinsertcount+$totalupdatecount); 
		$remainin_msg = "";
		if((int)$remaining > 0 )
		{
			$remainin_msg = " and remaining <b>{$remaining} </b> Ads to fetch";
		}
		echo "Total Ads {$totalcount} found and {$totalinsertcount} inserted and {$totalupdatecount} updated on section {$section}".$remainin_msg; 
		exit;
	}
	function renderImage($image="",$xml="P",$image_name="")
	{
		
		
					$image =Yii::app()->basePath . '/../../uploads/ads/'.$image_name;
					if (is_file($image)) {
						 
						return Yii::app()->apps->getBaseUrl('uploads/ads/'.$image_name); 
					} 
					else {
						return   Yii::app()->theme->baseUrl.'/images/ucnoimage.jpg'; 
					}
		
		
				if($xml=="N")
				{
				 
					$image =Yii::app()->basePath . '/../../uploads/ads/'.$image_name;
					if (is_file($image)) {
						 
						return Yii::app()->apps->getBaseUrl('uploads/ads/'.$image_name); 
					} 
					else {
						return   Yii::app()->theme->baseUrl.'/images/ucnoimage.jpg'; 
					}
				}
				if(@GetImageSize($image)) {
					return   $image; 
				}
				else
				{
					 
					return   Yii::app()->theme->baseUrl.'/images/ucnoimage.jpg'; 
				}
			
	}
	function renderImageNew($image_name="")
	{
		
		
					$image =Yii::app()->basePath . '/../../uploads/ads/'.$image_name;
					if (is_file($image)) {
						 
						return Yii::app()->apps->getBaseUrl('uploads/ads/'.$image_name); 
					} 
					else {
						return   Yii::app()->theme->baseUrl.'/images/ucnoimage.jpg'; 
					}
		 
	}
	
 
	function currencyAbreviation($currency="")
	{
		return ($currency =="") ? Yii::app()->options->get('system.common.defalut_currency') : $currency  ;
	}
	function getPriceWithCurrncy()
	{
		return  Yii::app()->options->get('system.common.defalut_currency').' '.  number_format($this->price,0,'.',',') ;
	}
	function getBuiltUpArea()
	{
		return     number_format($this->builtup_area_sqft,0,'.',','). ' Sq.Ft.' ;
	}
	function getSystemRefNo()
	{
		if(!empty($this->RefNo)){
			return $this->RefNo;
		}
		else{
			return 'MA'.str_pad($this->id,5,0,STR_PAD_LEFT);
		}
		return     number_format($this->builtup_area_sqft,0,'.',','). ' Sq.Ft.' ;
	}
	function getPriceHtml()
	{
			$htmlTag =  '<div class="Price_span"> '.$this->priceWithCurrncy;
			if($this->section_id == self::RENT_ID ){
			$htmlTag .= '<br><span class="rentpermonth" style="font-size:12px">(rent per  '.$this->rentPaid2.')</span>';
			}
			$htmlTag .= ' </div> ' ;
			return $htmlTag;
	}
	function getDetailsPriceHtml()
	{
		
		    $htmlTag ='<span class="unit-price-div">'.Yii::app()->options->get('system.common.defalut_currency').' <span class="price-text">'.number_format($this->price,0,'.',',').'</span>';
		    if($this->section_id == self::RENT_ID ){
			$htmlTag .= '<span class="rentpermonth">(rent per  '.$this->rentPaid2.')</span>';
			}
		    $htmlTag .= '</span>';
			 
			return $htmlTag;
	}
	function getRentPaid()
	{
			if(empty($this->rent_paid)) 
			{
				$this->rent_paid ='yearly';
			}
			return  ' / '.$this->rent_paid ;
			 
	}
	function getRentPaid2()
	{
			if(empty($this->rent_paid)) 
			{
				$this->rent_paid ='yearly';
			}
			return   $this->rent_paid ;
			 
	}
	function getLocationString()
	{
			if(!empty($this->district)){
			return 	$this->district0->district_name;
			}
			else{
				return 	$this->state0->state_name ;
			}
			 
	}
	function getReadyString2()
	{
			if(!empty($this->occupant_status) and $this->occupant_status=='Vacant'){
			return '<div class="readynow-div2"> <span>Ready Now</span> </div>';
			}
			 
			 
	}
	function getReadyString()
	{
			if(!empty($this->occupant_status) and $this->occupant_status=='Vacant'){
			return '<div class="readynow-div"> <span>Ready Now</span> </div>';
			}
			 
			 
	}
	function getPropertyDatilUrl()
	{
			return   Yii::app()->createUrl($this->slug.'/detailView'); 
			 
	}
	function getPropertyAbsoluteDatilUrl()
	{
			return   Yii::app()->createAbsoluteUrl($this->slug.'/detailView'); 
			 
	}
	function getBuiltupAreaString()
	{
			if(!empty($this->builtup_area)){
			return 	$this->builtup_area .  ' sq.ft.';
			}
			 
			 
	}
	function getLocalBedString()
	{
		$htmlTag ='';
		 if(!empty($this->bedrooms)){
			 $htmlTag .='<span style="float:left;">'.(int) $this->bedrooms .'</span><span title="'.(int) $this->bedrooms .' Bedroom(s)" class="unitbeds"></span>';
		 }
		 if(!empty($this->bathrooms)){
			  $htmlTag .='<span style="float:left;">'.(int) $this->bathrooms .'</span><span title="'.(int) $this->bathrooms .' Bathroom(s)" class="unitbaths"></span>';
		 
		 }
		 if(!empty($this->parking)){
			  $htmlTag .='<span style="float:left;">'.(int) $this->parking  .'</span><span title="'.(int) $this->parking .' Car Parking(s)" class="unitparkng"></span>';
		 
		 } 
		 return $htmlTag;
			 
			 
	}
	function FomatMoney($money="0")
	{
		return  number_format($money,0,'.',',')  ;
	}
	function priceArray(){
		return array(
		10000 => '10000 '.Yii::app()->options->get('system.common.defalut_currency'),
		50000 => '50000 '.Yii::app()->options->get('system.common.defalut_currency'),
		100000 => '100000 '.Yii::app()->options->get('system.common.defalut_currency'),
		200000 => '200000 '.Yii::app()->options->get('system.common.defalut_currency'),
		300000 => '300000 '.Yii::app()->options->get('system.common.defalut_currency'),
		400000 => '400000 '.Yii::app()->options->get('system.common.defalut_currency'),
		500000 => '500000 '.Yii::app()->options->get('system.common.defalut_currency'),
		1000000 => '1000000 '.Yii::app()->options->get('system.common.defalut_currency'),
		);
	}
	function getMinPriceHtml()
	{
		?>
			<option value="">Min Price</option>
			<option value="10000"    <?php echo  (Yii::app()->request->getQuery("min-price")=="10000" )? "selected=true" : ""; ?>><?php echo Yii::app()->options->get('system.common.defalut_currency');?> <?php echo number_format('10000.00',2,'.',',');?></option>
			<option value="50000"   <?php echo   (Yii::app()->request->getQuery("min-price")=="50000" )? "selected=true" : ""; ?>><?php echo Yii::app()->options->get('system.common.defalut_currency');?>  <?php   echo number_format('50000.00',2,'.',',');?></option>
			<option value="100000"  <?php echo   (Yii::app()->request->getQuery("min-price")=="100000" )? "selected=true" : ""; ?>><?php echo Yii::app()->options->get('system.common.defalut_currency');?> <?php  echo number_format('100000.00',2,'.',',');?></option>
			<option value="200000"  <?php echo   (Yii::app()->request->getQuery("min-price")=="200000" )? "selected=true" : ""; ?>><?php echo Yii::app()->options->get('system.common.defalut_currency');?> <?php  echo number_format('200000.00',2,'.',',');?></option>
			<option value="300000"  <?php echo   (Yii::app()->request->getQuery("min-price")=="300000" )? "selected=true" : ""; ?>><?php echo Yii::app()->options->get('system.common.defalut_currency');?> <?php  echo number_format('300000.00',2,'.',',');?></option>
			<option value="400000"  <?php echo   (Yii::app()->request->getQuery("min-price")=="400000" )? "selected=true" : ""; ?>><?php echo Yii::app()->options->get('system.common.defalut_currency');?> <?php  echo number_format('400000.00',2,'.',',');?></option>
			<option value="500000"  <?php echo   (Yii::app()->request->getQuery("min-price")=="500000" )? "selected=true" : ""; ?>><?php echo Yii::app()->options->get('system.common.defalut_currency');?> <?php  echo  number_format('500000.00',2,'.',',');?></option>
			<option value="1000000" <?php echo   (Yii::app()->request->getQuery("min-price")=="1000000" )? "selected=true" : ""; ?>><?php echo Yii::app()->options->get('system.common.defalut_currency');?> <?php  echo number_format('1000000.00',2,'.',',');?></option>     

		<?
	}
	function getMaxPriceHtml()
	{
		?>Bathrooms
		    <option value="">Max Price</option>
			<option value="10000"    <?php echo  ( Yii::app()->request->getQuery("max-price")=="10000" )? "selected=true" : ""; ?>><?php echo Yii::app()->options->get('system.common.defalut_currency');?> <?php echo number_format('10000.00',2,'.',',');?></option>
			<option value="50000"   <?php echo   ( Yii::app()->request->getQuery("max-price")=="50000" )? "selected=true" : ""; ?>><?php echo Yii::app()->options->get('system.common.defalut_currency');?>  <?php   echo number_format('50000.00',2,'.',',');?></option>
			<option value="100000"  <?php echo   ( Yii::app()->request->getQuery("max-price")=="100000" )? "selected=true" : ""; ?>><?php echo Yii::app()->options->get('system.common.defalut_currency');?> <?php  echo number_format('100000.00',2,'.',',');?></option>
			<option value="200000"  <?php echo   ( Yii::app()->request->getQuery("max-price")=="200000" )? "selected=true" : ""; ?>><?php echo Yii::app()->options->get('system.common.defalut_currency');?> <?php  echo number_format('200000.00',2,'.',',');?></option>
			<option value="300000"  <?php echo   ( Yii::app()->request->getQuery("max-price")=="300000" )? "selected=true" : ""; ?>><?php echo Yii::app()->options->get('system.common.defalut_currency');?> <?php  echo number_format('300000.00',2,'.',',');?></option>
			<option value="400000"  <?php echo   ( Yii::app()->request->getQuery("max-price")=="400000" )? "selected=true" : ""; ?>><?php echo Yii::app()->options->get('system.common.defalut_currency');?> <?php  echo number_format('400000.00',2,'.',',');?></option>
			<option value="500000"  <?php echo   ( Yii::app()->request->getQuery("max-price")=="500000" )? "selected=true" : ""; ?>><?php echo Yii::app()->options->get('system.common.defalut_currency');?> <?php  echo  number_format('500000.00',2,'.',',');?></option>
			<option value="1000000" <?php echo   ( Yii::app()->request->getQuery("max-price")=="1000000" )? "selected=true" : ""; ?>><?php echo Yii::app()->options->get('system.common.defalut_currency');?> <?php  echo number_format('1000000.00',2,'.',',');?></option>     
                          
		<?
	}
	function getBedroomHtml()
	{
		?>
			<option value="">Bedrooms</option>
			<option value="1"  <?php echo  (Yii::app()->request->getQuery("bedrooms")=="1" )? "selected=true" : ""; ?> >1 Bedrooms</option>
			<option value="2" <?php echo  (Yii::app()->request->getQuery("bedrooms")=="2" )? "selected=true" : ""; ?>>2 Bedrooms</option>
			<option value="3" <?php echo  (Yii::app()->request->getQuery("bedrooms")=="3" )? "selected=true" : ""; ?>>3 Bedrooms</option>
			<option value="4" <?php echo  (Yii::app()->request->getQuery("bedrooms")=="4" )? "selected=true" : ""; ?>>4 Bedrooms</option>
			<option value="5" <?php echo  (Yii::app()->request->getQuery("bedrooms")=="5" )? "selected=true" : ""; ?>>5 Bedrooms</option>
			<option value="6" <?php echo  (Yii::app()->request->getQuery("bedrooms")=="6" )? "selected=true" : ""; ?>>6 Bedrooms</option>
			<option value="7" <?php echo  (Yii::app()->request->getQuery("bedrooms")=="7" )? "selected=true" : ""; ?>>7 Bedrooms</option>
			<option value="8" <?php echo  (Yii::app()->request->getQuery("bedrooms")=="8" )? "selected=true" : ""; ?>>8 Bedrooms</option>
			<option value="9" <?php echo  (Yii::app()->request->getQuery("bedrooms")=="9" )? "selected=true" : ""; ?>>9 Bedrooms</option>
			<option value="10" <?php echo  (Yii::app()->request->getQuery("bedrooms")=="10" )? "selected=true" : ""; ?>>10 Bedrooms</option>
			<option value="bedroom-equal-and-more" <?php echo  (Yii::app()->request->getQuery("bedrooms")=="bedroom-equal-and-more" )? "selected=true" : ""; ?> >10+ Bedrooms</option>
                                        
		<?
	}
	function getMBathroomHtml()
	{
		?>
				<option value="">Bathrooms</option>
				<option value="1"  <?php echo  (Yii::app()->request->getQuery("bathrooms")=="1" )? "selected=true" : ""; ?> >1 Bathrooms</option>
				<option value="2" <?php echo  (Yii::app()->request->getQuery("bathrooms")=="2" )? "selected=true" : ""; ?>>2 Bathrooms</option>
				<option value="3" <?php echo  (Yii::app()->request->getQuery("bathrooms")=="3" )? "selected=true" : ""; ?>>3 Bathrooms</option>
				<option value="4" <?php echo  (Yii::app()->request->getQuery("bathrooms")=="4" )? "selected=true" : ""; ?>>4 Bathrooms</option>
				<option value="5" <?php echo  (Yii::app()->request->getQuery("bathrooms")=="5" )? "selected=true" : ""; ?>>5 Bathrooms</option>
				<option value="6" <?php echo  (Yii::app()->request->getQuery("bathrooms")=="6" )? "selected=true" : ""; ?>>6 Bathrooms</option>
				<option value="7" <?php echo  (Yii::app()->request->getQuery("bathrooms")=="7" )? "selected=true" : ""; ?>>7 Bathrooms</option>
				<option value="8" <?php echo  (Yii::app()->request->getQuery("bathrooms")=="8" )? "selected=true" : ""; ?>>8 Bathrooms</option>
				<option value="9" <?php echo  (Yii::app()->request->getQuery("bathrooms")=="9" )? "selected=true" : ""; ?>>9 Bathrooms </option>
				<option value="10" <?php echo  (Yii::app()->request->getQuery("bathrooms")=="10" )? "selected=true" : ""; ?>>10 Bathrooms</option>
				<option value="bathroom-equal-and-more" <?php echo  (Yii::app()->request->getQuery("bathrooms")=="bathroom-equal-and-more" )? "selected=true" : ""; ?> >10+ Bathrooms</option>
                                                     
		<?
	}
	public function getShortName($length = 20)
    {
        return StringHelper::truncateLength($this->ad_title, (int)$length);
    }
	
}
