<?php



/**

 * This is the model class for table "{{quiz_contact}}".

 *

 * The followings are the available columns in table '{{quiz_contact}}':

 * @property integer $id

 * @property integer $category_id

 * @property integer $community_id

 * @property string $amount_range

 * @property string $bed_count

 * @property string $handover_date

 * @property string $purpose

 * @property integer $when_buy

 * @property string $name

 * @property string $phone

 * @property string $email

 * @property string $date_added

 */

class QuizContact extends  ActiveRecord

{

    /**

     * @return string the associated database table name

     */
    public $is_phone_validated;
    public function tableName()

    {

        return '{{quiz_contact}}';

    }



    /**

     * @return array validation rules for model attributes.

     */
    public $phone_false;

    public function rules()

    {

        // NOTE: you should only define rules for those attributes that

        // will receive user inputs.

        return array(

            array('category_id, community_id, amount_range, bed_count, handover_date, purpose, when_buy, name, phone, email', 'required'),

            array('category_id, community_id, when_buy', 'numerical', 'integerOnly'=>true),

            array('amount_range, bed_count', 'length', 'max'=>3),

            array('handover_date, purpose', 'length', 'max'=>1),

            array('ad_id,phone_false', 'safe' ),
            array('email', 'email' ),
            array('name', 'length', 'max'=>150),

            array('phone', 'length', 'max'=>20),

            array('email', 'length', 'max'=>200),
            array('is_phone_validated', 'validateHiddenInput' ,"on"=>'insert'),

            // The following rule is used by search().

            // @todo Please remove those attributes that should not be searched.

            array('id, category_id, community_id, amount_range, bed_count, handover_date, purpose, when_buy, name, phone, email, date_added', 'safe', 'on'=>'search'),

        );

    }
    public function validateHiddenInput($attribute,$params)
	{
		
			if($this->is_phone_validated!='1'){
				$this->addError('phone',  'Please enter valid phone number');
		    } 

	}
	
    public function sectional_array(){
       return [
            '30' => 'Apartment',
            '101' => 'Penthouse',
            '99' => 'Villa / Townhouse',
        ];
    }
    public function amountRange(){
        return [

            '1' => '$250,000 – $500,000',
            '2' => '$500,000 – $1,000,000',
            '3' => '$1,000,000 – $3,000,000',
            '4' => 'More than $3,000,000',
        ];
    }
    public function bedRange(){
        return [
        '2' => '2 bedrooms',
        '3' => '3 bedrooms',
        '4' => '4 bedrooms',
        '5' => '5 bedrooms',
        '6' => '6 bedrooms',
        '7' => '7 bedrooms',
        ];
    }
    public function handover_date(){
        return [
        '1' => 'Finished property',
        '3' => 'To be completed within this year',
        '4' => 'To be completed in 2024-2028',
        '5' => 'I\'m not sure', 
        ];
    }
    public function purpose(){
        return [
        '1' => 'For personal living in Dubai',
        '3' => 'For personal use and passive income generation',
        '4' => 'For investment and income generation only', 
        ];
    }
    public function when_buy(){
        return [
        '1' => 'During this month',
        '3' => 'Within the year of 2024',
        '4' => 'I haven\'t decided yet, but I plan to buy in the coming years', 
        '5' => 'I\'m just looking, so I don\'t plan to buy anything ', 
        ];
    }


    /**

     * @return array relational rules.

     */

    public function relations()

    {

        // NOTE: you may need to adjust the relation name and the related

        // class name for the relations automatically generated below.

        return array(

        );

    }



    /**

     * @return array customized attribute labels (name=>label)

     */
    public function getMoreDetails(){

        $catData        = $this->sectional_array();
        $amountData     = $this->amountRange();
        $BedData        = $this->bedRange();
        $HandoverData   = $this->handover_date();
        $PurposeData    = $this->purpose();
        $WhenData       = $this->when_buy();
        $CommunityData  = Community::model()->findByPk($this->community_id);

       return  [
            'category_id' =>$catData[$this->category_id],

            'community_id' => $CommunityData->community_name,

            'amount_range' => $amountData[$this->amount_range],

            'bed_count' =>  $BedData[$this->bed_count],

            'handover_date' => $HandoverData[$this->handover_date],

            'purpose' =>  $PurposeData[$this->purpose],

            'when_buy' =>  $WhenData[$this->when_buy],
        ];
    }

    public function attributeLabels()

    {

        return array(

            'id' => 'ID',

            'category_id' => 'Category',

            'community_id' => 'Community',

            'amount_range' => 'Amount Range',

            'bed_count' => 'Bed Count',

            'handover_date' => 'Handover Date',

            'purpose' => 'Purpose',

            'when_buy' => 'When Buy',

            'name' => 'Name',

            'phone' => 'Phone',

            'email' => 'Email',

            'date_added' => 'Date Added',

        );

    }



    /**

     * Retrieves a list of models based on the current search/filter conditions.

     *

     * Typical usecase:

     * - Initialize the model fields with values from filter form.

     * - Execute this method to get CActiveDataProvider instance which will filter

     * models according to data in model fields.

     * - Pass data provider to CGridView, CListView or any similar widget.

     *

     * @return CActiveDataProvider the data provider that can return the models

     * based on the search/filter conditions.

     */

    public function search()

    {

        // @todo Please modify the following code to remove attributes that should not be searched.



        $criteria=new CDbCriteria;



        $criteria->compare('id',$this->id);

        $criteria->compare('category_id',$this->category_id);

        $criteria->compare('community_id',$this->community_id);

        $criteria->compare('amount_range',$this->amount_range,true);

        $criteria->compare('bed_count',$this->bed_count,true);

        $criteria->compare('handover_date',$this->handover_date,true);

        $criteria->compare('purpose',$this->purpose,true);

        $criteria->compare('when_buy',$this->when_buy);

        $criteria->compare('name',$this->name,true);

        $criteria->compare('phone',$this->phone,true);

        $criteria->compare('email',$this->email,true);

        $criteria->compare('date_added',$this->date_added,true);



        $criteria->order="id desc";
		$pageSize = (Yii::app()->request->getQuery("page_size")) ?  (int) Yii::app()->request->getQuery("page_size") : $pageSize = 10;
		return new CActiveDataProvider($this, array(
		'criteria'=>$criteria,
		'pagination'=>array(
		'pageSize'=>$pageSize,
		),
		));

    }



    /**

     * Returns the static model of the specified AR class.

     * Please note that you should have this exact method in all your CActiveRecord descendants!

     * @param string $className active record class name.

     * @return QuizContact the static model class

     */

    public static function model($className=__CLASS__)

    {

        return parent::model($className);

    }
    public function beforeSave(){
        $this->phone =  !empty($this->phone_false) ? $this->phone_false : $this->phone;
        return parent::beforeSave();
    }
    public function afterSave(){
		parent::afterSave();
        $liamamodel = new ContactUs();
        $adModel                =    new PlaceAnAd();
        $criteria               =    $adModel->findAds(array('_sec_id'=>3),false,1); 
        $criteria->compare('t.id',(int)$this->ad_id);
        $adModel 			=   $adModel->find($criteria);
        $details = $this->getMoreDetails();
        if(!empty($adModel)){
        $data =  [
            [                                        
                "identity" => [
                    "email" =>  $this->email,
                    "sms" =>    $this->phone,         
                    "token" => $_COOKIE["liana_t"],  //Liana Cookie fetched from the tracking cookie.
                ],
                "events" => [         
                    [
                        "verb" => "Contact",            
                        "items" => [
								"Full Name" => $this->name,
                                "Email" => $this->email,
                   			   "Phone Number" => $this->phone,
                   			   "Property Type" => $details['category_id'],
                   			   "Area of Interest" => $details['community_id'],
                   			   "Budget" => $details['amount_range'],
                   			   "Number of Bedrooms" => $details['bed_count'],
                   			   "Date of Handover" => $details['handover_date'],
                   			   "Purpose of Purchase" => $details['purpose'],
                   			   "Timeline" => $details['when_buy'],
                   			   "Budget" => $details['amount_range']
                        ]
                    ],
                    [
                        "verb" => "Quiz Taken",         
                        "items" => [
                                "Project Name" => $adModel->ad_title,
                                "Project Location" => $adModel->LocationString2,
                            	"Page URL"    => $adModel->detailUrlAbsolute,
							   "Property Type" => $details['category_id'],
							   "Area of Interest" => $details['community_id'],
							   "Budget" => $details['amount_range'],
							   "Number of Bedrooms" => $details['bed_count'],
							   "Date of Handover" => $details['handover_date'],
							   "Purpose of Purchase" => $details['purpose'],
							   "Timeline" => $details['when_buy'],
							   "Budget" => $details['amount_range'],
							   "Date" => date('d-m-Y')

                        ]
                    ]
                ]
            ]
          ] ;
          $liamamodel->sendLiama($data); 
    }
   
    
 return true;
   
 
}

}