<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * OptionCommon
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */
 
class OptionCommon extends OptionBase
{
    // settings category
    protected $_categoryName = 'system.common';
    
    public $site_name;
    public $copywrite_name;
    
    public $site_tagline;
    
    public $site_description;
    
    public $site_keywords;
    
    public $clean_urls = 0;
    
    public $site_status = 'online';
    
    public $site_offline_message = 'Application currently offline. Try again later!';
    
    public $api_status = 'online';
    
    public $backend_page_size = 10;
    
    public $customer_page_size = 10;
    
    public $check_version_update = 'yes';
    
    public $default_mailer;
    
    public $company_info;
    
    public $show_backend_timeinfo = 'no';
    
    public $show_customer_timeinfo = 'no';
    public $admin_email  ;
    public $facebook_url  ;
    public $linked_in  ;
    public $twitter_url  ;
    public $youtube_channel_url  ;
    public $google_plus_url  ;
    public $pinterest_url  ;
    public $google_analytics_code  ;
    public $home_meta_title ="Please Change your home meta title" ;
    public $home_meta_keywords  ="Please Change your home meta keyword" ;
    public $home_meta_description  ="Please Change your home description title" ;
    public $defalut_currency  ;
    public $facebook_app_id  ;
    public $facebook_seceret_key  ;
    public $facebook_response_url  ;
    public $fav_ico  ;
    public $hide_projects_from_top_menu  ;
    
    public $tiktok_url; 
    public $snapchat_url;
    public $threads_url;
    
    public $logo  ;
    public $smtp_host  ;
    public $smtp_port  ;
    public $smtp_username  ;
    public $smtp_password  ;
    public $support_phone  ;
    public $support_email  ;
    public $contact_phone  ;
    public $alt_phone  ;
    public $contact_email  ;
    public $contact_fax  ;
    public $contact_address  ;
    public $contact_map  ;
    public $commercial_categories  ;
    public $residential_categories  ;
    public $google_map_api_key;
    public $office_timing;
    public $map_link;
    public $list_property_form;
    
    public $mycrm_propertyfinder;
    
    public $google_recaptcha_key;public $abu_dhabi_address;
     public $google_recaptcha_secret;
     public $video_url;public $show_offplan_home;public $show_team_home;public $team_limit_home;public $show_anout_us_home;
      public $show_video; public $long_menu; public $whatsapp_chat;
      public $review_point; 
      public $total_reviews;
      public $banner_title;
      
      public $career_video;
      public $show_career_video;
      public $banner_subtitle;public $show_banner_heading;public $twitter_new; public $carrer_email;  public $list_email; 
      public $show_career_video_as_popup;
      public $review_point_out_5;
      public $about;
      public $telephone;
      public $alt_telephone;
      public $home_video_url;
    public function rules()
    {
        $rules = array(
            array('site_name, copywrite_name,site_tagline, clean_urls, site_status, site_offline_message, api_status, backend_page_size, customer_page_size, default_mailer, show_backend_timeinfo, show_customer_timeinfo,defalut_currency', 'required'),
            array('review_point,total_reviews,contact_map,contact_phone,telephone,alt_telephone,contact_email,contact_fax,contact_address,site_description,support_phone,google_analytics_code,pinterest_url,google_plus_url,smtp_host,smtp_port,smtp_username,smtp_password, facebook_response_url,site_keywords,facebook_url,twitter_url,youtube_channel_url,home_meta_title,home_meta_keywords,home_meta_description,tiktok_url,snapchat_url,threads_url,facebook_app_id,facebook_seceret_key,linked_in,hide_projects_from_top_menu,residential_categories,commercial_categories,google_map_api_key', 'safe'),
            array('clean_urls', 'in', 'range' => array(0, 1)),
            array('site_status, api_status', 'in', 'range' => array('online', 'offline')),
            array('site_offline_message', 'length', 'max' => 250),
            array('admin_email,support_email,carrer_email,list_email', 'email'),
            array('about,alt_phone,home_video_url', 'safe'),
            array('backend_page_size, customer_page_size', 'in', 'range' => array_keys($this->paginationOptions->getOptionsList())),
            array('check_version_update, show_backend_timeinfo, show_customer_timeinfo,hide_projects_from_top_menu,show_video,show_offplan_home,show_career_video_as_popup,show_team_home,long_menu,show_career_video,show_career_video_as_popup', 'in', 'range' => array_keys($this->getYesNoOptions())),
            array('default_mailer', 'in', 'range' => array_keys($this->getSystemMailers())),
            array('company_info,mycrm_propertyfinder,office_timing,map_link,google_recaptcha_key,google_recaptcha_secret,career_video,abu_dhabi_address,video_url,whatsapp_chat,twitter_new,team_limit_home,show_anout_us_home,banner_title,banner_subtitle,show_banner_heading,list_property_form,review_point_out_5', 'safe'),
            array('fav_ico', 'file', 'types'=>'ico'),
            array('logo', 'file', 'types'=>'jpg, gif, png'),
        );
        
        return CMap::mergeArray($rules, parent::rules());    
    }
    public function array_frm(){
        return array(
            ''=>'Listing Your Property',
             '2'=>'Simple Form / Detailed Form'
            );
    }
    public function attributeLabels()
    {
        $labels = array(
            'site_name'             => Yii::t('settings', 'Site name'),
            'snapchat_url'             => Yii::t('settings', 'Pinterest URL'),
            'copywrite_name'             => Yii::t('settings', 'Copyright text'),
            'site_tagline'          => Yii::t('settings', 'Site tagline'),
            'site_description'      => Yii::t('settings', 'Site description'),
            'site_keywords'         => Yii::t('settings', 'Site keywords'),
            'clean_urls'            => Yii::t('settings', 'Clean urls'),
            'site_status'           => Yii::t('settings', 'Site status'),
            'site_offline_message'  => Yii::t('settings', 'Site offline message'),
            'api_status'            => Yii::t('settings', 'Api status'),
            'pinterest_url'         => Yii::t('settings', 'Instagram Url'),
            'google_plus_url'         => Yii::t('settings', 'Linkedin Url'),
            'linked_in'         => Yii::t('settings', 'Whatsapp'),
            'map_link'         => Yii::t('settings', 'Google Map   URL'),
            
            'backend_page_size'     => Yii::t('settings', 'Backend page size'),
            'customer_page_size'    => Yii::t('settings', 'Customer page size'),
            'check_version_update'  => Yii::t('settings', 'Check for new version automatically'),
            'default_mailer'        => Yii::t('settings', 'Default system mailer'),
            'company_info'          => Yii::t('settings', 'Company info'),
            
            'show_backend_timeinfo' => Yii::t('settings', 'Show backend time info'),
            'show_customer_timeinfo'=> Yii::t('settings', 'Show customer time info'),
            'mycrm_propertyfinder'=> Yii::t('settings', 'MyCRM Propertyfinder XML Feed'),
            'contact_address' => 'Office Address',
            'hide_projects_from_top_menu'=> 'Enable Latest Projects Home Page',
            'team_limit_home' => 'Maximum No. of Teams data on home page ',
            'twitter_url' => 'Telegram Link',
            'show_team_home' => 'Show Meet the Team Home',
            'show_anout_us_home' => 'Shouw About Us Home',
            'twitter_new' =>'Twitter URL',
            'carrer_email' => 'Career Email',
            'list_email' => 'List Property Email',
        );
        
        return CMap::mergeArray($labels, parent::attributeLabels());    
    }
    
    public function attributePlaceholders()
    {
        $placeholders = array(
            'site_name'         => Yii::t('app', 'sdfsd'),
            'site_tagline'      => Yii::t('app', 'sdfsdfsdf'),
            'site_description'  => '',
            'site_keywords'     => '',
            'company_info'      => '',
        );
        
        return CMap::mergeArray($placeholders, parent::attributePlaceholders());
    }
    
    public function attributeHelpTexts()
    {
        $texts = array(
            'site_name'             => Yii::t('settings', 'Your site name, will be used in places like logo, emails, etc.'),
            'site_tagline'          => Yii::t('settings', 'A very short description of your website.'),
            'site_description'      => Yii::t('settings', 'Description'),
            'site_keywords'         => Yii::t('settings', 'Keywords'),
            'clean_urls'            => Yii::t('settings', 'Enabling this will remove the index.php part of your urls.'),
            'site_status'           => Yii::t('settings', 'Whether the website is online or offline.'),
            'site_offline_message'  => Yii::t('settings', 'If the website is offline, show this message to users.'),
            'api_status'            => Yii::t('settings', 'Whether the website api is online or offline.'),
            
            'backend_page_size'     => Yii::t('settings', 'How many items to show per page in backend area'),
            'customer_page_size'    => Yii::t('settings', 'How many items to show per page in customer area'),
            'check_version_update'  => Yii::t('settings', 'Whether to check for new application version automatically'),
            'default_mailer'        => Yii::t('settings', 'Choose the default system mailer, please do your research if needed'),
            'company_info'          => Yii::t('settings', 'Your company info, used in places like payment page'),
            
            'show_backend_timeinfo' => Yii::t('settings', 'Whether to show the time info in the backend area'),
            'show_customer_timeinfo'=> Yii::t('settings', 'Whether to show the time info in the customer area'),
        );
        
        return CMap::mergeArray($texts, parent::attributeHelpTexts());
    }

    public function getSiteStatusOptions()
    {
        return array(
            'online'    => Yii::t('settings', 'Online'),
            'offline'   => Yii::t('settings', 'Offline'),
        );
    }
    
    public static function getHomeLinks()
    {
			$html  = '';
            $style="style='color: #d30e7d !important; border-bottom: 9px solid #d30e7d !important;' ";
            $menu="currentmenu='selected'";
            $nstyle="";

            $property_for_sale_class  = $nstyle;
            $property_for_sale_current_menu  = '';
            if (!empty(Yii::app()->controller->activeUrl) and Yii::app()->controller->activeUrl=="property-for-sale") {
                $property_for_sale_class = $style;
                $property_for_sale_current_menu  = $menu;
            }
            
            $property_for_rent_class  = $nstyle;
            $property_for_rent_current_menu  = '';
            if (!empty(Yii::app()->controller->activeUrl) and Yii::app()->controller->activeUrl=="property-for-rent") {
                $property_for_rent_class = $style;
                $property_for_rent_current_menu  =  $menu;
            }
            
            $project_class  = $nstyle;
            $project_current_menu  = '';
            if (!empty(Yii::app()->controller->activeUrl) and Yii::app()->controller->activeUrl=="project") {
                $project_class = $style;
                $project_current_menu  = $menu;
            }
            
            $floor_plan_class  = $nstyle;
            $floor_plan_current_menu  = '';
            if (!empty(Yii::app()->controller->activeUrl) and Yii::app()->controller->activeUrl=="floor-plan") {
                $floor_plan_class = $style;
                $floor_plan_current_menu  = $menu;
            }
            
            $place_an_ad_class  = $nstyle;
            $place_an_ad_current_menu  = '';
            if (!empty(Yii::app()->controller->activeUrl) and Yii::app()->controller->activeUrl=="place_an_ad") {
                $place_an_ad_class = $style;
                $place_an_ad_current_menu  = $menu;
            }



            $home_class = $nstyle;
            $home_current_menu  = '';
            if (!empty(Yii::app()->controller->activeUrl) and Yii::app()->controller->activeUrl=="home") {
                $home_class = $style;
                $home_current_menu  = $menu;
            }
            $about_class = $nstyle;
            $about_current_menu  = '';
            
            if (!empty(Yii::app()->controller->activeUrl) and Yii::app()->controller->activeUrl=="about-us") {
                $about_class = $style;
                $about_current_menu  = $menu;
            }
            $service_class = $nstyle;
            $service_current_menu  = '';
            $service_urls = array('place_an_ad', 'property-for-sale', 'property-for-rent', 'consultation');
            if (!empty(Yii::app()->controller->activeUrl)) {
                if(in_array(Yii::app()->controller->activeUrl, $service_urls)){
                 $service_class = $style;
                 $service_current_menu  = $menu;   
                }
            }
            $pms_class = $nstyle;
            $pms_current_menu  = '';
            if (!empty(Yii::app()->controller->activeUrl) and Yii::app()->controller->activeUrl=="property-management-services") {
                $pms_class = $style;
                $pms_current_menu  = $menu;
            }
            $up_class = $nstyle;
            $up_current_menu  = '';
            if (!empty(Yii::app()->controller->activeUrl) and Yii::app()->controller->activeUrl=="upcoming-projects") {
                $up_class = $style;
                $up_current_menu  = $menu;
            }
            $con_class = $nstyle;
            $con_current_menu  = '';
            if (!empty(Yii::app()->controller->activeUrl) and Yii::app()->controller->activeUrl=="contact") {
                $con_class = $style;
                $con_current_menu  = $menu;
            }
            
            /**/
//  upcoming-projects
            $html .= '<li><a '.$con_class.' '.$con_current_menu.' href="'.Yii::app()->createUrl('contact').'"  class="buy width14per" > <div>Contact Us</div> </a><span>|</span></li>';

            $html .= '<li><a '.$up_class.' '.$up_current_menu.' href="'.Yii::app()->createUrl('projectlist').'"  class="buy width14per" > <div>Projects</div> </a><span>|</span></li>';

            $html .= '<li><a '.$pms_class.' '.$pms_current_menu.' href="'.Yii::app()->apps->getBaseUrl('/property-management').'"   class="buy width22per"><div>Property Management</div> </a><span>|</span></li>';


            
            $html .= '<li class="dropwrp"><a '.$service_class.' '.$service_current_menu.' href="javascript:void(0)"  class="buy width14per" > Properties  </a>
            <span>|</span>
            <ul class="droplist">
                <li> <a href="'.Yii::app()->createUrl('property-for-sale').'"  class="submenu" > Buy </a></li> 
                <li> <a href="'.Yii::app()->createUrl('property-for-rent').'"  class="submenu" > Rent </a></li> 
                <li> <a href="'.Yii::app()->createUrl('place_an_ad').'"  class="submenu" > List your property </a></li> 
                <li> <a href="'.Yii::app()->createUrl('consultation').'"  class="submenu" > Free Consultation </a></li> 
            </ul>
            </li>';
            
    

            $html .= '<li><a '.$about_class.' '.$about_current_menu.' href="'.Yii::app()->createUrl('about-us').'"  class="buy width14per" > <div>About Us</div> </a><span>|</span></li>';

            $html .= '<li><a '.$home_class.' '.$home_current_menu.' href="'.Yii::app()->apps->getBaseUrl('').'"  class="buy width14per" > <div>Home</div> </a></li>';
			
			 /**/

		 
			/*
			$html .= '<li><a href="'.Yii::app()->createUrl('contact').'"  class="buy" > <div>Contact Us</div> </a><span>|</span></li>';
			$html .= '<li><a href="'.Yii::app()->createUrl('about-us').'"  class="buy" > <div>About Us</div> </a><span>|</span></li>';
			$html .= '<li><a href="'.Yii::app()->createUrl('property-management-services').'"   class="buy width180" > <div>Property Management</div> </a><span>|</span></li>';
			//$html .= '<li><a href="'.Yii::app()->createUrl('floor-plan').'" '.$floor_plan_class. ' class="buy" '.$floor_plan_current_menu.' > <div>Floor Plan</div> </a><span>|</span></li>';
			$html .= '<li><a href="'.Yii::app()->createUrl('place_an_ad').'" '.$place_an_ad_class.' class="buy width120"  '.	$place_an_ad_current_menu .'  > <div>List Property</div>  </a><span>|</span></li>';
			if(Yii::app()->options->get('system.common.hide_projects_from_top_menu','no')!= self::TEXT_YES ){
			$html .= '<li><a href="'.Yii::app()->createUrl('project').'"  '.$project_class.' class="buy width185"   '.$project_current_menu.'  > <div>International Properties</div>  </a><span>|</span></li>';
			}
			$html .= '<li><a href="'.Yii::app()->createUrl('property-for-rent').'" '.$property_for_rent_class.' class="buy"  '.$property_for_rent_current_menu.'  > <div>Rent</div> </a><span>|</span></li>';
			$html .= '<li><a href="'.Yii::app()->createUrl('property-for-sale').'" '.$property_for_sale_class.'  class="buy"  '.$property_for_sale_current_menu.'  > <div>Sale</div> </a></li>';
			/**/
			
			return $html;
    }
    public static function property_menu()
    {
			$html  = '';
            $style="style='color: #d30e7d; border-bottom: 9px solid #d30e7d' ";
            $menu="currentmenu='selected'";
            
            $home_class = "";
            $home_current_menu  = '';
            if (!empty(Yii::app()->controller->activeUrl) and Yii::app()->controller->activeUrl=="property-management") {
                $home_class = $style;
                $home_current_menu  = $menu;
            }
            $about_class = "";
            $about_current_menu  = '';
            
            if (!empty(Yii::app()->controller->activeUrl) and Yii::app()->controller->activeUrl=="property-management/about-us") {
                $about_class = $style;
                $about_current_menu  = $menu;
            }
            $service_class = "";
            $service_current_menu  = '';
            $service_urls = array('place_an_ad', 'property-for-sale', 'property-for-rent', 'consultation');
            if (!empty(Yii::app()->controller->activeUrl)) {
                if(in_array(Yii::app()->controller->activeUrl, $service_urls)){
                 $service_class = $style;
                 $service_current_menu  = $menu;   
                }
            }
            $up_class = "";
            $up_current_menu  = '';
            if (!empty(Yii::app()->controller->activeUrl) and Yii::app()->controller->activeUrl=="property-management/free-valuation") {
                $up_class = $style;
                $up_current_menu  = $menu;
            }
            $con_class = "";
            $con_current_menu  = '';
            if (!empty(Yii::app()->controller->activeUrl) and Yii::app()->controller->activeUrl=="property-management/contact-us") {
                $con_class = $style;
                $con_current_menu  = $menu;
            }
            
            /**/

            $html .= '<li><a '.$con_class.' '.$con_current_menu.' href="'.Yii::app()->createUrl(''.Yii::app()->createUrl('property-management/contact-us').'').'"  class="buy width20per" > <div>Contact Us</div> </a><span>|</span></li>';

            $html .= '<li><a '.$up_class.' '.$up_current_menu.' href="'.Yii::app()->createUrl('property-management/free-valuation').'"  class="buy width20per" > <div>Free Valuation</div> </a><span>|</span></li>';
            
            $html .= '<li class="dropwrp"><a '.$service_class.' '.$service_current_menu.' href="javascript:void(0)"  class="buy width20per" > Services  </a>
            <span>|</span>
            <ul class="droplist">
                <li> <a href="javascript:void(0)"  class="submenu" > service1 </a></li>  
                <li> <a href="javascript:void(0)"  class="submenu" > service2 </a></li> 
                <li> <a href="javascript:void(0)"  class="submenu" > service3 </a></li> 
            </ul>
            </li>';
            
    

            $html .= '<li><a '.$about_class.' '.$about_current_menu.' href="'.Yii::app()->createUrl('property-management/about-us').'"  class="buy width20per" > <div>About Us</div> </a><span>|</span></li>';

            $html .= '<li><a '.$home_class.' '.$home_current_menu.' href="'.Yii::app()->apps->getBaseUrl('property-management').'"  class="buy width20per" > <div>Home</div> </a></li>';
			
			 /**/
			 
			return $html;
    }
    public function getSystemMailers()
    {
        static $list;
        if ($list !== null) {
            return $list;
        }
        $list = array();
        $mailers = Yii::app()->mailer->getAllInstances();
        foreach ($mailers as $instance) {
            $list[$instance->name] = $instance->name . ' - ' .$instance->description;
        }
        return $list;
    }
    public function getLanguages(){
        $criteria = LocationLanding::model()->search(1);
        return CHtml::listData(LocationLanding::model()->findAll($criteria),'slug','title');
        
    }
}
