<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * FrontendSystemInit
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */
 
class FrontendSystemInit extends CApplicationComponent 
{
    protected $_hasRanOnBeginRequest = false;
    protected $_hasRanOnEndRequest = false;
    
    public function init()
    {
		 
        parent::init();
        Yii::app()->attachEventHandler('onBeginRequest', array($this, '_runOnBeginRequest'));
        Yii::app()->attachEventHandler('onEndRequest', array($this, '_runOnEndRequest'));
        Yii::app()->urlManager->showScriptName = false;
    }
    
    public function _runOnBeginRequest(CEvent $event)
    {
		
        if ($this->_hasRanOnBeginRequest) {
            return;
        }

        // register core assets if not cli mode and no theme active
        if (!MW_IS_CLI && (!Yii::app()->hasComponent('themeManager') || !Yii::app()->getTheme())) {
		 
            $this->registerAssets();
        }
        else
        {
			 
			$this->registerAssets();
		}
        // and mark the event as completed.
        $this->_hasRanOnBeginRequest = true;
    }
    
    public function _runOnEndRequest(CEvent $event)
    {
        if ($this->_hasRanOnEndRequest) {
            return;
        }

        // and mark the event as completed.
        $this->_hasRanOnEndRequest = true;
    }
    
    public function registerAssets()
    {
        Yii::app()->hooks->addFilter('register_scripts', array($this, '_registerScripts'));
        Yii::app()->hooks->addFilter('register_styles', array($this, '_registerStyles'));
    }
    
    public function _registerScripts(CList $scripts)
    {
		  
		$apps = Yii::app()->apps;
		$assetsUrl  =  $apps->getBaseUrl('frontend/assets/capstone');
		$cs=Yii::app()->clientScript;
		$cs->scriptMap=array(
		'jquery.js'=>  'https://code.jquery.com/jquery-1.9.1.js',    
		'jquery.min.js'=> 'https://code.jquery.com/jquery-1.9.1.js',  
		);

        $scripts->mergeWith(array(
           
          
             
           // array('src' => AssetsUrl::js('jquery-ui.min.js'), 'priority' => -1000),
          //  array('src' => AssetsUrl::js('reservetrip.js'), 'priority' => -1000),         
          //  array('src' => AssetsUrl::js('modernizr.custom.79639.js'), 'priority' => -1000),         
          //  array('src' => AssetsUrl::js('drop.js'), 'priority' => -1000),         
       //  array('src' =>  ('http://ajax.googleapis.com/ajax/libs/jquery/1.7.2/jquery.min.js'), 'priority' =>  1000),         
           // array('src' => AssetsUrl::js('cycle.js'), 'priority' => -1000),         
          //  array('src' => AssetsUrl::js('common.js'), 'priority' => -1000),         
          //  array('src' => AssetsUrl::js('jquery.jqtransform.js'), 'priority' => -1000),  
   
		       
        ));  
        return $scripts;
    }
    
    public function _registerStyles(CList $styles)
    {
	 
        $apps = Yii::app()->apps;
        $styles->mergeWith(array(
            array('src' => $apps->getBaseUrl('assets/css/common.css?q=2'), 'priority' => -1000),
                // array('src' => AssetsUrl::css('_drop.css'), 'priority' => -1000),
                // array('src' => AssetsUrl::css('jqtransform.css'), 'priority' => -1000),
                //      array('src' => $apps->getBaseUrl('assets/css/box.css'), 'priority' => -1000),
                     
                
        ));
        return $styles;
    }
}
