<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * Controller
 * 
 * @package RedSpider EMA
 * @author Rauf Ahmad <ahmad@redspider.ae> 
 * @link https://www.redspider.ae/
 * @copyright 2013-2017 RedSpider EMA (https://www.redspider.ae)
 * @license https://www.redspider.ae/license/
 * @since 1.0
 */
 
class Controller extends BaseController
{
	public $request ; 
	public $options ; 
	public $apps ; 
	public $app  ; 
	public $project_name ; 
	public $fav_count ; 
	public $header_class; 
	public $place_ad_url; 
		public $long_menu; 
	public $default_img='data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAAAQABAAD/2wCEAAEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAf/AABEIAAUACgMBEQACEQEDEQH/xAGiAAABBQEBAQEBAQAAAAAAAAAAAQIDBAUGBwgJCgsQAAIBAwMCBAMFBQQEAAABfQECAwAEEQUSITFBBhNRYQcicRQygZGhCCNCscEVUtHwJDNicoIJChYXGBkaJSYnKCkqNDU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6g4SFhoeIiYqSk5SVlpeYmZqio6Slpqeoqaqys7S1tre4ubrCw8TFxsfIycrS09TV1tfY2drh4uPk5ebn6Onq8fLz9PX29/j5+gEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoLEQACAQIEBAMEBwUEBAABAncAAQIDEQQFITEGEkFRB2FxEyIygQgUQpGhscEJIzNS8BVictEKFiQ04SXxFxgZGiYnKCkqNTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqCg4SFhoeIiYqSk5SVlpeYmZqio6Slpqeoqaqys7S1tre4ubrCw8TFxsfIycrS09TV1tfY2dri4+Tl5ufo6ery8/T19vf4+fr/2gAMAwEAAhEDEQA/APH9Nt/jf4ts/gB8cvBv7Qvjf4b2HxKitvh1r3w40WO5j8Py6bqVinhXxNJLqHhzXPB9/cx69p8UMjB1TVbe6iWebW76QKyfNUXVzHDwxcqrw0swjUyyp9VhTozjhptKrT54xtUp1YrlqUqkGppLmcldPLEYyarxoOKq0qVSjiYwrP2kPbKK5aiSUGpxbbUua6bbW59Ny/Ejx/4elk0CG90GeHQ5H0eKeSHx6Xmj0xjZJK5uPiTdTl5FgDsZrm4lJJMk8r7pG8Ofh/lLnN/2jnkbyl7tPGYanTjq/dp04YFQpwW0YRSjCNoxSSR1/wCtuNh7jo024e7dVKqvy6XtKU5a2+1OT7yk9X//2Q==';

	 
	public function Init(){ 
		parent::init();
		$this->request = Yii::app()->request; 
		$this->options = Yii::app()->options; 
		$this->header_class = 'inner_header' ; 
		$this->layout = 'main'; 
		$this->app  = Yii::app(); 
		$this->apps = Yii::app()->apps; 
		$this->project_name = $this->generateCommon('site_name'); 
		$this->long_menu  = $this->generateCommon('long_menu');
		if($this->options->get('system.common.list_property_form')=='2'){
		    $this->place_ad_url = $this->app->createUrl('list_your_property/index');
		}else{
		    $this->place_ad_url = $this->app->createUrl('place_an_ad/index');
		}
		$this->fav_count  =  0 ; 
			if((isset(Yii::app()->request->cookies['USERFAV2'])   )){
				$data =  Yii::app()->request->cookies['USERFAV2']->value;
				$this->fav_count  = (int) sizeOf($data);
			}
		 
	}
	public function getAssetPath($path){
		return $this->apps->getBaseUrl('frontend/assets/capstone/'.$path);
	}
	public function front_asset($path){
		return $this->apps->getBaseUrl('frontend/assets/kaye/'.$path);
	}
	
	public function generateCommon($field, $default='system.common.',$default_value=null){
		$Val = $this->options->get($default.$field,'') ;
		return (empty($Val )) ? $default_value : $Val ;
	}
	public function file_path_uploaded($file){
		return $this->apps->getBaseUrl('uploads/files/'.$file);
	}
	public function departmentLis(){
		return 'javascript:void(0)';
	}
	 
}
