<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * UserIdentity
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */
 
class UserIdentity extends BaseUserIdentity
{
    
    public function authenticate()
    {
        $user = ListingUsers::model()->findByAttributes(array(
            'email'     => $this->email,
            'status'    => 'A',
        ));
 
        if (empty($user) || !Yii::app()->passwordHasher->check($this->password, $user->password)) {
            $this->errorCode = Yii::t('users', 'Invalid login credentails.');
            return !$this->errorCode;
        }
         $this->setState('username', $user->first_name);
        $this->setId($user->user_id);
        $this->setAutoLoginToken($user);
        
        $this->errorCode = self::ERROR_NONE;
        return !$this->errorCode;
    }
    
    public function setAutoLoginToken(ListingUsers $user)
    {
        $token = sha1(uniqid(rand(0, time()), true));
        $this->setState('__booking_user_auto_login_token', $token);
        
        ListingUserAutoLoginToken::model()->deleteAllByAttributes(array(
            'user_id' => (int)$user->user_id,
        ));  
        
        $autologinToken             = new ListingUserAutoLoginToken();
        $autologinToken->user_id    = (int)$user->user_id;
        $autologinToken->token      = $token;
        $autologinToken->save(); 
        
        return $this;
    }
      public function authenticateSocial($email)
    {
		 
        $user = ListingUsers::model()->findByAttributes(array(
            'email'     => $email,
            'status'    => 'A',
        ));
 
        
        $this->setState('username', $user->first_name);
        $this->setId($user->user_id);
  
        $this->setAutoLoginToken($user);
        $identity = new UserIdentity("vineethnjalil@gmail.com", "123456");
         
        Yii::app()->user->login( $identity ,  3600 * 24 * 30  );
        $this->errorCode = self::ERROR_NONE;
        return !$this->errorCode;
    }

}
