<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * ArticlesController
 * 
 * Handles the actions for artciles related tasks
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */
 
class ArticlesController extends Controller
{
    /**
     * List available published articles 
     */
  public $headerImage;
    public function actionIndex()
    {
		
        $criteria = new CDbCriteria();
        $criteria->compare('status', Article::STATUS_PUBLISHED);
        $criteria->order = 'article_id DESC';
        
        $count = Article::model()->count($criteria);
        
        $pages = new CPagination($count);
        $pages->pageSize = 10;
        $pages->applyLimit($criteria);
        
        $articles = Article::model()->findAll($criteria);
        
        $this->setData(array(
            'pageMetaTitle'     => $this->data->pageMetaTitle.' | '.Yii::t('articles', 'Helpful articles'), 
            'pageBreadcrumbs'   => array()
        ));

        $this->render('index', compact('articles', 'pages'));
    }
    
    /**
     * List available published articles belonging to a category
     */
    public function actionCategory($slug)
    {
        
        $category = $this->loadCategoryModel($slug);
        
        $criteria = new CDbCriteria();
        $criteria->compare('t.status', Article::STATUS_PUBLISHED);
        $criteria->with = array(
            'activeCategories' => array(
                'select'    => 'activeCategories.category_id',
                'together'  => true,
                'joinType'  => 'INNER JOIN',
                'condition' => 'activeCategories.category_id = :cid',
                'params'    => array(':cid' => $category->category_id),
            )
        );
    
           $criteria->order = '-t.priority desc,t.article_id asc';
        $count = Article::model()->count($criteria);
       
      if($slug=='our-teams'){
          $limit  = 250; 
      }
      else { 
        $limit  = 15; 
      }
        $pages = new CPagination($count);
        $pages->pageSize =  $limit;
        $pages->applyLimit($criteria);
        
        
        $articles = Article::model()->findAll($criteria);

        $this->setData(array(
            'pageMetaTitle'         =>  $category->name. ' | ' . $this->data->pageMetaTitle ,
            'pageMetaDescription'   => StringHelper::truncateLength($category->description, 150),
        ));
        
        Yii::app()->clientScript->registerLinkTag('canonical', null, $this->createAbsoluteUrl($this->route, array('slug' => $slug)));
        Yii::app()->clientScript->registerLinkTag('shortlink', null, $this->createAbsoluteUrl($this->route, array('slug' => $slug)));
        $view = 'category';
        if($slug=='news-media'){
          $banner = Banner::model()->getBannerById(24);  
        }
        if($slug=='our-teams'){
        $view = 'category_team';
        }
        $this->render($view, compact('category', 'articles', 'pages','banner'));
    }
       public function actionOur_teams($slug='our-teams')
    {
        
        $category = $this->loadCategoryModel($slug);
        
        $criteria = Teams::model()->search(1);
        $criteria->compare('t.status', Article::STATUS_PUBLISHED); 
       $criteria->order = '-t.priority desc,t.article_id asc';
        $count = Teams::model()->count($criteria);
       
        $limit  = 250; 
        $pages = new CPagination($count);
        $pages->pageSize =  $limit;
        $pages->applyLimit($criteria);
        
        
        $articles = Teams::model()->findAll($criteria);

        $this->setData(array(
            'pageMetaTitle'         =>  $category->name. ' | ' . $this->data->pageMetaTitle ,
            'pageMetaDescription'   => StringHelper::truncateLength($category->description, 150),
        ));
        
        Yii::app()->clientScript->registerLinkTag('canonical', null, $this->createAbsoluteUrl($this->route, array('slug' => $slug)));
        Yii::app()->clientScript->registerLinkTag('shortlink', null, $this->createAbsoluteUrl($this->route, array('slug' => $slug)));
         
        
        $view = 'category_team';
       
        $this->render($view, compact('category', 'articles', 'pages','banner'));
    }
    public function actionTeam($slug='our-teams',$name=null)
    {
         
        $category = $this->loadCategoryModel($slug);
        
        $criteria = Teams::model()->search(1);
        $criteria->compare('t.status', Article::STATUS_PUBLISHED); 
       $criteria->order = '-t.priority desc,t.article_id asc';
        $count = Teams::model()->count($criteria);
       
        $limit  = 250; 
        $pages = new CPagination($count);
        $pages->pageSize =  $limit;
        $pages->applyLimit($criteria);
        
        
        $criteria = Teams::model()->search(1);
        $criteria->compare('t.slug',$name);
        $article = Teams::model()->find($criteria);
        if(empty($article)){
            throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
        }
        $this->setData(array(
            'pageMetaTitle'         =>  $article->title. ' | ' . $this->data->pageMetaTitle ,
            'pageMetaDescription'   => StringHelper::truncateLength($article->content, 150),
        ));
         $apps = Yii::app()->apps;    
             $this->getData('pageStyles')->add(array('src' => $apps->getBaseUrl('assets/js/swiper/swiper-bundle.min.css')));
    $this->getData('pageScripts')->add(array('src' => $apps->getBaseUrl('assets/js/swiper/swiper-bundle.min.js')));
        
        $view = 'team_detail';
       
       $properties =array();$for_sale= '0';$for_rent= '0';$customer =array();
       /*Properties Managed*/ 
       if(!empty($article->r_customer)){
           $customer = ListingUsers::model()->findByPk($article->r_customer);
           $adModel = new PlaceAnAd();
        $order  = 't.id    desc' ; 
        $apps= Yii::app()->apps;
        $criteria = $adModel->findAds(array('sort'=>'custom','custom_order'=>$order),false,1,false,false);
        $criteria->order = $order;
        $criteria->condition .= ' and t.user_id   = :thisid   ';
        $criteria->params[':thisid'] = $article->r_customer; 
        $criteria->limit  = 6;   
        $properties =$adModel->findAll($criteria);
        
     $this->getData('pageScripts')->add(array('src' => "https://cdn.jsdelivr.net/npm/lozad/dist/lozad.min.js"));
     
        if(!empty($properties)){
                    $newCriteria = clone $criteria;  $newCriteria->select='count(t.id) as id ';
                    $newCriteria->group = 't.section_id';
                    $newCriteria->condition .= ' and t.section_id = 1 '; 
                    $for_sale = $adModel->findAll($newCriteria);
                    
                    
                    $newCriteria = clone $criteria; $newCriteria->select='count(t.id) as id';
                    $newCriteria->group = 't.section_id';
                    $newCriteria->condition .= ' and t.section_id = 2'; 
                    $for_rent = $adModel->findAll($newCriteria);
        }
     
     
       }
       /*end*/
       
       
        $this->render($view, compact('category', 'article' , 'properties','for_sale','for_rent','customer'));
    }
    /**
     * View a single article details
     */
    public function actionView($slug)
    {
       
		$this->headerImage  =  Yii::app()->theme->baseUrl.'/images/about.jpg'; 
		 //$this->getData('pageStyles')->add(array('src' => AssetsUrl::css('style.css')));
        $article = $this->loadArticleModel($slug);
        if(empty($article))
		{
		  
			throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
		 }
		 
        $this->setData(array(
            'pageMetaTitle'         => $this->data->pageMetaTitle . ' | ' . $article->title,
            'pageMetaDescription'   => StringHelper::truncateLength($article->content, 150),
        ));
        	$categoryModel =  $article->findCategoryThis;
        	
        	if(!empty($categoryModel) and $categoryModel->category_id=='4' ){
				   $banner = Banner::model()->getBannerById(24);  
				$view = 'view_blog';
				} else{
					$view = 'view';
				}
		  $teams = array();
		if($slug=='about-us'){
		 	$view = 'about_us'; define('SHARE_LEFT',1);
		 	$this->header_class = 'inner_header inner_header_2' ;
		 	
		 	 
   
        $criteria = Teams::model()->search(1);
        $criteria->compare('t.status', Article::STATUS_PUBLISHED);
        $criteria->order = '-t.priority desc,t.article_id asc'; 
        $criteria->limit =$this->app->options->get('system.common.team_limit_home',10);
     
        $teams = Teams::model()->findAll($criteria);
        $apps = Yii::app()->apps;    
       $this->getData('pageStyles')->add(array('src' => $apps->getBaseUrl('assets/js/swiper/swiper-bundle.min.css')));
    $this->getData('pageScripts')->add(array('src' => $apps->getBaseUrl('assets/js/swiper/swiper-bundle.min.js')));
    
		}
		
		
        //Yii::app()->clientScript->registerLinkTag('canonical', null, $this->createAbsoluteUrl($this->route, array('slug' => $slug)));
        //Yii::app()->clientScript->registerLinkTag('shortlink', null, $this->createAbsoluteUrl($this->route, array('slug' => $slug)));
         
        
        $this->setData(array(
	'pageMetaTitle'         => $article->page_title , 
	'pageMetaDescription'   => $this->options->get('system.meta.home_description','') ,
	'pageMetaKeywords'   => $this->options->get('system.meta.home_keywords','') ,
	));
	
	 
        $this->render($view  , compact('article','categoryModel','banner','teams'));
    }
    public function actionProperty_management_services()
    {
		 
		$this->headerImage  =  Yii::app()->theme->baseUrl.'/images/about.jpg'; 
		$this->layout =  Yii::app()->LayoutClass->layoutpath("detail"); 
		//$this->getData('pageStyles')->add(array('src' => AssetsUrl::css('style.css')));
        
		 
 
     //   Yii::app()->clientScript->registerLinkTag('canonical', null, $this->createAbsoluteUrl($this->route, array('slug' => $slug)));
       // Yii::app()->clientScript->registerLinkTag('shortlink', null, $this->createAbsoluteUrl($this->route, array('slug' => $slug)));
        $this->setData(array(
            'pageTitle'     => 'Property management services', 
            'metaDescription'   => 'Property management services',
            'metaKeywords'   => 	'Property management services',
        ));
        $this->render('property-management-services');
    }
   
    
    /**
     * Helper method to load the category AR model
     */
    public function loadCategoryModel($slug)
    {
         
        $model = ArticleCategory::model()->findByAttributes(array(
            'slug'      => $slug,
            'status'    => Article::STATUS_ACTIVE
        ));
        
        if ($model === null) {
            throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
        }
        
        return $model;
    }
    
    /**
     * Helper method to load the article AR model
     */
    public function loadArticleModel($slug)
    {
        $model = Article::model()->findByAttributes(array(
            'slug'      => $slug,
            'status'    => Article::STATUS_PUBLISHED
        ));
        
        if ($model === null) {
            throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
        }
        
        return $model;
    }
       public function actionReviews($slug='testimonials')
    {
   
        $category = $this->loadCategoryModel($slug);
        
        $criteria = Reviews::model()->search(1);
        $criteria->compare('t.status', Article::STATUS_PUBLISHED); 
       $criteria->order = '-t.priority desc,t.article_id asc';
        $count = Reviews::model()->count($criteria);
       
        $limit  = 25; 
        $pages = new CPagination($count);
        $pages->pageSize =  $limit;
        $pages->applyLimit($criteria);
        
        
        $articles = Reviews::model()->findAll($criteria);

        $this->setData(array(
            'pageMetaTitle'         =>  $category->name. ' | ' . $this->data->pageMetaTitle ,
            'pageMetaDescription'   => StringHelper::truncateLength($category->description, 150),
        ));
        
        Yii::app()->clientScript->registerLinkTag('canonical', null, $this->createAbsoluteUrl($this->route, array('slug' => $slug)));
        Yii::app()->clientScript->registerLinkTag('shortlink', null, $this->createAbsoluteUrl($this->route, array('slug' => $slug)));
         
        
        $view = 'list_reviews';
       
        $this->render($view, compact('category', 'articles', 'pages','banner'));
    }
        public function actionCareer($success=false)
    {
        
		$article = $this->loadCategoryModel('career-1');
        if(empty($article))
		{
			 
		  
			throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
		 }
		 define('SHARE_LEFT',1);
		 
		$this->headerImage  =  Yii::app()->theme->baseUrl.'/images/contact_.jpg';
	//	$this->layout =   Yii::app()->LayoutClass->layoutpath("detail"); 
		$model = new CareerNew('insert');;
		if (isset($_POST['ajax'])) {
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
	 
        if (Yii::app()->request->isPostRequest && ($attributes = (array)Yii::app()->request->getPost($model->modelName, array()))) {
 
					$model->attributes=$attributes;
						$model->phone=$attributes['phone'];
					 
				     
				     if($model->save())
				     {
							  
							    $this->redirect(Yii::App()->createUrl('send-cv').'#send');
							 
						 }
						 else
						 {
							 Yii::app()->user->setFlash('error',"Your  form has following errors");
								 
						 }
					  
				    // $fileName = "{$this->currentDate()}-{$uploadedFile}";
				    
					//if($model->save())
					//$this->redirect(array('view','id'=>$model->id));
		}

		 
     
        $this->setData(array(
            'pageMetaTitle'     =>Yii::app()->options->get('system.common.site_name').' | '.Yii::t('articles', 'Career'), 
            'pageBreadcrumbs'   => array()
        ));
           $this->setData(array(
            'pageTitle'     =>'Careers', 
            'pageMetaDescription'   => 'Careers', 
            'metaKeywords'   => 'Careers', 
        )); 
        
                 $apps = Yii::app()->apps;    
             $this->getData('pageStyles')->add(array('src' => $apps->getBaseUrl('assets/js/build/css/intlTelInput.css')));
    $this->getData('pageScripts')->add(array('src' => $apps->getBaseUrl('assets/js/build/js/intlTelInput.js')));
    		 $this->getData('pageScripts')->add(array('src' =>Yii::app()->apps->getBaseUrl('assets/js/dropzone.min.js')));
		$this->getData('pageStyles')->add(array('src' =>Yii::app()->apps->getBaseUrl('assets/css/dropzone.css')));
        $this->render("//career/index", compact('model','article','success'));
    }
    	 public function actionValidatefrm(){
		$model = new CareerNew;
		if (isset($_POST['ajax'])) {
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
	} 
}
