<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * SiteController
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */
 
class DevelopersController extends Controller
{
	public $activeUrl;
    public function actionIndex()
    {
	 $this->activeUrl ="";
	 $model = new Developers;
	 $criteria=new CDbCriteria;
	 $criteria->condition = "isTrash='0' and status='A'" ;
	 $count=Developers::model()->count($criteria);
     $pages=new CPagination($count);
     $pages->pageSize=10;
     $pages->applyLimit($criteria);
     $criteria->order = "developer_name";
     $models=Developers::model()->findAll($criteria);
	 $this->layout =   Yii::app()->LayoutClass->layoutpath("listing");
	 $this->setData(array('pageMetaDescription'     =>'Estate Broker in Dubai - Buy, sell, rent Real Estate in Dubai - Leading and awarded real estate in Dubai that provides residential and commercial properties.  We offer exclusive apartments, villas and offices', 'pageMetaTitle'     => 'Real Estate Developers in Dubai',  ));
	 $this->render(Yii::app()->LayoutClass->viewpath("index"),compact('models','pages'));
  
    }
    
    public function actionOffline()
    {
        if (Yii::app()->options->get('system.common.site_status') !== 'offline') {
            $this->redirect(array('site/index'));
        }
        
        throw new CHttpException(503, Yii::app()->options->get('system.common.site_offline_message'));
    }
    
    public function actionError()
    {
		 
        if ($error = Yii::app()->errorHandler->error) {
            if (Yii::app()->request->isAjaxRequest) {
                echo CHtml::encode($error['message']);
            } else {
                $this->setData(array(
                    'pageMetaTitle'         => Yii::t('app', 'Error {code}!', array('{code}' => $error['code'])), 
                    'pageMetaDescription'   => $error['message'],
                ));
                $this->render('error', $error) ;
            }    
        }
    }
 

}
