<?php
require_once('vendor/autoload.php');

function renderProjectDataAsTable2($data, $level = 0)
{
    $html = '<table class="table table-bordered table-sm table-striped" style="margin-top:10px;">';

    foreach ($data as $key => $value) {
        $html .= '<tr>';
        $html .= '<td><strong>' . htmlspecialchars($key) . '</strong></td>';
        $html .= '<td>';

        if (is_array($value)) {
            if (isset($value[0]) && is_array($value[0])) {
                foreach ($value as $index => $item) {
                    $html .= "<div class='mb-2'><strong>Item " . ($index + 1) . "</strong>";
                    $html .= renderProjectDataAsTable2($item, $level + 1);
                    $html .= "</div>";
                }
            } else {
                $html .= renderProjectDataAsTable2($value, $level + 1);
            }
        } elseif (is_object($value)) {
            $html .= renderProjectDataAsTable2((array)$value, $level + 1);
        } else {
            $html .= htmlspecialchars((string)$value);
        }

        $html .= '</td></tr>';
    }

    $html .= '</table>';
    return $html;
}

function formatProjectsAsTable($jsonData)
{
    $data = json_decode($jsonData, true);

    if (!isset($data['items']) || !is_array($data['items'])) {
        return "<p>No valid items found.</p>";
    }

    $html = '<table class="table table-bordered table-hover">';
    $html .= '<thead class="thead-dark">
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Area</th>
                    <th>Status</th>
                    <th>Sale Status</th>
                    <th>Completion</th>
                    <th>Min Price (AED)</th>
                    <th>Post Handover</th>
                    <th>Escrow</th>
                    <th>Image / Action</th>
                </tr>
              </thead>';
    $html .= '<tbody>';

    foreach ($data['items'] as $item) {
        $projectId = htmlspecialchars($item['id']);
        $collapseId = 'collapse_' . $projectId;

        $image = '';
        if (isset($item['cover_image_url'])) {
            $coverImage = json_decode($item['cover_image_url'], true);
            if (json_last_error() === JSON_ERROR_NONE && isset($coverImage['url'])) {
                $image = '<img src="' . htmlspecialchars($coverImage['url']) . '" width="100" class="img-fluid">';
            }
        }

        // Sub-details API call
        $client = new \GuzzleHttp\Client();
        $response = $client->request('GET', 'https://search-listings-production.up.railway.app/v1/properties/' . $projectId, [
            'headers' => [
                'X-API-Key' => 'reelly-682aec0a-lZrRJKuUhhm5XSENG3zeptXTRwhW5ZtJ',
                'accept' => 'application/json',
            ],
        ]);
        $subDetails = json_decode($response->getBody(), true);

        // ✅ Get architecture array
        $projectArchitecture = [];
        if (!empty($subDetails['architecture']) && is_array($subDetails['architecture'])) {
            $projectArchitecture = $subDetails['architecture'];
        }

        // Main row
        $html .= '<tr>';
        $html .= '<td>' . $projectId . '</td>';
        $html .= '<td>' . htmlspecialchars($item['name']) . '</td>';
        $html .= '<td>' . htmlspecialchars($item['area']) . '</td>';
        $html .= '<td>' . htmlspecialchars($item['status']) . '</td>';
        $html .= '<td>' . htmlspecialchars($item['sale_status']) . '</td>';
        $html .= '<td>' . (!empty($item['completion_datetime']) ? date('Y-m-d', strtotime($item['completion_datetime'])) : '-') . '</td>';
        $html .= '<td>' . (isset($item['min_price_aed']) ? number_format($item['min_price_aed']) : '-') . '</td>';
        $html .= '<td>' . ($item['post_handover'] ? 'Yes' : 'No') . '</td>';
        $html .= '<td>' . ($item['has_escrow'] ? 'Yes' : 'No') . '</td>';
        $html .= '<td>' . $image . '<br><button class="btn btn-sm btn-primary mt-2" data-toggle="collapse" data-target="#' . $collapseId . '">Details</button></td>';
        $html .= '</tr>';

        // Collapsible row for details
        $html .= '<tr class="collapse" id="' . $collapseId . '">';
        $html .= '<td colspan="10" class="bg-light">';

        $html .= '<h5>Main Details</h5>';
        $html .= renderProjectDataAsTable2($subDetails);

        // ✅ Architecture section
        if (!empty($projectArchitecture)) {
            $html .= '<h5 class="mt-4">Architecture Items</h5><ul>';
            foreach ($projectArchitecture as $index => $archItem) {
                $html .= '<li><strong>Item ' . ($index + 1) . '</strong>';
                if (is_array($archItem)) {
                    $html .= renderProjectDataAsTable2($archItem);
                } else {
                    $html .= htmlspecialchars((string)$archItem);
                }
                $html .= '</li>';
            }
            $html .= '</ul>';
        }

        $html .= '</td></tr>';
    }

    $html .= '</tbody></table>';
    return $html;
}

// Fetch projects
$client = new \GuzzleHttp\Client();
$response = $client->request('GET', 'https://search-listings-production.up.railway.app/v1/properties', [
    'headers' => [
        'X-API-Key' => 'reelly-682aec0a-lZrRJKuUhhm5XSENG3zeptXTRwhW5ZtJ',
        'accept' => 'application/json',
    ],
]);
$responseBody = $response->getBody();
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Project Listings</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body class="container py-4">
    <h2 class="mb-4">Project Listings</h2>
    <?= formatProjectsAsTable($responseBody); ?>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>